/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.factory;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.storage.protection.replica.factory.SnapshotReplicaFactory;
import com.huawei.ism.drm.storage.sdk.model.NasCloneParam;
import com.huawei.ism.drm.storage.util.NasCloneUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

public class NasSnapshotConeReplicaFactory
extends SnapshotReplicaFactory {
    private static final Log LOGGER = LogFactory.getInstance(NasSnapshotConeReplicaFactory.class);

    @Override
    public int getFactoryType() {
        return 14;
    }

    @Override
    public ProtectGroupReplica createReplica(ProtectGroupReplica sourceReplica) {
        String mountConfigs = sourceReplica.getProperty("mountConfigs");
        MountConfiguration mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        NasCloneParam nasCloneParam = new NasCloneParam();
        nasCloneParam.setSharePrefix(mountConfiguration.getSharePrefix());
        nasCloneParam.setShareType(mountConfiguration.getShareType());
        nasCloneParam.setCloneSplitRate(mountConfiguration.getCloneSplitRate());
        nasCloneParam.setTemplateId(mountConfiguration.getTemplateId());
        return NasCloneUtil.cloneFileSystemSnapshot((ProtectGroupReplica)sourceReplica, (NasCloneParam)nasCloneParam, (String)this.buildReplicaName(sourceReplica));
    }

    @Override
    protected void deleteReplica(ProtectGroupReplica replica, boolean isNeedSendAlarm) {
        if (VerifyUtil.isEmpty((Object)replica)) {
            LOGGER.info((Object)"There are no clone need to delete");
            return;
        }
        this.deleteReplicaClone(replica, isNeedSendAlarm);
    }

    private void deleteReplicaClone(ProtectGroupReplica replica, boolean isNeedSendAlarm) {
        if (!NasCloneUtil.isAirGapSnapshotCloneReplica((ProtectGroupReplica)replica)) {
            LOGGER.info((Object)"Replica is not clone file system.");
            return;
        }
        if (!NasCloneUtil.deleteCloneFileSystem((ProtectGroupReplica)replica, (boolean)isNeedSendAlarm)) {
            LOGGER.error((Object)"Fail to delete clone file system.");
        }
    }
}

