/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.realtime;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.impl.AbstractReplicaRealTimeBuilder;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySnapshotBuilder;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperMetroSnapshotRealTimeBuilder
extends AbstractReplicaRealTimeBuilder {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroSnapshotRealTimeBuilder.class);
    private final String hyperMetroPair = "HyperMetroPairs";
    private final String hyperMetroDeviceSn = "HyperMetroDeviceSn";
    private final String protectLocation2DeviceSnKey = "protectLocation2DeviceSn";
    private final String allWwnKey = "allWwnKey";

    public ProtectGroupReplica buildReplica(ProtectGroup protectGroup, int protectLocation) {
        this.check(protectGroup, protectLocation);
        ExecutionContext context = this.initData(protectGroup);
        Map protectLocaion2DeviceSnMap = (Map)context.getAttribute("protectLocation2DeviceSn", Map.class);
        String srcDevSN = (String)protectLocaion2DeviceSnMap.get(String.valueOf(protectLocation));
        return this.buildBaseReplica(protectGroup, srcDevSN, protectLocation, this.getSiteByArraySn(srcDevSN), this.getStorageResources(protectGroup));
    }

    private ExecutionContext initData(ProtectGroup protectGroup) {
        logger.debug((Object)("initData.pgName:" + protectGroup.getName()));
        ExecutionContext context = new ExecutionContext();
        this.getAllHyperMetroPairs(protectGroup, context);
        this.getHyperMetroDeviceSn(context);
        this.getProtectLocation2DeviceSn(protectGroup, context);
        return context;
    }

    private void check(ProtectGroup protectGroup, int protectLocation) {
        if (protectGroup == null) {
            logger.error((Object)"protectGroup is null!");
            throw new LegoCheckedException(1073947393L);
        }
        if (protectLocation != DrmEnumDefine.ProtectLocation.A_A.getValue() && protectLocation != DrmEnumDefine.ProtectLocation.B_B.getValue()) {
            logger.error((Object)("protectLocation is not right!protectLocation:" + protectLocation));
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void callBackReplica(ProtectGroupReplica replica) {
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.warn((Object)"replica is empty!");
            return;
        }
        new ArraySnapshotBuilder().deleteSnapshotsOnPgr(replica);
    }

    public PolicyTemplateType.PolicyTemplateE getType() {
        return PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_SNAPSHOT;
    }

    private void getAllHyperMetroPairs(ProtectGroup protectGroup, ExecutionContext context) {
        List pairList;
        Set poList = protectGroup.getPolist();
        Set<String> allWwn = this.getAllWwn(poList);
        context.setAttribute("allWwnKey", allWwn);
        IStorageResourceService storageResourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        try {
            pairList = storageResourceService.getHyperMetroPairByWwn(Arrays.asList((String)CommonUtil.getFirstElement(allWwn)), null, true);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"RealTime to query hyperMetro pair error! , error : ", (Throwable)e, e.getErrorCode());
            throw e;
        }
        context.setAttribute("HyperMetroPairs", (Object)pairList);
    }

    private List<StorageResource> getStorageResources(ProtectGroup protectGroup) {
        HashSet<String> allLunWWN = new HashSet<String>();
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObject.getUsedStorageResourceSet()) {
                allLunWWN.add(protectObjectStorageInfo.getLunWWN());
            }
        }
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(allLunWWN.toArray(new String[allLunWWN.size()]));
        return resources;
    }

    private void getHyperMetroDeviceSn(ExecutionContext context) {
        List hyperMetroPairList = (List)context.getAttribute("HyperMetroPairs", List.class);
        HashSet<String> devSnSet = new HashSet<String>();
        for (HyperMetroPair pair : hyperMetroPairList) {
            devSnSet.add(pair.getDevSn());
            logger.debug((Object)("hyper metro pair sn:" + pair.getDevSn()));
        }
        context.setAttribute("HyperMetroDeviceSn", devSnSet);
    }

    private void getProtectLocation2DeviceSn(ProtectGroup protectGroup, ExecutionContext context) {
        Set allDeviceSn = (Set)context.getAttribute("HyperMetroDeviceSn", Set.class);
        HashMap<String, String> site2DeviceSn = new HashMap<String, String>();
        HashMap protectLocation2DeviceSn = new HashMap();
        logger.debug((Object)("allDeviceSn:" + allDeviceSn));
        for (String deviceSn : allDeviceSn) {
            String siteId = this.getSiteByArraySn(deviceSn);
            site2DeviceSn.put(siteId, deviceSn);
        }
        for (Schedule schdule : protectGroup.getTemplate().getSchedules()) {
            String siteID = schdule.getSourceSiteId();
            protectLocation2DeviceSn.put(String.valueOf(schdule.getProtectLocation()), site2DeviceSn.get(siteID));
            logger.debug((Object)("siteId:" + siteID + ", protectLocation:" + schdule.getProtectLocation()));
        }
        context.setAttribute("protectLocation2DeviceSn", protectLocation2DeviceSn);
    }

    private Set<String> getAllWwn(Set<ProtectObject> protectObjects) {
        HashSet<String> allWwn = new HashSet<String>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()));
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo posi : po.getUsedStorageResourceSet()) {
                String lunWWN = posi.getLunWWN();
                if (VerifyUtil.isEmpty((String)lunWWN)) {
                    logger.error((Object)("lunWWN is empty, po is:" + po.getUuid() + "-" + po.getName()));
                    throw new LegoCheckedException(1073948453L);
                }
                allWwn.add(lunWWN);
            }
        }
        logger.debug((Object)("allWwn:" + allWwn));
        return allWwn;
    }

    private ProtectGroupReplica buildBaseReplica(ProtectGroup protectGroup, String srcDevSN, int protectLocation, String siteId, List<StorageResource> resources) {
        logger.debug((Object)("protectGroup Name:" + protectGroup.getName() + ",srcDevSN:" + srcDevSN + ",protectLocation:" + protectLocation + ", siteId:" + siteId));
        ProtectGroupReplica protectGroupReplica = new ProtectGroupReplica();
        protectGroupReplica.setId(UUIDGenerator.getUUID());
        protectGroupReplica.setName("SNAPSHOT-" + protectGroup.getName() + "-" + Calendar.getInstance().getTimeInMillis());
        protectGroupReplica.setType(this.getReplicaType(protectGroup, protectLocation));
        protectGroupReplica.setIndex(1);
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setProtectLocation(protectLocation);
        protectGroupReplica.setRecoverySite(siteId);
        protectGroupReplica.setProductArray(srcDevSN);
        protectGroupReplica.setRecoveryArray(srcDevSN);
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica protectObjectReplica = new ProtectObjectReplica();
            protectObjectReplica.setId(UUIDGenerator.getUUID());
            protectObjectReplica.setPoId(protectObject.getUuid());
            protectObjectReplica.setPgReplica(protectGroupReplica);
            protectObjectReplica.setProtectObject(protectObject);
            this.generateProtectObjectStorageInfo(protectObject, protectObjectReplica, srcDevSN, resources);
            IProtectObjectBaseProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
            provider.backUpPoMetadata(protectObjectReplica);
            protectGroupReplica.getReplicas().add(protectObjectReplica);
        }
        return protectGroupReplica;
    }

    private void generateProtectObjectStorageInfo(ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, String srcDevSN, List<StorageResource> resources) {
        for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObject.getUsedStorageResourceSet()) {
            Lun lunMo = this.getLun(srcDevSN, resources, protectObjectStorageInfo);
            String snapshotName = PolicyTemplateTools.getInstance().generateSnapshotName(lunMo.getLunId());
            String snapshotId = "NONE";
            this.generateLocalStorageReplica(protectObjectReplica, snapshotId, snapshotName, srcDevSN, lunMo);
        }
    }

    private Lun getLun(String srcDevSN, List<StorageResource> resources, ProtectObjectStorageInfo protectObjectStorageInfo) {
        Lun lunMo = null;
        for (StorageResource resource : resources) {
            Lun tmpLunMo = (Lun)resource;
            if (!tmpLunMo.getDevSn().equals(srcDevSN) || !tmpLunMo.getWwn().equals(protectObjectStorageInfo.getLunWWN())) continue;
            lunMo = tmpLunMo;
            break;
        }
        if (null == lunMo) {
            logger.error((Object)("lunMo is null.lunwwn:" + protectObjectStorageInfo.getLunWWN() + ", srcDevSN:" + srcDevSN));
            throw new LegoCheckedException(1073948453L);
        }
        return lunMo;
    }

    private LocalStorageReplica generateLocalStorageReplica(ProtectObjectReplica protectObjectReplica, String snapshotId, String snapshotNm, String srcDevSN, Lun lunMo) {
        LocalStorageReplica localStorageReplica = new LocalStorageReplica();
        localStorageReplica.setId(UUIDGenerator.getUUID());
        localStorageReplica.setSnapshotName(snapshotNm);
        localStorageReplica.setSrcStorageId(lunMo.getLunId());
        localStorageReplica.setSrcStorageProviderSN(srcDevSN);
        localStorageReplica.setStorageId(snapshotId);
        localStorageReplica.setStorageProviderSN(srcDevSN);
        localStorageReplica.setPoReplica(protectObjectReplica);
        localStorageReplica.setProtectObjectStorageWwn(lunMo.getWwn());
        protectObjectReplica.getStorageInfos().add(localStorageReplica);
        logger.debug((Object)("srcDevSN:" + srcDevSN + ", wwn:" + lunMo.getWwn()));
        return localStorageReplica;
    }
}

