/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Array4DCCascadeAsyncAsyncFilter
extends ArraySyncReplicationFilter {
    public static final String KEY_PAIR_MAP = "pairMap";
    public static final String KEY_TGT_LUN_WWN_MAP = "tgtLunWwnMap";
    public static final String KEY_WWN_MAP = "wwnMap";
    public static final String KEY_DEV_SN_SET = "devSnSet";
    public static final String FILTER_CTX_PRODUCT_DEV_SN = "devSn";
    public static final String FILTER_CTX_SITE_A_CONTEXT = "SITE_A_CONTEXT";
    public static final String FILTER_CTX_SITE_B_CONTEXT = "SITE_B_CONTEXT";
    public static final String FILTER_CTX_SITE_C_CONTEXT = "SITE_C_CONTEXT";
    public static final String FILTER_CTX_SITE_INFO_LIST = "siteInfoList";
    private static final String CG_PRE = "CG_";
    private static final String PAIR_PRE = "HY_";
    private static final Log logger = LogFactory.getInstance(Array4DCCascadeAsyncAsyncFilter.class);

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        return this.performCheck(protectObjects, !this.existProtectGroupReplica(protectObjects));
    }

    private boolean performCheck(List<ProtectObject> protectObjects, boolean isCheckPairStatus) {
        if (VerifyUtil.isEmpty(protectObjects)) {
            logger.warn((Object)"the parameter protectObjects is empty!", 90160758786989L);
            logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName()), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        String productDevSn = this.getSrcDevice(protectObjects);
        this.getFilterContext().put(FILTER_CTX_PRODUCT_DEV_SN, productDevSn);
        Set<String> siteAWwnSet = this.getSiteAwwnSet(protectObjects);
        ExecutionContext siteAContext = this.checkSite(productDevSn, siteAWwnSet, 1, isCheckPairStatus);
        Set devSnSetA = (Set)siteAContext.getAttribute(KEY_DEV_SN_SET);
        Map siteATgtWwnMap = (Map)siteAContext.getAttribute(KEY_TGT_LUN_WWN_MAP);
        Map.Entry siteBwwnEntry = (Map.Entry)siteATgtWwnMap.entrySet().stream().findFirst().get();
        String siteBDevSn = (String)siteBwwnEntry.getKey();
        Set siteBWwnSet = (Set)siteBwwnEntry.getValue();
        ExecutionContext siteBContext = this.checkSite(siteBDevSn, siteBWwnSet, 1, isCheckPairStatus);
        Set devSnSetB = (Set)siteBContext.getAttribute(KEY_DEV_SN_SET);
        Map siteBTgtWwnMap = (Map)siteBContext.getAttribute(KEY_TGT_LUN_WWN_MAP);
        Map.Entry siteCwwnEntry = (Map.Entry)siteBTgtWwnMap.entrySet().stream().findFirst().get();
        String siteCDevSn = (String)siteCwwnEntry.getKey();
        Set siteCWwnSet = (Set)siteCwwnEntry.getValue();
        ExecutionContext siteCContext = this.checkSite(siteCDevSn, siteCWwnSet, null, isCheckPairStatus);
        Set devSnSetC = (Set)siteCContext.getAttribute(KEY_DEV_SN_SET);
        List<SiteInfo> siteInfoList = this.checkSiteNum(devSnSetA, devSnSetB, devSnSetC);
        this.checkHyperMetroPair(siteInfoList, siteBDevSn, siteAWwnSet, siteBWwnSet, siteCWwnSet);
        this.getFilterContext().put(FILTER_CTX_SITE_A_CONTEXT, siteAContext);
        this.getFilterContext().put(FILTER_CTX_SITE_B_CONTEXT, siteBContext);
        this.getFilterContext().put(FILTER_CTX_SITE_C_CONTEXT, siteCContext);
        return this.isMatchExtend();
    }

    public void isMatchNotCheckStatus(List<ProtectObject> protectObjects) {
        this.performCheck(protectObjects, false);
    }

    protected String getSrcDevice(List<ProtectObject> protectObjectSet) {
        HashSet<String> providerSN = new HashSet<String>();
        for (ProtectObject po : protectObjectSet) {
            for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
                logger.debug((Object)"Po name: %s, provider sn: %s", new Object[]{po.getName(), po.getProviderSN()});
                providerSN.add(info.getResourceProviderSN());
            }
        }
        if (providerSN.size() > 2) {
            logger.error((Object)("The ProtectObject's device not the same" + StringUtil.arrayToString((Object[])providerSN.toArray())), 90160758786897L);
            throw new LegoCheckedException(1073948192L);
        }
        String devSn = new ArrayList(providerSN).stream().sorted().findFirst().orElse(null);
        logger.info((Object)"provider sn: %s", new Object[]{devSn});
        return devSn;
    }

    protected void checkHyperMetroPair(List<SiteInfo> siteInfoList, String recoveryDevSn, Set<String> ... siteWwnSets) {
        int index = 0;
        SiteInfo hyperSiteInfo = siteInfoList.get(index);
        for (int i = 0; i < siteInfoList.size(); ++i) {
            if (siteInfoList.get(i).getSiteIdSet().size() < 2) continue;
            index = i;
            hyperSiteInfo = siteInfoList.get(index);
            break;
        }
        Set<String> hyperSiteWwnSet = siteWwnSets[index];
        Site hyperSite = this.getSiteFromSn((String)hyperSiteInfo.getDevSnSet().stream().findFirst().get());
        List pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(hyperSite.getServerUuid(), new ArrayList<String>(hyperSiteWwnSet), null, true);
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.warn((Object)"4dc can not fin hypermetro pair!", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        HashSet dupSet = new HashSet();
        pairList.stream().forEach(pair -> {
            if (VerifyUtil.isEmpty((String)pair.getCgId()) || "--".equals(pair.getCgId())) {
                dupSet.add(PAIR_PRE + pair.getId());
            } else {
                dupSet.add(CG_PRE + pair.getCgId());
            }
        });
        if (dupSet.size() != 1) {
            logger.warn((Object)("dupSet size not match:" + dupSet.size()), 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        this.checkHyperMetroSitePreferred(pairList, recoveryDevSn);
    }

    private void checkHyperMetroSitePreferred(List<HyperMetroPair> hmPairList, String recoveryDevSn) {
        Optional<HyperMetroPair> opt = hmPairList.stream().filter(pair -> Objects.equals(recoveryDevSn, pair.getDevSn())).findFirst();
        if (!opt.isPresent()) {
            return;
        }
        if (opt.get().getSyncDirection().intValue() != XveEnumDefine.HC_SYNC_DIRECTION.HC_SYNC_LOCAL_TO_REMOTE.getValue()) {
            logger.warn((Object)"hyper metro pair sync direction is not right.");
            throw new LegoCheckedException(1073948191L);
        }
    }

    protected Set<String> getSiteAwwnSet(List<ProtectObject> protectObjects) {
        HashSet<String> siteAWwnSet = new HashSet<String>();
        ArrayList<ProtectObjectStorageInfo> poStorageInfoList = new ArrayList<ProtectObjectStorageInfo>();
        for (ProtectObject po : protectObjects) {
            if (VerifyUtil.isEmpty((Collection)po.getUsedStorageResourceSet())) {
                logger.error((Object)("PolicyTemplate check protectObject storageInfo is empty, po is:" + po.getUuid() + "-" + po.getName()), 90160758786897L);
                throw new LegoCheckedException(1073948453L);
            }
            for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
                if (poStorageInfoList.contains(poStorageInfo)) continue;
                siteAWwnSet.add(poStorageInfo.getLunWWN());
                poStorageInfoList.add(poStorageInfo);
            }
        }
        if (this.getResourcetype(poStorageInfoList) != DrmEnumDefine.ResourceTypeE.LUN.getValue()) {
            logger.warn((Object)"not lun type.", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        return siteAWwnSet;
    }

    protected ExecutionContext checkSite(String devSn, Set<String> siteWwnSet, Integer checkNum, boolean isCheckPairStatus) {
        ExecutionContext siteContext = this.getContext(devSn, siteWwnSet, checkNum);
        if (null != checkNum) {
            Map sitePairMap = (Map)siteContext.getAttribute(KEY_PAIR_MAP);
            if (sitePairMap.size() != checkNum.intValue()) {
                logger.error((Object)("sitePairMap size not match:" + sitePairMap.size()));
                throw new LegoCheckedException(1073948191L);
            }
            Map siteTgtWwnMap = (Map)siteContext.getAttribute(KEY_TGT_LUN_WWN_MAP);
            if (siteTgtWwnMap.size() != checkNum.intValue()) {
                logger.error((Object)("siteTgtWwnMap size not match:" + siteTgtWwnMap.size()));
                throw new LegoCheckedException(1073948191L);
            }
            for (List pairs : sitePairMap.values()) {
                List filteredPairs;
                Set proDevSnSet = pairs.stream().map(pair -> pair.getSrcDevSN()).collect(Collectors.toSet());
                if (proDevSnSet.size() > 1) {
                    logger.error((Object)("pairs srcDevSN not same:" + proDevSnSet));
                    throw new LegoCheckedException(1073948191L);
                }
                if (!isCheckPairStatus || (filteredPairs = this.getValidStatusReplicationPairs(pairs)).size() == pairs.size()) continue;
                logger.error((Object)"pair status illegal.");
                throw new LegoCheckedException(1073948191L);
            }
        }
        return siteContext;
    }

    private ExecutionContext getContext(String devSn, Set<String> resourceWwnSet, Integer checkNum) {
        ExecutionContext context = new ExecutionContext();
        List<Lun> srcLunList = this.getLunByWwn(devSn, resourceWwnSet);
        HashMap srcLunIdWwnMap = new HashMap();
        HashMap<String, List<Lun>> lunMap = new HashMap<String, List<Lun>>();
        srcLunList.stream().forEach(lun -> {
            ArrayList<Lun> list = (ArrayList<Lun>)lunMap.get(lun.getDevSn());
            if (null == list) {
                list = new ArrayList<Lun>();
                lunMap.put(lun.getDevSn(), list);
            }
            list.add((Lun)lun);
            srcLunIdWwnMap.put(CommUtil.combineString((String[])new String[]{lun.getDevSn(), lun.getResourceId()}), lun.getWwn());
        });
        List<ReplicationPair> pairList = this.getReplicationPairs(checkNum, lunMap);
        HashMap tgtLunIdMap = new HashMap();
        HashMap<String, List<ReplicationPair>> pairMap = new HashMap<String, List<ReplicationPair>>();
        pairList.forEach(pair -> {
            pair.setSrcLunWWN((String)srcLunIdWwnMap.get(CommUtil.combineString((String[])new String[]{pair.getDevSn(), pair.getSrcLunId()})));
            List tmpPairList = pairMap.computeIfAbsent(pair.getTgtDevSN(), list -> new ArrayList());
            tmpPairList.add(pair);
            Set lunIdSet = tgtLunIdMap.computeIfAbsent(pair.getTgtDevSN(), set -> new HashSet());
            lunIdSet.add(pair.getTgtLunId());
        });
        HashMap tgtLunIdWwnMap = new HashMap();
        HashMap<String, Set<String>> tgtLunWwnMap = new HashMap<String, Set<String>>();
        for (Map.Entry entry : tgtLunIdMap.entrySet()) {
            String key = (String)entry.getKey();
            Set lunIdSet = (Set)entry.getValue();
            List<Lun> lunList = this.getLunById(key, lunIdSet);
            lunList.forEach(lun -> tgtLunIdWwnMap.put(CommUtil.combineString((String[])new String[]{lun.getDevSn(), lun.getResourceId()}), lun.getWwn()));
            Set lunWwnSet = lunList.stream().map(Lun::getWwn).collect(Collectors.toSet());
            tgtLunWwnMap.put(key, lunWwnSet);
        }
        this.checkSize(resourceWwnSet, lunMap, pairMap, tgtLunWwnMap);
        HashMap wwnMap = new HashMap();
        pairList.forEach(pair -> wwnMap.put(tgtLunIdWwnMap.get(CommUtil.combineString((String[])new String[]{pair.getTgtDevSN(), pair.getTgtLunId()})), pair.getSrcLunWWN()));
        context.setAttribute(KEY_PAIR_MAP, pairMap);
        context.setAttribute(KEY_TGT_LUN_WWN_MAP, tgtLunWwnMap);
        context.setAttribute(KEY_WWN_MAP, wwnMap);
        context.setAttribute(KEY_DEV_SN_SET, lunMap.keySet());
        return context;
    }

    private void checkSize(Set<String> resourceWwnSet, Map<String, List<Lun>> lunMap, Map<String, List<ReplicationPair>> pairMap, Map<String, Set<String>> tgtLunWwnMap) {
        Collection<Object> list;
        for (Map.Entry<String, List<Lun>> entry : lunMap.entrySet()) {
            list = entry.getValue();
            if (list.size() == resourceWwnSet.size()) continue;
            logger.error((Object)("resourceWwnSet size not match:list size:" + list.size() + " resourceWwnSet.size():" + resourceWwnSet.size()));
            throw new LegoCheckedException(1073948191L);
        }
        for (Map.Entry<String, List<Lun>> entry : pairMap.entrySet()) {
            list = entry.getValue();
            if (list.size() == resourceWwnSet.size()) continue;
            logger.error((Object)("resourceWwnSet size not match:list size:" + list.size() + " resourceWwnSet.size():" + resourceWwnSet.size()));
            throw new LegoCheckedException(1073948191L);
        }
        for (Map.Entry<String, Collection<Object>> entry : tgtLunWwnMap.entrySet()) {
            list = (Set)entry.getValue();
            if (list.size() == resourceWwnSet.size()) continue;
            logger.error((Object)("resourceWwnSet size not match:list size:" + list.size() + " resourceWwnSet.size():" + resourceWwnSet.size()));
            throw new LegoCheckedException(1073948191L);
        }
    }

    private List<ReplicationPair> getReplicationPairs(Integer checkNum, Map<String, List<Lun>> lunMap) {
        ArrayList<ReplicationPair> pairList = new ArrayList<ReplicationPair>();
        if (null != checkNum) {
            for (Map.Entry<String, List<Lun>> entry : lunMap.entrySet()) {
                List<Object> tmpPairList = this.getPairsByLun(entry.getValue().toArray(new Lun[entry.getValue().size()]));
                if (this.getType() == 35 || this.getType() == 36) {
                    tmpPairList = tmpPairList.stream().filter(pair -> pair.getReplicationMode().equals(2)).collect(Collectors.toList());
                }
                pairList.addAll(tmpPairList);
            }
        }
        return pairList;
    }

    private List<Lun> getLunByWwn(String devSn, Set<String> resourceWwnSet) {
        Site site = this.getSiteFromSn(devSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.warn((Object)("can't get site by deviceSN:" + devSn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        List storageResourceList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(resourceWwnSet.toArray(new String[resourceWwnSet.size()]));
        ArrayList<Lun> luns = new ArrayList<Lun>();
        for (StorageResource storageResource : storageResourceList) {
            luns.add((Lun)storageResource);
        }
        return luns;
    }

    private List<Lun> getLunById(String devSn, Set<String> lunIdSet) {
        Site site = this.getSiteFromSn(devSn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.warn((Object)("can't get site by deviceSN:" + devSn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        List storageResourceList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResources(devSn, new ArrayList<String>(lunIdSet), DrmEnumDefine.ResourceTypeE.LUN);
        ArrayList<Lun> luns = new ArrayList<Lun>();
        for (StorageResource storageResource : storageResourceList) {
            luns.add((Lun)storageResource);
        }
        return luns;
    }

    protected List<SiteInfo> checkSiteNum(Set<String> devSnSetA, Set<String> devSnSetB, Set<String> devSnSetC) {
        HashSet<String> siteIdSetA = new HashSet<String>();
        for (String string : devSnSetA) {
            Site site = this.getSiteFromSn(string);
            siteIdSetA.add(site.getSiteId());
        }
        HashSet<String> siteIdSetB = new HashSet<String>();
        for (String string : devSnSetB) {
            Site site = this.getSiteFromSn(string);
            siteIdSetB.add(site.getSiteId());
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String devSn : devSnSetC) {
            Site site = this.getSiteFromSn(devSn);
            hashSet.add(site.getSiteId());
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.addAll(siteIdSetA);
        hashSet2.addAll(siteIdSetB);
        hashSet2.addAll(hashSet);
        if (hashSet2.size() != 4) {
            logger.error((Object)("siteIdSet size not match:" + hashSet2.size()));
            throw new LegoCheckedException(1073948191L);
        }
        List<SiteInfo> siteInfoList = Arrays.asList(new SiteInfo(siteIdSetA, devSnSetA), new SiteInfo(siteIdSetB, devSnSetB), new SiteInfo(hashSet, devSnSetC));
        this.getFilterContext().put(FILTER_CTX_SITE_INFO_LIST, siteInfoList);
        return siteInfoList;
    }

    @Override
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatchNotCheckStatus(protectObjects);
        ExecutionContext siteAContext = (ExecutionContext)this.getFilterContextAttribute(FILTER_CTX_SITE_A_CONTEXT, ExecutionContext.class);
        Map siteAPairMap = (Map)siteAContext.getAttribute(KEY_PAIR_MAP, Map.class);
        ReplicationPair anyPairA = (ReplicationPair)siteAPairMap.values().stream().filter(replicationPairs -> !VerifyUtil.isEmpty((Collection)replicationPairs)).flatMap(Collection::stream).findFirst().get();
        String siteADevSn = anyPairA.getSrcDevSN();
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        if (this.isSetPathExtend()) {
            path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_A.getValue(), siteADevSn, siteADevSn, ""));
        }
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_B.getValue(), siteADevSn, anyPairA.getTgtDevSN(), anyPairA.getReplicationMode().toString()));
        ExecutionContext siteBContext = (ExecutionContext)this.getFilterContextAttribute(FILTER_CTX_SITE_B_CONTEXT, ExecutionContext.class);
        Map siteBPairMap = (Map)siteBContext.getAttribute(KEY_PAIR_MAP, Map.class);
        ReplicationPair anyPairB = (ReplicationPair)siteBPairMap.values().stream().filter(replicationPairs -> !VerifyUtil.isEmpty((Collection)replicationPairs)).flatMap(Collection::stream).findFirst().get();
        if (((Set)siteAContext.getAttribute(KEY_DEV_SN_SET, Set.class)).size() == 2) {
            path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.B_C.getValue(), anyPairB.getSrcDevSN(), anyPairB.getTgtDevSN(), anyPairB.getReplicationMode().toString()));
        }
        if (anyPairB.getReplicationMode() == 1) {
            Collections.reverse(path);
        }
        return path;
    }

    @Override
    public int getType() {
        return 35;
    }
}

