/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.context.PolicyTemplateContext;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayAsyncReplicationFilter;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayHyperMetroFilter;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayHyperMetroAsynReplicationFilter
extends ArrayHyperMetroFilter {
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroAsynReplicationFilter.class);
    private ArrayAsyncReplicationFilter asyncReplicationFilter;

    public ArrayAsyncReplicationFilter getAsyncReplicationFilter() {
        return this.asyncReplicationFilter;
    }

    public void setAsyncReplicationFilter(ArrayAsyncReplicationFilter asyncReplicationFilter) {
        this.asyncReplicationFilter = asyncReplicationFilter;
    }

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        PolicyTemplateContext context = new PolicyTemplateContext();
        if (this.checkFreshHyperMetroHealth(protectObjects, context)) {
            return this.freshMatch(protectObjects, context);
        }
        return this.isMatch(protectObjects, context);
    }

    public boolean isMatchWithoutReplica(List<ProtectObject> protectObjects) {
        PolicyTemplateContext context = new PolicyTemplateContext();
        return this.isMatch(protectObjects, context);
    }

    @Override
    protected void cascadeFilterOperation(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        boolean isNas = this.isNas(protectObjects.get(0));
        List<StorageResource> allStorageResources = this.getStorageResources(protectObjects, context, isNas);
        List<ReplicationPair> allPairs = this.getAllReplicationPair(allStorageResources, isNas ? DrmEnumDefine.ResourceTypeE.NAS.getValue() : DrmEnumDefine.ResourceTypeE.LUN.getValue());
        this.checkAllPairs(allPairs);
        ArrayList<ReplicationPair> allRelatedPairList = new ArrayList<ReplicationPair>(allPairs);
        context.addObject("DR_RING_ALL_RELATED_PAIR_LIST", allRelatedPairList);
        this.getFilterContext().put("DR_RING_ALL_RELATED_PAIR_LIST", allRelatedPairList);
        ProtectGroup pg = protectObjects.get(0).getProtectGroup();
        String pgId = VerifyUtil.isEmpty((Object)pg) ? null : pg.getUuid();
        this.filterReplicationPair(pgId, allPairs);
        if (allPairs.size() == 0) {
            logger.error((Object)"List<ReplicationPair> allPairs size is 0: %s", new Object[]{allPairs});
            throw new LegoCheckedException(1073948191L);
        }
        context.addObject("DR_RING_ALL_VALID_PAIR_LIST", new ArrayList<ReplicationPair>(allPairs));
        HashMap<String, ReplicationPair> lunId2Pair = new HashMap<String, ReplicationPair>();
        String devSn = null;
        String targetLunSn = null;
        ArrayList<StorageResource> targetResList = new ArrayList<StorageResource>();
        for (ReplicationPair pair : allPairs) {
            if (DRRingCommUtil.isCorrectStandby(pair.getDevSn(), pair.getTgtDevSN(), pair)) {
                logger.debug((Object)"Pair status is standby, so no need to check if both lun exist replicate relationship.");
                continue;
            }
            devSn = this.checkBothLunExistReplicationPair(context, devSn, pair);
            this.getFilterContext().put("PRODUCT_DEVSN", devSn);
            this.setLunIdPairMap(lunId2Pair, pair);
            this.checkReplicationMode(pair);
            List repTgtLuns = pair.getRepTgtLuns();
            this.checkTargetLunSize(pair, repTgtLuns);
            ReplicationTargetLun replicationTargetLun = (ReplicationTargetLun)repTgtLuns.get(0);
            this.checkTargetLunPairStatus(replicationTargetLun);
            this.addTargetLun(targetResList, replicationTargetLun);
            targetLunSn = this.checkTargetLunSame(targetLunSn, replicationTargetLun);
            this.getFilterContext().put("TARGET_DEVSN", targetLunSn);
        }
        if (isNas) {
            this.checkVstorePair(allPairs);
        }
        this.checkSite(targetLunSn, context);
        this.checkTargetResExistReplication(targetResList, isNas ? DrmEnumDefine.ResourceTypeE.NAS.getValue() : DrmEnumDefine.ResourceTypeE.LUN.getValue());
        this.checkLunNotExistReplicationPair(allStorageResources, lunId2Pair, devSn);
    }

    private List<StorageResource> getStorageResources(List<ProtectObject> protectObjects, PolicyTemplateContext context, boolean isNas) {
        Set<String> allLunWWN = this.getAllWwn(protectObjects);
        List allStorageResources = isNas ? this.getNasStorageResource(context) : ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(allLunWWN.toArray(new String[0]));
        if (VerifyUtil.isEmpty(allStorageResources)) {
            logger.error((Object)"there is no any StorageResources!");
            throw new LegoCheckedException(1073948175L);
        }
        return allStorageResources;
    }

    private void checkVstorePair(List<ReplicationPair> allPairs) {
        String vstorePiarId = allPairs.iterator().next().getVstorePairId();
        if (VerifyUtil.isEmpty((String)vstorePiarId) || vstorePiarId.startsWith("--")) {
            logger.error((Object)"replicaiton pair not match vstore pair.", 90160758787071L);
            throw new LegoCheckedException(1073948191L);
        }
        for (ReplicationPair pair : allPairs) {
            if (vstorePiarId.equals(pair.getVstorePairId())) continue;
            logger.error((Object)"replicaiton pair not match vstore pair.", 90160758787071L);
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void filterReplicationPair(String pgId, List<ReplicationPair> allPairs) {
        if (pgId == null) {
            this.filterValidStatusReplicationPairs(allPairs);
            return;
        }
        Set<String> currPgResourceIds = this.getCurrPgResourceIds(pgId);
        this.checkAddedPairStatus(pgId, allPairs, currPgResourceIds);
        List<ProtectGroupReplica> pgReplicas = this.queryProtectGroupReplicaByGroup(pgId, allPairs);
        if (VerifyUtil.isEmpty(pgReplicas)) {
            this.filterValidStatusReplicationPairs(allPairs);
            return;
        }
        logger.debug((Object)"Found the pgReplicas ProductArray: %s, getRecoveryArray:%s.", new Object[]{pgReplicas.iterator().next().getProductArray(), pgReplicas.iterator().next().getRecoveryArray(), 90160758786897L});
        for (ProtectGroupReplica protectGroupReplica : pgReplicas) {
            if (!protectGroupReplica.isStorageReplicationReplica()) continue;
            logger.info((Object)"exist remote replica.");
            return;
        }
    }

    private void checkAddedPairStatus(String pgId, List<ReplicationPair> allPairs, Set<String> currPgResourceIds) {
        if (VerifyUtil.isEmpty(currPgResourceIds)) {
            return;
        }
        for (ReplicationPair pair : allPairs) {
            boolean isNewPair = !currPgResourceIds.contains(pair.getSrcLunId()) && !currPgResourceIds.contains(pair.getTgtLunId());
            if (!isNewPair || pair.isStandby() || pair.isNormal()) continue;
            logger.error((Object)"Added pair:%s of pgId:%s is not normal.", new Object[]{pair.getId(), pgId});
            throw new LegoCheckedException(1073948191L);
        }
    }

    private Set<String> getCurrPgResourceIds(String pgId) {
        ProtectGroup currentPg = QueryProtectGroupRefineService.getInstance().getProtectGroupBasicInfo(pgId, true);
        if (currentPg == null || VerifyUtil.isEmpty((Collection)currentPg.getPolist())) {
            return Collections.emptySet();
        }
        return currentPg.getPolist().stream().map(ProtectObject::getUsedStorageResourceSet).flatMap(Collection::stream).filter(Objects::nonNull).map(ProtectObjectStorageInfo::getResourceId).collect(Collectors.toSet());
    }

    protected List<ProtectGroupReplica> queryProtectGroupReplicaByGroup(String pgId, List<ReplicationPair> allPairs) {
        IReplicaService repService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        return repService.queryProtectGroupReplicaByGroup(pgId, null, false);
    }

    private void filterValidStatusReplicationPairs(List<ReplicationPair> allPairs) {
        List filterpairs = this.getValidStatusReplicationPairs(allPairs);
        Iterator<ReplicationPair> it = allPairs.iterator();
        while (it.hasNext()) {
            ReplicationPair pair = it.next();
            if (filterpairs.contains(pair)) continue;
            it.remove();
        }
    }

    protected void checkLunNotExistReplicationPair(List<StorageResource> allStorageResources, Map<String, ReplicationPair> lunId2Pair, String devSn) {
        for (StorageResource resource : allStorageResources) {
            ReplicationPair replicationPair;
            if (null == devSn) {
                logger.error((Object)"devSn is null!");
                throw new LegoCheckedException(1073948191L);
            }
            if (!devSn.equals(resource.getDevSn()) || (replicationPair = lunId2Pair.get(resource.getResourceId())) != null) continue;
            logger.info((Object)("the replication pair is empty!DevSn:" + devSn + ", lunId:" + resource.getResourceId()));
            throw new LegoCheckedException(1073948175L);
        }
    }

    private void checkAllPairs(List<ReplicationPair> allPairs) {
        if (VerifyUtil.isEmpty(allPairs)) {
            logger.error((Object)"there is not any replicationPair!");
            throw new LegoCheckedException(1073948175L);
        }
    }

    protected void checkReplicationMode(ReplicationPair pair) {
        if (pair.getReplicationMode() != 2) {
            logger.error((Object)("the replication mode is not the async[type=2]! type:" + pair.getReplicationMode()));
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkTargetResExistReplication(List<StorageResource> targetResList, Integer resourceType) {
        List<ReplicationPair> tgtLunPairs = this.getAllReplicationPair(targetResList, resourceType);
        if (!VerifyUtil.isEmpty(tgtLunPairs)) {
            logger.error((Object)("tgt lun has replication pairs. srcLunId:" + tgtLunPairs.get(0).getSrcLunId() + ", srcDevSN:" + tgtLunPairs.get(0).getDevSn()));
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void addTargetLun(List<StorageResource> targetResList, ReplicationTargetLun replicationTargetLun) {
        StorageResource res = new StorageResource();
        res.setDevSn(replicationTargetLun.getTgtDevSN());
        res.setResourceId(replicationTargetLun.getTgtLunId());
        targetResList.add(res);
    }

    private void checkTargetLunSize(ReplicationPair pair, List<ReplicationTargetLun> repTgtLuns) {
        if (VerifyUtil.isEmpty(repTgtLuns)) {
            logger.error((Object)("there is no tgtLun:" + pair.getId()));
            throw new LegoCheckedException(1073948461L);
        }
        if (repTgtLuns.size() > 1) {
            logger.error((Object)("the hyper metro lun exist more than one targetLun!srcLunId:" + pair.getSrcLunId()));
            throw new LegoCheckedException(1073948191L);
        }
    }

    private void checkTargetLunPairStatus(ReplicationTargetLun replicationTargetLun) {
        if (!this.getAsyncReplicationFilter().getNormalStatusList().contains(replicationTargetLun.getPairStatus())) {
            logger.error((Object)("tgtLun status is not normal :" + replicationTargetLun.getId() + " name:" + replicationTargetLun.getName() + " status:" + replicationTargetLun.getPairStatus()));
            throw new LegoCheckedException(1073948462L);
        }
    }

    private String checkTargetLunSame(String targetLunSn, ReplicationTargetLun replicationTargetLun) {
        String otherTgtDevSn = replicationTargetLun.getTgtDevSN();
        if (targetLunSn == null) {
            targetLunSn = otherTgtDevSn;
        } else if (!targetLunSn.equals(otherTgtDevSn)) {
            logger.error((Object)("tgtLun is not the same!targetLunSn" + targetLunSn + ", otherTgtDevSn:" + otherTgtDevSn + ". lunId:" + replicationTargetLun.getTgtLunId()));
            throw new LegoCheckedException(1073948191L);
        }
        return targetLunSn;
    }

    protected List<ReplicationPair> getAllReplicationPair(List<StorageResource> allStorageResources, Integer resourceType) {
        HashMap<String, ArrayList<String>> devSn2StorageResourceList = new HashMap<String, ArrayList<String>>();
        for (StorageResource storageResource : allStorageResources) {
            String devSn = storageResource.getDevSn();
            ArrayList<String> resIdList = (ArrayList<String>)devSn2StorageResourceList.get(devSn);
            if (resIdList == null) {
                resIdList = new ArrayList<String>();
                resIdList.add(storageResource.getResourceId());
                devSn2StorageResourceList.put(devSn, resIdList);
                continue;
            }
            resIdList.add(storageResource.getResourceId());
        }
        ArrayList<ReplicationPair> allPairs = new ArrayList<ReplicationPair>();
        for (Map.Entry entry : devSn2StorageResourceList.entrySet()) {
            String devSn = (String)entry.getKey();
            List resIdList = (List)entry.getValue();
            Site site = this.asyncReplicationFilter.getSiteByDeviceSN(devSn);
            if (VerifyUtil.isEmpty((Object)site)) {
                logger.error((Object)("getPairsByNas error, site is null, deviceSN:" + devSn), 90160758787071L);
                return null;
            }
            List<ReplicationPair> pairs = this.asyncReplicationFilter.getPairsByResourceIds(devSn, resIdList, site, resourceType);
            if (null == pairs) {
                logger.error((Object)"pairs is null!");
                throw new LegoCheckedException(1073948191L);
            }
            allPairs.addAll(pairs);
        }
        return allPairs;
    }

    private void setLunIdPairMap(Map<String, ReplicationPair> lunId2Pair, ReplicationPair pair) {
        String srcLunId = pair.getSrcLunId();
        ReplicationPair otherPair = lunId2Pair.get(srcLunId);
        if (otherPair != null) {
            logger.error((Object)("the hyper metro lun exist more than one replication relation!srcLunId:" + srcLunId + ",pair1:" + pair.getReplicationId() + ",pair2:" + otherPair.getReplicationId()));
            throw new LegoCheckedException(1073948191L);
        }
        lunId2Pair.put(srcLunId, pair);
    }

    protected String checkBothLunExistReplicationPair(PolicyTemplateContext context, String devSn, ReplicationPair pair) {
        String srcDevSN = pair.getSrcDevSN();
        if (Objects.isNull(devSn)) {
            devSn = srcDevSN;
        } else if (!devSn.equals(srcDevSN)) {
            logger.error((Object)"both of the hyper metro lun exist replication relation! devSn: %s, srcDevSN: %s", new Object[]{devSn, srcDevSN});
            throw new LegoCheckedException(1073948191L);
        }
        return devSn;
    }

    @Override
    public int getType() {
        return 18;
    }

    private void checkSite(String deviceSn, PolicyTemplateContext context) {
        Site site = this.getSiteFromSn(deviceSn);
        Set devSnSet = (Set)context.getObject("DEVICE_SITE_SET");
        if (null == devSnSet) {
            logger.error((Object)"devSnSet is null");
            throw new LegoCheckedException(1073948191L);
        }
        if (devSnSet.contains(site.getSiteId())) {
            logger.error((Object)("replication register in double alive site:" + this.getSetStr(devSnSet) + " replication site:" + site.getName()));
            throw new LegoCheckedException(1073948211L);
        }
    }

    public List<ReplicationPair> getReplicationPairsByLun(Lun lunMo) {
        return this.getAsyncReplicationFilter().getPairsByLun(lunMo);
    }

    public Lun getLunMo(StorageResource resource) {
        ArrayList<String> lunIds = new ArrayList<String>();
        lunIds.add(resource.getResourceId());
        List lunList = null;
        try {
            lunList = this.getStorageService().queryLunByDevSnAndLunIds(resource.getDevSn(), lunIds);
        }
        catch (Exception e) {
            ExceptionUtil.convertException((Throwable)e, (String)("query lun error: " + resource.getDevSn()), (long)1073948705L, (String[])new String[0], (Log)logger);
        }
        if (!VerifyUtil.isEmpty((Collection)lunList)) {
            return (Lun)lunList.get(0);
        }
        return null;
    }

    private boolean checkFreshHyperMetroHealth(List<ProtectObject> protectObjects, PolicyTemplateContext context) {
        List<ProtectGroupReplica> list = this.getProtectGroupReplicaList(protectObjects);
        boolean isNas = this.isNas(protectObjects.get(0));
        if (VerifyUtil.isEmpty(list) || !isNas) {
            return false;
        }
        String devSn = list.iterator().next().getProductArray();
        return this.checkFreshHyperMetroHealth(protectObjects, context, devSn);
    }

    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        return this.getReplicationProtectLocationPaths(protectObjects);
    }
}

