/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.template.filter.ArraySyncReplicationFilter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ArraySyncAsyncCascade3DCFilter
extends ArraySyncReplicationFilter {
    protected static final String SYNC_ASYNC_SKETCH = "policy_template_4_cascaded_sa.png";
    private static final Log logger = LogFactory.getInstance(ArraySyncAsyncCascade3DCFilter.class);

    @Override
    public boolean isMatch(List<ProtectObject> protectObjects) {
        boolean is3DCSite;
        boolean isMatchBC;
        logger.info((Object)("Start " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        String arraySn = this.checkSameSrcDevice(protectObjects);
        Site site = this.getSiteFromSn(arraySn);
        if (VerifyUtil.isEmpty((Object)site)) {
            logger.warn((Object)("can't get site by deviceSN:" + arraySn), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        this.getFilterContext().clear();
        boolean isMatchAB = this.isMatchByLocation(1, DrmEnumDefine.ProtectLocation.A_B.getValue(), protectObjects, this.getType());
        if (!isMatchAB) {
            logger.warn((Object)"Cascade3DC is not MatchAB", 90160758787071L);
        }
        try {
            isMatchBC = this.isMatchByLocation(2, DrmEnumDefine.ProtectLocation.B_C.getValue(), protectObjects, this.getType());
            if (!isMatchBC) {
                logger.warn((Object)"Cascade3DC is not MatchBC", 90160758787071L);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Cascade3DC isMatchBC error:", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(1073948191L, (Throwable)e);
        }
        Object siteA = this.getFilterContext().get("SITE_A_3DC");
        Object siteB = this.getFilterContext().get("SITE_B_3DC");
        Object siteC = this.getFilterContext().get("SITE_C_3DC");
        if (VerifyUtil.isEmpty(siteA) || VerifyUtil.isEmpty(siteB) || VerifyUtil.isEmpty(siteC)) {
            logger.warn((Object)("Cascade3DC isMatch site is null:" + siteA + "-" + siteB + "-" + siteC), 90160758787071L);
            throw new LegoCheckedException(1073948211L);
        }
        boolean bl = is3DCSite = !String.valueOf(siteA).equals(String.valueOf(siteB)) && !String.valueOf(siteB).equals(String.valueOf(siteC)) && !String.valueOf(siteA).equals(String.valueOf(siteC));
        if (!is3DCSite) {
            logger.warn((Object)("Cascade3DC isMatch site is same:" + siteA + "-" + siteB + "-" + siteC), 90160758787071L);
            throw new LegoCheckedException(1073948211L);
        }
        logger.info((Object)("End " + ((Object)((Object)this)).getClass().getSimpleName() + " isMatch"), 90160758786989L);
        return isMatchAB && isMatchBC;
    }

    @Override
    public List<ProtectLocationPath> getProtectLocationPaths(List<ProtectObject> protectObjects) {
        this.isMatch(protectObjects);
        String siteA = (String)this.getFilterContext().get("SITE_A_3DC");
        String siteB = (String)this.getFilterContext().get("SITE_B_3DC");
        String siteC = (String)this.getFilterContext().get("SITE_C_3DC");
        ArrayList<ProtectLocationPath> path = new ArrayList<ProtectLocationPath>();
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.A_B.getValue(), siteA, siteB));
        path.add(this.constructSitePath(DrmEnumDefine.ProtectLocation.B_C.getValue(), siteB, siteC));
        return path;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    protected Lun getLunMo(int locationType, ProtectObjectStorageInfo protectObjectStorageInfo) {
        if (DrmEnumDefine.ProtectLocation.A_B.getValue() == locationType) {
            return super.getLunMo(locationType, protectObjectStorageInfo);
        }
        return this.getLunFromLocalOrRemote(protectObjectStorageInfo);
    }

    @Override
    protected String addResourceId(Set<String> resourceIdSet, ProtectObjectStorageInfo poStorageInfo, int locationType) {
        if (DrmEnumDefine.ProtectLocation.A_B.getValue() == locationType) {
            return super.addResourceId(resourceIdSet, poStorageInfo, locationType);
        }
        if (VerifyUtil.isEmpty(this.getFilterContext().get(this.getDevAndLun(poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId())))) {
            logger.error((Object)("ArraySyncAsyncCascade3DCFilter getLunMo getFilterContext key is null:" + this.getDevAndLun(poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId())));
            throw new LegoCheckedException(1073948191L);
        }
        String tgtLunInfo = String.valueOf(this.getFilterContext().get(this.getDevAndLun(poStorageInfo.getResourceProviderSN(), poStorageInfo.getResourceId())));
        Object[] infos = tgtLunInfo.split(":");
        if (VerifyUtil.isEmpty((Object[])infos) || infos.length < 2) {
            logger.error((Object)("ArraySyncAsyncCascade3DCFilter getLunMo tgtLunInfo is null, tgtLunInfo is:" + tgtLunInfo));
            throw new LegoCheckedException(1073948191L);
        }
        resourceIdSet.add((String)infos[1]);
        return infos[0];
    }

    @Override
    protected void saveProSite(int type, String proSite) {
        if (DrmEnumDefine.ProtectLocation.A_B.getValue() == type) {
            this.getFilterContext().put("SITE_A_3DC", proSite);
        } else if (DrmEnumDefine.ProtectLocation.B_C.getValue() == type) {
            this.getFilterContext().put("SITE_B_3DC", proSite);
        }
    }

    @Override
    protected void saveRecovSite(int type, String sn) {
        Collection<List<String>> values = this.getLunTgtDevs().values();
        if (VerifyUtil.isEmpty(values)) {
            logger.error((Object)"values is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (1 == values.iterator().next().size()) {
            if (DrmEnumDefine.ProtectLocation.A_B.getValue() == type) {
                this.getFilterContext().put("SITE_B_3DC", this.getSiteByArraySn(sn));
            } else if (DrmEnumDefine.ProtectLocation.B_C.getValue() == type) {
                this.getFilterContext().put("SITE_C_3DC", this.getSiteByArraySn(sn));
            }
        }
    }
}

