/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.template.filter;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractPolicyTemplateFilter;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.handler.IStorageLicenseHandler;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class HyperClonePolicyTemplateFilter
extends AbstractPolicyTemplateFilter {
    private static final Log logger = LogFactory.getInstance(HyperClonePolicyTemplateFilter.class);

    public boolean isMatch(List<ProtectObject> protectObjects) {
        boolean supportHyperClone;
        if (VerifyUtil.isEmpty(protectObjects)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkIfSupportHyperClone(protectObjects);
        this.checkSameSrcDevice(protectObjects);
        this.checkProtectObjectType(protectObjects);
        List allStorageInfos = this.getAllStorageInfo(protectObjects);
        if (VerifyUtil.isEmpty((Collection)allStorageInfos)) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> srcLunIds = new ArrayList<String>();
        for (ProtectObjectStorageInfo posi : allStorageInfos) {
            if (srcLunIds.contains(posi.getResourceId().toLowerCase(Locale.getDefault()))) continue;
            srcLunIds.add(posi.getResourceId().toLowerCase(Locale.getDefault()));
        }
        String deviceSN = ((ProtectObjectStorageInfo)allStorageInfos.iterator().next()).getResourceProviderSN();
        IStorageLicenseHandler licenseHandler = (IStorageLicenseHandler)ServiceLocator.getInstance().getService(IStorageLicenseHandler.class);
        StorageLicense license = licenseHandler.getArrayLisence(deviceSN);
        if (null != license && !(supportHyperClone = license.isSupportFeature("3"))) {
            logger.error((Object)"Current version dose not support hyper clone", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        List lunList = new ArrayList();
        try {
            lunList = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryLunByDevSnAndLunIds(deviceSN, srcLunIds);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Querying lun failed. DevSn:" + deviceSN), (long)1073948705L, (String[])new String[0], (Log)logger);
        }
        if (srcLunIds.size() != lunList.size()) {
            logger.error((Object)"Lun does not existed.", 90160758786989L);
            throw new LegoCheckedException(1073948191L);
        }
        Site siteFromDevice = null;
        DrResource drResource = this.getResourceService().getDrResourceBySn(deviceSN, "ism.deviceType.storage.mainType");
        if (null != drResource) {
            siteFromDevice = this.getSiteService().getSiteById(drResource.getSiteId());
        }
        if (VerifyUtil.isEmpty(siteFromDevice)) {
            logger.warn((Object)("can't get site by deviceSN:" + deviceSN), 90160758786989L);
            throw new LegoCheckedException(1073948449L);
        }
        return true;
    }

    private void checkProtectObjectType(List<ProtectObject> protectObjects) {
        Integer poType = null;
        for (ProtectObject protectObject : protectObjects) {
            if (null == poType) {
                poType = protectObject.getPoType();
                continue;
            }
            if (poType.intValue() == protectObject.getPoType()) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    public int getType() {
        return 16;
    }

    private void checkIfSupportHyperClone(List<ProtectObject> protectObjects) {
        StorageUnit storageUnit = this.getDeviceType(protectObjects);
        if (null == storageUnit) {
            throw new LegoCheckedException(1073947394L);
        }
        if (!(storageUnit instanceof HvsUnit)) {
            throw new LegoCheckedException(1073948232L);
        }
    }

    private StorageUnit getDeviceType(List<ProtectObject> protectObjects) {
        ProtectObjectStorageInfo poStorageInfo = this.getProtectObjectStorageInfo(protectObjects);
        if (null == poStorageInfo) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        String resourceId = poStorageInfo.getResourceId();
        String providerSN = poStorageInfo.getResourceProviderSN();
        String wwn = poStorageInfo.getLunWWN();
        List storageResources = storageService.getStorageResourceByWwn(new String[]{wwn});
        if (VerifyUtil.isEmpty((Collection)storageResources)) {
            ArrayList<String> resourceIds = new ArrayList<String>();
            resourceIds.add(resourceId);
            storageResources = storageService.getStorageResources(providerSN, resourceIds, DrmEnumDefine.ResourceTypeE.LUN);
        }
        if (VerifyUtil.isEmpty((Collection)storageResources)) {
            throw new LegoCheckedException(1073947394L);
        }
        StorageResource storageResource = (StorageResource)storageResources.iterator().next();
        StorageUnit storageUnit = (StorageUnit)CommonDAOLocator.getMoDao().getMo(StorageUnit.class, "devSn", (Object)storageResource.getDevSn());
        return storageUnit;
    }

    private ProtectObjectStorageInfo getProtectObjectStorageInfo(List<ProtectObject> protectObjects) {
        ProtectObjectStorageInfo poStorageInfo = null;
        for (ProtectObject po : protectObjects) {
            ProtectObjectStorageInfo info;
            Iterator iterator = po.getUsedStorageResourceSet().iterator();
            if (!iterator.hasNext()) continue;
            poStorageInfo = info = (ProtectObjectStorageInfo)iterator.next();
        }
        return poStorageInfo;
    }
}

