/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.StorageHyperCloneReplica;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCloneManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCloneManager;
import com.huawei.ism.drm.storage.protection.bean.CloneConsistentGroupCache;
import com.huawei.ism.drm.storage.protection.bean.HyperCloneTargetLunVO;
import com.huawei.ism.drm.storage.protection.replica.PgReplicaValidityComparator;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class HyperCloneProtectionUtil {
    private static final Log logger = LogFactory.getInstance(HyperCloneProtectionUtil.class);
    private static final Set<Integer> validPairStatusSet = new HashSet<Integer>();
    private static final Set<Integer> validDataStatusSet = new HashSet<Integer>();

    public static List<ProtectGroupReplica> getSortedProtectGroupReplicas(ProtectGroup protectGroup) {
        ArrayList<ProtectGroupReplica> pgReplicas = new ArrayList<ProtectGroupReplica>();
        pgReplicas.addAll(protectGroup.getReplicaList());
        Collections.sort(pgReplicas, new PgReplicaValidityComparator());
        return pgReplicas;
    }

    public static boolean isValidHyperClonePair(HyperClonePair hyperClonePair) {
        String deviceSn;
        IStorageResourceService resourceService = (IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class);
        Lun srcLun = (Lun)resourceService.getStorageResource(deviceSn = hyperClonePair.getDeviceSn(), hyperClonePair.getSrcLunId(), Lun.class);
        if (null == srcLun) {
            logger.error((Object)("srcLun is null.deviceSn:" + deviceSn + ", srcLunId:" + hyperClonePair.getSrcLunId()));
            throw new LegoCheckedException(1073947394L);
        }
        List<HyperCloneTargetLunVO> existedTgtLuns = HyperCloneProtectionUtil.getTargetLunsBySrcLun(deviceSn, srcLun);
        if (VerifyUtil.isEmpty(existedTgtLuns)) {
            return false;
        }
        for (HyperCloneTargetLunVO targetLunVO : existedTgtLuns) {
            HyperCloneTargetLun hyperCloneTgtLun = targetLunVO.getHyperCloneTargetLun();
            if (!hyperCloneTgtLun.getId().endsWith(hyperClonePair.getTgtLunId()) || !hyperCloneTgtLun.getPairId().equals(hyperClonePair.getPairId())) continue;
            return true;
        }
        return false;
    }

    public static List<HyperCloneTargetLunVO> getTargetLunsBySrcLun(String deviceSn, Lun srcLun) {
        List<HyperCloneTargetLun> validHyperCloneTargetLuns = HyperCloneProtectionUtil.getValidHyperCloneTargetLuns(deviceSn, srcLun.getLunId());
        if (VerifyUtil.isEmpty(validHyperCloneTargetLuns)) {
            logger.debug((Object)"validHyperCloneTargetLuns is empty!");
            return new ArrayList<HyperCloneTargetLunVO>();
        }
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (HyperCloneTargetLun hyperCloneTargetLun : validHyperCloneTargetLuns) {
            resourceIds.add(hyperCloneTargetLun.getId());
        }
        ArrayList<HyperCloneTargetLunVO> hyperCloneTargetVos = new ArrayList<HyperCloneTargetLunVO>();
        List targetLuns = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getStorageResources(deviceSn, resourceIds, Lun.class);
        if (!VerifyUtil.isEmpty((Collection)targetLuns)) {
            for (HyperCloneTargetLun hyperCloneTargetLun : validHyperCloneTargetLuns) {
                Lun targetLun = HyperCloneProtectionUtil.filterLunById(targetLuns, hyperCloneTargetLun.getId());
                if (null == targetLun) {
                    logger.debug((Object)("targetLun is null!hyperCloneTargetLun.getId:" + hyperCloneTargetLun.getId()));
                    continue;
                }
                HyperCloneTargetLunVO targetLunVo = new HyperCloneTargetLunVO();
                targetLunVo.setSrcLun(srcLun);
                targetLunVo.setTargetLun(targetLun);
                targetLunVo.setPairId(hyperCloneTargetLun.getPairId());
                targetLunVo.setHyperCloneTargetLun(hyperCloneTargetLun);
                hyperCloneTargetVos.add(targetLunVo);
            }
        }
        return hyperCloneTargetVos;
    }

    public static ProtectGroupReplica rebuildProtectGroupReplica(ProtectGroup protectGroup, ProtectGroupReplica pgReplica, CloneConsistentGroup cloneCG) {
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica existPoReplica = HyperCloneProtectionUtil.getExistProtectObjectReplica(pgReplica, protectObject);
            if (null == existPoReplica) {
                ProtectObjectReplica poReplica = HyperCloneProtectionUtil.createProtectObjectReplica(protectObject, cloneCG);
                poReplica.setPgReplica(pgReplica);
                pgReplica.getReplicas().add(poReplica);
                continue;
            }
            HyperCloneProtectionUtil.rebuildProtectObjectReplica(protectObject, existPoReplica, cloneCG);
        }
        HyperCloneProtectionUtil.cleanInvalidProtectObjectReplica(protectGroup, pgReplica);
        return pgReplica;
    }

    public static CloneConsistentGroup getCloneConsistentGroup(ProtectGroup protectGroup) {
        CloneConsistentGroup cloneConsistentGroup = null;
        CloneConsistentGroupCache cloneCache = new CloneConsistentGroupCache(protectGroup);
        List<CloneConsistentGroup> cloneGroups = cloneCache.getCloneConsistentGroups();
        List<CloneConsistentGroup> sortedCloneGroups = HyperCloneProtectionUtil.getSortedCloneConsistentGroups(protectGroup, cloneGroups);
        for (CloneConsistentGroup cloneGroupTemp : sortedCloneGroups) {
            if (!HyperCloneProtectionUtil.isValidCloneConsistentGroup(cloneGroupTemp)) continue;
            cloneConsistentGroup = cloneGroupTemp;
            break;
        }
        return cloneConsistentGroup;
    }

    private static boolean isValidCloneConsistentGroup(CloneConsistentGroup cloneGroup) {
        boolean isValidCloneCG = true;
        for (HyperClonePair clonePair : cloneGroup.getPairs()) {
            if (HyperCloneProtectionUtil.isValidHyperClonePair(clonePair)) continue;
            isValidCloneCG = false;
            break;
        }
        return isValidCloneCG;
    }

    private static List<CloneConsistentGroup> getSortedCloneConsistentGroups(ProtectGroup pg, List<CloneConsistentGroup> cloneGroups) {
        ArrayList<CloneConsistentGroup> sortedCloneGroups = new ArrayList<CloneConsistentGroup>();
        sortedCloneGroups.addAll(HyperCloneProtectionUtil.getUnusedCloneConsistentGroups(cloneGroups));
        List<ProtectGroupReplica> sortedPgReplicas = HyperCloneProtectionUtil.getSortedProtectGroupReplicas(pg);
        for (ProtectGroupReplica pgReplica : sortedPgReplicas) {
            for (CloneConsistentGroup cloneGroup : cloneGroups) {
                if (!pgReplica.getId().equals(cloneGroup.getPgReplicaId())) continue;
                sortedCloneGroups.add(cloneGroup);
            }
        }
        return sortedCloneGroups;
    }

    private static List<CloneConsistentGroup> getUnusedCloneConsistentGroups(List<CloneConsistentGroup> cloneGroups) {
        ArrayList<CloneConsistentGroup> unusedCloneGroups = new ArrayList<CloneConsistentGroup>();
        for (CloneConsistentGroup cloneGroup : cloneGroups) {
            if (!VerifyUtil.isEmpty((String)cloneGroup.getPgReplicaId())) continue;
            unusedCloneGroups.add(cloneGroup);
        }
        return unusedCloneGroups;
    }

    public static ProtectGroupReplica createProtectGroupReplica(ProtectGroup protectGroup, CloneConsistentGroup cloneCG) {
        ProtectGroupReplica protectGroupReplica = new ProtectGroupReplica();
        protectGroupReplica.setId(UUIDGenerator.getUUID());
        protectGroupReplica.setName(protectGroupReplica.getId());
        String deviceSn = HyperCloneProtectionUtil.getSrcDevSN(protectGroup);
        protectGroupReplica.setProductArray(deviceSn);
        protectGroupReplica.setType(5);
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        protectGroupReplica.setRecoverySite(protectGroup.getProductSiteId());
        protectGroupReplica.setRecoveryArray(deviceSn);
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setReplicas(new HashSet());
        logger.debug((Object)("Name:" + protectGroupReplica.getName() + ", RecoverySiteId:" + protectGroup.getProductSiteId()));
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica poReplica = HyperCloneProtectionUtil.createProtectObjectReplica(protectObject, cloneCG);
            poReplica.setPgReplica(protectGroupReplica);
            protectGroupReplica.getReplicas().add(poReplica);
        }
        return protectGroupReplica;
    }

    public static String getSrcDevSN(ProtectGroup protectGroup) {
        String srcDevSN = null;
        for (ProtectObject po : protectGroup.getPolist()) {
            for (ProtectObjectStorageInfo info : po.getUsedStorageResourceSet()) {
                srcDevSN = info.getResourceProviderSN();
            }
        }
        if (VerifyUtil.isEmpty(srcDevSN)) {
            logger.error((Object)"product array is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        return srcDevSN;
    }

    public static ProtectGroupReplica getProtectGroupReplica(ProtectGroup protectGroup, String pgReplicaId) {
        ProtectGroupReplica associatedPgReplica = null;
        if (!VerifyUtil.isEmpty((String)pgReplicaId)) {
            for (ProtectGroupReplica pgReplica : protectGroup.getReplicaList()) {
                if (!pgReplica.getId().equals(pgReplicaId)) continue;
                associatedPgReplica = pgReplica;
            }
        }
        logger.warn((Object)"pgReplicaId is empty!");
        return associatedPgReplica;
    }

    private static ProtectObjectReplica rebuildProtectObjectReplica(ProtectObject protectObject, ProtectObjectReplica poReplica, CloneConsistentGroup cloneCG) {
        for (ProtectObjectStorageInfo poStorageInfo : protectObject.getUsedStorageResourceSet()) {
            HyperCloneProtectionUtil.rebuildReplicaStorageInfo(poReplica, poStorageInfo, cloneCG);
        }
        HyperCloneProtectionUtil.cleanInvalidReplicaStorageInfo(protectObject, poReplica);
        return poReplica;
    }

    private static void rebuildReplicaStorageInfo(ProtectObjectReplica poReplica, ProtectObjectStorageInfo poStorageInfo, CloneConsistentGroup cloneCG) {
        RelicaStorageInfo existReplicaStorageInfo = HyperCloneProtectionUtil.getReplicaStorageInfo(poReplica, poStorageInfo);
        if (null == existReplicaStorageInfo) {
            existReplicaStorageInfo = HyperCloneProtectionUtil.createReplicaStorageInfo(poReplica, poStorageInfo, cloneCG);
            poReplica.addRelicaStorageInfo(existReplicaStorageInfo);
        } else {
            HyperCloneProtectionUtil.refreshReplicaStorageInfo(existReplicaStorageInfo, cloneCG);
        }
    }

    private static void refreshReplicaStorageInfo(RelicaStorageInfo existReplicaStorageInfo, CloneConsistentGroup cloneCG) {
        StorageHyperCloneReplica replicaStorageInfo = (StorageHyperCloneReplica)existReplicaStorageInfo;
        HyperClonePair clonePair = HyperCloneProtectionUtil.getHyperClonePair(cloneCG, replicaStorageInfo);
        if (null == clonePair) {
            logger.error((Object)"clonePair is null.");
            throw new LegoCheckedException(-1L);
        }
        replicaStorageInfo.setStorageId(clonePair.getTgtLunId());
        replicaStorageInfo.setPairId(clonePair.getPairId());
    }

    private static RelicaStorageInfo createReplicaStorageInfo(ProtectObjectReplica protectObjectReplica, ProtectObjectStorageInfo poStorageInfo, CloneConsistentGroup cloneCG) {
        HyperClonePair clonePair = HyperCloneProtectionUtil.getHyperClonePair(cloneCG, poStorageInfo);
        if (null == clonePair) {
            logger.error((Object)"clonePair is null.");
            throw new LegoCheckedException(-1L);
        }
        clonePair.setSrcLunWWN(poStorageInfo.getLunWWN());
        RelicaStorageInfo replicaStorageInfo = HyperCloneProtectionUtil.constructRelicaStorageInfo(clonePair);
        replicaStorageInfo.setPoReplica(protectObjectReplica);
        return replicaStorageInfo;
    }

    private static RelicaStorageInfo constructRelicaStorageInfo(HyperClonePair clonePair) {
        StorageHyperCloneReplica replica = new StorageHyperCloneReplica();
        replica.setId(UUIDGenerator.getUUID());
        replica.setSrcStorageId(clonePair.getSrcLunId());
        replica.setSrcStorageProviderSN(clonePair.getDeviceSn());
        replica.setStorageId(clonePair.getTgtLunId());
        replica.setStorageProviderSN(clonePair.getDeviceSn());
        replica.setPairId(clonePair.getPairId());
        replica.setProtectObjectStorageWwn(clonePair.getSrcLunWWN());
        return replica;
    }

    private static RelicaStorageInfo getReplicaStorageInfo(ProtectObjectReplica poReplica, ProtectObjectStorageInfo poStorageInfo) {
        RelicaStorageInfo existReplicaStorageInfo = null;
        for (RelicaStorageInfo replicaStorageInfo : poReplica.getStorageInfos()) {
            if (!poStorageInfo.getResourceProviderSN().equals(replicaStorageInfo.getSrcStorageProviderSN()) || !poStorageInfo.getResourceId().equals(replicaStorageInfo.getSrcStorageId())) continue;
            existReplicaStorageInfo = replicaStorageInfo;
        }
        return existReplicaStorageInfo;
    }

    private static void cleanInvalidReplicaStorageInfo(ProtectObject protectObject, ProtectObjectReplica poReplica) {
        Iterator storageInfoIter = poReplica.getStorageInfos().iterator();
        while (storageInfoIter.hasNext()) {
            RelicaStorageInfo replicaStorageInfo = (RelicaStorageInfo)storageInfoIter.next();
            boolean existAssociatedPoStorageInfo = HyperCloneProtectionUtil.isExistPoStorageInfo(protectObject, replicaStorageInfo);
            if (existAssociatedPoStorageInfo) continue;
            storageInfoIter.remove();
        }
    }

    private static void cleanInvalidProtectObjectReplica(ProtectGroup protectGroup, ProtectGroupReplica pgReplica) {
        Iterator poReplicaIter = pgReplica.getReplicas().iterator();
        while (poReplicaIter.hasNext()) {
            ProtectObjectReplica poReplica = (ProtectObjectReplica)poReplicaIter.next();
            boolean isExistAssociatedPO = false;
            for (ProtectObject protectObject : protectGroup.getPolist()) {
                if (!poReplica.getPoId().equals(protectObject.getUuid())) continue;
                isExistAssociatedPO = true;
                break;
            }
            if (isExistAssociatedPO) continue;
            poReplicaIter.remove();
            poReplicaIter = pgReplica.getReplicas().iterator();
        }
    }

    private static boolean isExistPoStorageInfo(ProtectObject protectObject, RelicaStorageInfo replicaStorageInfo) {
        boolean existAssociatedPoStorageInfo = false;
        for (ProtectObjectStorageInfo poStorageInfo : protectObject.getUsedStorageResourceSet()) {
            if (!poStorageInfo.getResourceProviderSN().equals(replicaStorageInfo.getSrcStorageProviderSN()) || !poStorageInfo.getResourceId().equals(replicaStorageInfo.getSrcStorageId())) continue;
            existAssociatedPoStorageInfo = true;
            break;
        }
        logger.debug((Object)("existAssociatedPoStorageInfo:" + existAssociatedPoStorageInfo));
        return existAssociatedPoStorageInfo;
    }

    private static ProtectObjectReplica getExistProtectObjectReplica(ProtectGroupReplica pgReplica, ProtectObject protectObject) {
        ProtectObjectReplica existedPoReplica = null;
        for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
            if (!protectObject.getUuid().equals(poReplica.getPoId())) continue;
            existedPoReplica = poReplica;
            break;
        }
        return existedPoReplica;
    }

    private static ProtectObjectReplica createProtectObjectReplica(ProtectObject po, CloneConsistentGroup cloneCG) {
        ProtectObjectReplica protectObjectReplica = new ProtectObjectReplica();
        protectObjectReplica.setId(UUIDGenerator.getUUID());
        protectObjectReplica.setPoId(po.getUuid());
        protectObjectReplica.setStorageInfos(new HashSet());
        logger.debug((Object)("po uuid:" + po.getUuid()));
        for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
            RelicaStorageInfo replicaStorageInfo = HyperCloneProtectionUtil.createReplicaStorageInfo(protectObjectReplica, poStorageInfo, cloneCG);
            protectObjectReplica.addRelicaStorageInfo(replicaStorageInfo);
        }
        return protectObjectReplica;
    }

    private static HyperClonePair getHyperClonePair(CloneConsistentGroup cloneConsistentGroup, ProtectObjectStorageInfo poStorageInfo) {
        for (HyperClonePair clonePair : cloneConsistentGroup.getPairs()) {
            if (!clonePair.getDeviceSn().equals(poStorageInfo.getResourceProviderSN()) || !clonePair.getSrcLunId().equals(poStorageInfo.getResourceId())) continue;
            return clonePair;
        }
        logger.warn((Object)"result is null");
        return null;
    }

    private static HyperClonePair getHyperClonePair(CloneConsistentGroup cloneCG, StorageHyperCloneReplica replicaStorageInfo) {
        for (HyperClonePair clonePair : cloneCG.getPairs()) {
            if (!clonePair.getDeviceSn().equals(replicaStorageInfo.getSrcStorageProviderSN()) || !clonePair.getSrcLunId().equals(replicaStorageInfo.getSrcStorageId())) continue;
            return clonePair;
        }
        logger.warn((Object)"result is null");
        return null;
    }

    private static List<HyperCloneTargetLun> getValidHyperCloneTargetLuns(String deviceSn, String srcLunId) {
        ArrayList<HyperCloneTargetLun> validHyperCloneTargetLuns = new ArrayList<HyperCloneTargetLun>();
        IStorageHyperCloneManager hyperCloneMgr = StorageHyperCloneManagerProxy.getInstance().getStorageHyperCloneManager(deviceSn);
        List hyperCloneTargetLuns = hyperCloneMgr.getTargetLuns(deviceSn, srcLunId);
        if (VerifyUtil.isEmpty((Collection)hyperCloneTargetLuns)) {
            logger.debug((Object)"hyperCloneTargetLuns is empty");
            return validHyperCloneTargetLuns;
        }
        for (HyperCloneTargetLun targetLun : hyperCloneTargetLuns) {
            if (!HyperCloneProtectionUtil.isValidHyperCloneTargetLun(targetLun)) continue;
            validHyperCloneTargetLuns.add(targetLun);
        }
        return validHyperCloneTargetLuns;
    }

    private static Lun filterLunById(List<Lun> targetLuns, String lunId) {
        Lun matchedLun = null;
        for (Lun lun : targetLuns) {
            if (!lun.getLunId().equals(lunId)) continue;
            matchedLun = lun;
            break;
        }
        logger.debug((Object)("lunId:" + lunId + ", matchedLun:" + matchedLun));
        return matchedLun;
    }

    private static boolean isValidHyperCloneTargetLun(HyperCloneTargetLun targetLun) {
        int runningState = NumberUtil.convertToInteger((Object)targetLun.getRunningState(), (int)Integer.MIN_VALUE);
        logger.debug((Object)("runningState:" + runningState));
        if (Integer.MIN_VALUE == runningState) {
            return false;
        }
        if (!validPairStatusSet.contains(runningState)) {
            return false;
        }
        int dataStatus = targetLun.getDataStatus();
        return validDataStatusSet.contains(dataStatus);
    }

    static {
        validPairStatusSet.add(XveEnumDefinePParent.HYPERCLONE_PAIR_STATUS_E.NORMAL.getValue());
        validPairStatusSet.add(XveEnumDefinePParent.HYPERCLONE_PAIR_STATUS_E.SPLIT.getValue());
        validPairStatusSet.add(XveEnumDefinePParent.HYPERCLONE_PAIR_STATUS_E.SYNCHRONIZING.getValue());
        validPairStatusSet.add(XveEnumDefinePParent.HYPERCLONE_PAIR_STATUS_E.TOBERECOVERED.getValue());
        validPairStatusSet.add(XveEnumDefinePParent.HYPERCLONE_PAIR_STATUS_E.QUEUE.getValue());
        validPairStatusSet.add(XveEnumDefinePParent.HYPERCLONE_PAIR_STATUS_E.INTERRUPTED.getValue());
        validPairStatusSet.add(XveEuumDefineParent.RUNNING_STATUS_E.SPLIT.getValue());
        validPairStatusSet.add(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue());
        validPairStatusSet.add(XveEuumDefineParent.RUNNING_STATUS_E.TO_BE_RECOVERD.getValue());
        validPairStatusSet.add(XveEuumDefineParent.RUNNING_STATUS_E.QUEUING.getValue());
        validPairStatusSet.add(XveEuumDefineParent.RUNNING_STATUS_E.INTERRUPTED.getValue());
        validDataStatusSet.add(XveEnumDefinePParent.HYPERCLONE_LUN_STATUS_E.CONSISTENT.getValue());
        validDataStatusSet.add(XveEnumDefinePParent.HYPERCLONE_LUN_STATUS_E.INCONSISTENT.getValue());
        validDataStatusSet.add(XveEnumDefinePParent.HYPERCLONE_LUN_STATUS_E.SYNCHRONIZING.getValue());
    }
}

