/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.recovery.process.BaseSwapReplicationSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BaseSwapReplicationProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 250833538991251159L;
    private static final Log logger = LogFactory.getInstance(BaseSwapReplicationProcessor.class);
    private static final String REPLICA = "replica";
    private static final String IS_ONLY_SPLIT = "isOnlySplit";
    private final transient RecoveryProcessorMgr processMgr = RecoveryProcessorMgr.getInstance();
    private final transient IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)this.processMgr.getRecoveryProcessHandler();

    public boolean execute(RecoveryProcessorContext context) {
        boolean setPPInvalidResult;
        this.updateSubProcessors(context);
        Set swapReplicationSubProcessors = this.getChildProc();
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList(swapReplicationSubProcessors));
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        Site productionSite = (Site)context.getAttribute("productionSite");
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        if (executeResult && (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() || this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) && !(setPPInvalidResult = this.recoveryProcessHandler.setProtectGroupsInvalid(productionSite, recoveryPlan.getProtectGroups(), DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType())))) {
            logger.error((Object)"Setting remote protect policy invalid failed.", 90160758784001L);
        }
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        BaseSwapReplicationSubProcessor preProcessor = (BaseSwapReplicationSubProcessor)oldProcess;
        BaseSwapReplicationSubProcessor newProcessor = (BaseSwapReplicationSubProcessor)newProcess;
        return preProcessor.getReplicationId().equals(newProcessor.getReplicationId()) && preProcessor.getSrcDeviceId().equals(newProcessor.getSrcDeviceId()) && preProcessor.getTgtDeviceId().equals(newProcessor.getTgtDeviceId()) && preProcessor.getRelationType().equals(newProcessor.getRelationType());
    }

    protected boolean updateSubProcessors(RecoveryProcessorContext context) {
        Collection recoveryTasks = (Collection)context.getAttribute(this.getRecoveryTasksKey());
        String disasterSiteId = context.getDisasterSiteId();
        Set tmpRecoveryTasks = RecoveryTaskUtil.getRecoveryTasksByDisisaterSite((Collection)recoveryTasks, (String)disasterSiteId);
        if (RecoveryTaskUtil.is4DCVaultRollBack((RecoveryProcessorContext)context)) {
            this.set4DCVaultTasks(context, recoveryTasks, tmpRecoveryTasks);
        } else {
            recoveryTasks = tmpRecoveryTasks;
        }
        HashSet<BaseSwapReplicationSubProcessor> swapReplicationSubProcessors = new HashSet<BaseSwapReplicationSubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            BaseSwapReplicationSubProcessor swapProcessor = this.createSwapReplicationSubProcessor(recoveryTask);
            swapReplicationSubProcessors.add(swapProcessor);
        }
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(swapReplicationSubProcessors);
        } else {
            this.updateSubProcessors(swapReplicationSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private void set4DCVaultTasks(RecoveryProcessorContext context, Collection<RecoveryTask> recoveryTasks, Collection<RecoveryTask> disasterRecoveryTasks) {
        if (!RecoveryTaskUtil.isMultiDisasterSite((ProtectGroup)context.getProtectGroup(), (String)context.getDisasterSiteId())) {
            Set tmpTaskId = disasterRecoveryTasks.stream().map(RecoveryTask::getTaskId).collect(Collectors.toSet());
            recoveryTasks.forEach(task -> {
                if (!tmpTaskId.contains(task.getTaskId())) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put(IS_ONLY_SPLIT, "true");
                    task.setParams(params);
                }
            });
        }
    }

    abstract BaseSwapReplicationSubProcessor getSubProcessorInstance();

    private BaseSwapReplicationSubProcessor createSwapReplicationSubProcessor(RecoveryTask recoveryTask) {
        BaseSwapReplicationSubProcessor processor = this.getSubProcessorInstance();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setReplicationId(recoveryTask.getProtectId());
        processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
        processor.setTgtDeviceId(recoveryTask.getTgtDevcieId());
        processor.setRelationType(recoveryTask.getProtectType());
        Map extraParams = recoveryTask.getParams();
        String isOnlySplit = "false";
        if (!VerifyUtil.isEmpty((Map)extraParams) && extraParams.containsKey(IS_ONLY_SPLIT)) {
            isOnlySplit = (String)extraParams.get(IS_ONLY_SPLIT);
        }
        boolean tmpIsOnlySplit = "true".equals(isOnlySplit) || processor.isOnlySplit();
        processor.setOnlySplit(tmpIsOnlySplit);
        processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        return processor;
    }

    private void buildProcessorParallelRelation(RecoveryTask recoveryTask, Set<RecoveryProcessor> swapReplicationSubProcessors, String disasterSiteId) {
        if (this.checkDRRing(recoveryTask)) {
            this.buildProcessorParallelRelationForDRRing(recoveryTask, swapReplicationSubProcessors);
        } else {
            if (recoveryTask.getDisasterSite().getSiteId().equals(disasterSiteId)) {
                BaseSwapReplicationSubProcessor swapProcessor = this.createSwapReplicationSubProcessor(recoveryTask);
                swapReplicationSubProcessors.add((RecoveryProcessor)swapProcessor);
                return;
            }
            for (RecoveryTask task : recoveryTask.getParallelTasks()) {
                if (!task.getDisasterSite().getSiteId().equals(disasterSiteId)) continue;
                BaseSwapReplicationSubProcessor parallelSubProcessor = this.createSwapReplicationSubProcessor(task);
                swapReplicationSubProcessors.add((RecoveryProcessor)parallelSubProcessor);
                return;
            }
        }
    }

    private void buildProcessorParallelRelationForDRRing(RecoveryTask recoveryTask, Set<RecoveryProcessor> swapReplicationSubProcessors) {
        BaseSwapReplicationSubProcessor swapProcessor = this.createSwapReplicationSubProcessor(recoveryTask);
        swapReplicationSubProcessors.add((RecoveryProcessor)swapProcessor);
        for (RecoveryTask task : recoveryTask.getParallelTasks()) {
            BaseSwapReplicationSubProcessor parallelSubProcessor = this.createSwapReplicationSubProcessor(task);
            swapReplicationSubProcessors.add((RecoveryProcessor)parallelSubProcessor);
        }
    }

    private boolean checkDRRing(RecoveryTask recoveryTask) {
        if (recoveryTask.getParams() == null) {
            return false;
        }
        Object obj = recoveryTask.getParams().get(REPLICA);
        if (obj == null || !(obj instanceof RemoteStorageReplica)) {
            logger.warn((Object)"recoveryTask's REPLICA is not RemoteStorageReplica.");
            return false;
        }
        RemoteStorageReplica realReplica = (RemoteStorageReplica)RemoteStorageReplica.class.cast(obj);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)realReplica.getDrRingId())) {
            logger.debug((Object)("RemoteStorageReplica's drring is null, taskid:" + recoveryTask.getTaskId() + ",repid:" + realReplica.getReplicationPairId() + "."));
            return false;
        }
        return true;
    }

    private void buildProcessorCascadeRelation(RecoveryTask recoveryTask, Set<RecoveryProcessor> swapReplicationSubProcessors, String disasterSiteId) {
        if (recoveryTask.getDisasterSite().getSiteId().equals(disasterSiteId)) {
            BaseSwapReplicationSubProcessor swapProcessor = this.createSwapReplicationSubProcessor(recoveryTask);
            swapReplicationSubProcessors.add((RecoveryProcessor)swapProcessor);
            return;
        }
        if (null == recoveryTask.getCascadeTasks()) {
            logger.warn((Object)("no cascadeTask: " + recoveryTask.getTaskId()));
            return;
        }
        Iterator iterator = recoveryTask.getCascadeTasks().iterator();
        if (!iterator.hasNext()) {
            logger.warn((Object)("no cascadeTask: " + recoveryTask.getTaskId()));
            return;
        }
        RecoveryTask task = (RecoveryTask)iterator.next();
        this.buildProcessorCascadeRelation(task, swapReplicationSubProcessors, disasterSiteId);
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SwapReplicationProcessor.des");
    }
}

