/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.AbstractRecoveryTaskInterceptor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.CreateLunSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CreateLunPreparer
extends AbstractRecoveryTaskInterceptor {
    private static final Log LOGGER = LogFactory.getInstance(CreateLunPreparer.class);
    private static final String SNAPSHOT_PROCESSOR_KEY = "snapshotCopyForVmRecovery";

    public CreateLunPreparer(BaseRecoveryProcessor interceptTask) {
        super(interceptTask);
    }

    public boolean before() {
        BaseRecoveryProcessor interceptedProcessor = this.getInterceptTask();
        RecoveryProcessorContext context = interceptedProcessor.getContextRef();
        if (!((Boolean)context.getAttributeOrDefault("isRemoteVmRollback", Boolean.class, (Object)Boolean.FALSE)).booleanValue()) {
            LOGGER.warn((Object)"Non-remote VM granularity restoration is not supported for now.");
            return true;
        }
        return this.prepareLunTobeCreated(context);
    }

    public boolean after() {
        BaseRecoveryProcessor interceptedProcessor = this.getInterceptTask();
        RecoveryProcessorContext context = interceptedProcessor.getContextRef();
        Set childProc = interceptedProcessor.getChildProc();
        if (VerifyUtil.isEmpty((Collection)childProc)) {
            LOGGER.warn((Object)"No createLunSubProcessor was found, recovery plan's name is %s.", new Object[]{context.getRecoveryPlan().getName()});
            return true;
        }
        Map lunMap = (Map)context.getAttribute("lunToBeCreated", Map.class);
        if (VerifyUtil.isEmpty((Map)lunMap)) {
            LOGGER.error((Object)"The LUN to be created is not found.");
            return false;
        }
        return this.updateLunInfo(childProc, new ArrayList<Lun>(lunMap.values()));
    }

    private boolean prepareLunTobeCreated(RecoveryProcessorContext context) {
        context.setAttribute("lunToBeCreated", Collections.emptyMap());
        List createSnapshotSubProcessors = context.getObjects(SNAPSHOT_PROCESSOR_KEY, CreateSnapshotCopySubProcessor.class);
        if (VerifyUtil.isEmpty((Collection)createSnapshotSubProcessors)) {
            LOGGER.warn((Object)"No lun need to be created.");
            return true;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        String productDevSn = protectGroup.getAnyoneReplicationReplica().getProductArray();
        HashMap<String, Lun> lunMap = new HashMap<String, Lun>();
        HashMap<String, Snapshot> snapshotMap = new HashMap<String, Snapshot>();
        for (CreateSnapshotCopySubProcessor createSnapshotSubProcessor : createSnapshotSubProcessors) {
            Optional<Lun> optionalLun = this.prepareLun(createSnapshotSubProcessor, productDevSn, lunMap, snapshotMap);
            if (optionalLun.isPresent()) continue;
            return false;
        }
        context.setAttribute("lunToBeCreated", lunMap);
        context.setAttribute("recovery_snapshots", snapshotMap);
        return true;
    }

    private Optional<Lun> prepareLun(CreateSnapshotCopySubProcessor createSnapshotSubProcessor, String productDevSn, Map<String, Lun> lunMap, Map<String, Snapshot> snapshotMap) {
        String snapshotId = createSnapshotSubProcessor.getSnapshotId();
        String devSn = createSnapshotSubProcessor.getDeviceId();
        String lunId = createSnapshotSubProcessor.getLunId();
        IStorageSnapshotManager snapshotManager = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn);
        Optional snapshotOptional = snapshotManager.querySpecificSnapshot(devSn, lunId, snapshotId);
        if (!snapshotOptional.isPresent()) {
            LOGGER.error((Object)"Snapshot was not found on device(sn: %s), lun id=%s, snapshot id=%s.", new Object[]{devSn, lunId, snapshotId});
            return Optional.empty();
        }
        Snapshot snapshot = (Snapshot)snapshotOptional.get();
        Lun lun = new Lun();
        lun.setName(snapshot.getName() + "-" + System.currentTimeMillis() + "-" + "Remote_LUN");
        lun.setCapacity(snapshot.getSourceLunCapacity());
        lun.setDevSn(productDevSn);
        lunMap.put(snapshot.getName(), lun);
        snapshotMap.put(snapshot.getName(), snapshot);
        return Optional.of(lun);
    }

    private boolean updateLunInfo(Set<RecoveryProcessor> childProc, List<Lun> lunList) {
        Map subProcessorMap = childProc.stream().filter(processor -> processor instanceof CreateLunSubProcessor).map(processor -> (CreateLunSubProcessor)((Object)processor)).collect(Collectors.toMap(CreateLunSubProcessor::getLunName, Function.identity()));
        Map lunMap = lunList.stream().collect(Collectors.toMap(ManagedObject::getName, Function.identity()));
        for (Map.Entry entry : lunMap.entrySet()) {
            String lunName = entry.getKey();
            if (!subProcessorMap.containsKey(lunName)) {
                LOGGER.error((Object)"CreateLunSubProcessor for the LUN(name:%s) is not found.", new Object[]{lunName});
                continue;
            }
            Lun lun = (Lun)entry.getValue();
            CreateLunSubProcessor subProcessor = (CreateLunSubProcessor)((Object)subProcessorMap.get(lunName));
            lun.setLunId(subProcessor.getLunId());
            lun.setWwn(subProcessor.getLunWwn());
        }
        return true;
    }
}

