/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class CreateLunSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(CreateLunSubProcessor.class);
    private String deviceId;
    private String lunName;
    private Long lunCapacity;
    private String lunWwn;
    private String lunId;

    protected boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((String)this.lunName) || VerifyUtil.isEmpty((String)this.deviceId) || VerifyUtil.isEmpty((Object)this.lunCapacity)) {
            LOGGER.error((Object)"Illegal param for creating lun. lunName=%s, device sn=%s, lunCapacity=%s.", new Object[]{this.lunName, this.deviceId, this.lunCapacity});
            throw new LegoCheckedException(1073947393L);
        }
        this.updateProcessNameParams(new String[]{this.lunName});
        return this.createLun();
    }

    private boolean createLun() {
        LOGGER.info((Object)"Start to create lun(%s) on device(sn:%s).", new Object[]{this.lunName, this.deviceId});
        Lun createdLun = new Lun();
        createdLun.setDevSn(this.deviceId);
        createdLun.setCapacity(this.lunCapacity);
        createdLun.setName(this.lunName);
        try {
            createdLun = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(this.deviceId).createLun(createdLun);
            if (VerifyUtil.isEmpty((Object)createdLun)) {
                LOGGER.error((Object)"Create lun(name:%s) on device(sn:%s) failed, error msg: %s.", new Object[]{this.lunName, this.deviceId});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
            this.lunWwn = createdLun.getWwn();
            this.lunId = createdLun.getLunId();
            createdLun.setTopMoUuid(HvsStorage.class.getSimpleName() + this.deviceId);
            CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)createdLun);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create lun(name:%s) on device(sn:%s) failed, error msg: %s.", new Object[]{this.lunName, this.deviceId, e.getMessage()});
            this.updateProcessDetail("lego.err." + e.getErrorCode(), e.getParameters());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        LOGGER.info((Object)"Create lun(%s) on device(sn:%s) successfully.", new Object[]{this.lunName, this.deviceId});
        return true;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public void setLunCapacity(Long lunCapacity) {
        this.lunCapacity = lunCapacity;
    }

    public void setLunWwn(String lunWwn) {
        this.lunWwn = lunWwn;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public Long getLunCapacity() {
        return this.lunCapacity;
    }

    public String getLunWwn() {
        return this.lunWwn;
    }

    public String getLunId() {
        return this.lunId;
    }
}

