/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageFileSystemSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageFileSystemSnapshotManager;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateNasSnapshotSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1803102204245659233L;
    private static final Log logger = LogFactory.getInstance(CreateNasSnapshotSubProcessor.class);
    private String srcDeviceId;
    private String srcResourceId;
    private String deviceId;
    private String resourceId;
    private String resourceName;
    private String snapshotId = null;
    private String snapshotWWN = null;
    private String snapshotName = null;
    private String hostOrGroupIds;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getSnapshotWWN() {
        return this.snapshotWWN;
    }

    public void setSnapshotWWN(String snapshotWWN) {
        this.snapshotWWN = snapshotWWN;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public String getSrcResourceId() {
        return this.srcResourceId;
    }

    public void setSrcResourceId(String srcResourceId) {
        this.srcResourceId = srcResourceId;
    }

    public String getHostOrGroupIds() {
        return this.hostOrGroupIds;
    }

    public void setHostOrGroupIds(String hostOrGroupIds) {
        this.hostOrGroupIds = hostOrGroupIds;
    }

    public boolean execute(RecoveryProcessorContext context) {
        RecoveryProcessResult processResult = context.getProcessResult();
        IStorageFileSystemManager fileSystemManagerProxy = StorageFileSystemManagerProxy.getInstance().getStorageFileSystemManager(this.getDeviceId());
        ArrayList<String> fsIds = new ArrayList<String>();
        fsIds.add(this.getResourceId());
        List nasFileSystems = fileSystemManagerProxy.queryFileSystems(this.getDeviceId(), fsIds, this.getVstoreId(context));
        if (VerifyUtil.isEmpty((Collection)nasFileSystems)) {
            this.updateProcessName("ism.drm.recovery.create.snapshot.failed");
            String[] errorParams = new String[]{this.getResourceId(), this.getDeviceId()};
            this.updateProcessDetail("lego.err.1073948685", errorParams);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return true;
        }
        this.setResourceName(((NasFileSystem)nasFileSystems.get(0)).getName());
        if (null == this.getSnapshotName()) {
            this.setSnapshotName(this.generateSnapshotName(context.getRecoveryPlan()));
        }
        this.updateProcessNameParams(new String[]{this.getResourceName(), this.getSnapshotName()});
        String dataConsistencyCheckingKey = RecoveryProcessResult.getDataConsistencyCheckingResultKey((String)this.deviceId, (String)this.resourceId);
        Boolean dataConsistencyCheckingResult = processResult.getProcessResult(dataConsistencyCheckingKey);
        if (null == dataConsistencyCheckingResult || !dataConsistencyCheckingResult.booleanValue()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948710", new String[0]);
            return true;
        }
        IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy = StorageFileSystemSnapshotManagerProxy.getInstance().getStorageFileSystemSnapshotManager(this.getDeviceId());
        if (VerifyUtil.isEmpty((String)this.getSnapshotId()) || !this.isSnapExsit(fileSystemSnapshotManagerProxy, this.getSnapshotId(), this.getDeviceId(), this.getResourceId())) {
            try {
                long startTime = System.currentTimeMillis();
                String snapId = fileSystemSnapshotManagerProxy.createSnapshot(this.getDeviceId(), this.getResourceId(), this.getSnapshotName());
                logger.debug((Object)("create nas Snapshot cost time:" + (System.currentTimeMillis() - startTime)));
                if (VerifyUtil.isEmpty((String)snapId)) {
                    logger.error((Object)("Creating snapshot failed. DevSN:" + this.getDeviceId() + ",Name:" + this.getSnapshotName() + ",LunId:" + this.getResourceId()), 90160758784001L);
                    throw new LegoCheckedException(1073948680L);
                }
                this.setSnapshotId(snapId);
            }
            catch (LegoCheckedException e) {
                this.updateProcessDetail(e.getErrorMessageKey(), new String[]{this.getSnapshotName()});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return true;
            }
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private boolean isSnapExsit(IStorageFileSystemSnapshotManager fileSystemSnapshotManagerProxy, String snapId, String devSn, String fsId) {
        if (null == snapId) {
            return false;
        }
        List snapshots = fileSystemSnapshotManagerProxy.querySnapshot(devSn, fsId);
        if (VerifyUtil.isEmpty((Collection)snapshots)) {
            return false;
        }
        for (Snapshot snapshot : snapshots) {
            if (!snapId.equals(snapshot.getId())) continue;
            return true;
        }
        return false;
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getCreateSnapshotProcResultKey((String)this.getDeviceId(), (String)this.getResourceId());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private String generateSnapshotName(RecoveryPlan recoveryPlan) {
        String planId = recoveryPlan.getPlanId();
        String planIdSuffix = planId.substring(planId.length() - 3);
        StringBuilder builder = new StringBuilder();
        builder.append("RD_Test-");
        builder.append(System.currentTimeMillis());
        builder.append("_");
        builder.append(planIdSuffix);
        builder.append("_");
        builder.append(this.getResourceId());
        return builder.toString();
    }
}

