/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateNativeLunSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.BackupImage;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;

public class CreateNativeLunProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1069683066891726954L;
    private static final Log logger = LogFactory.getInstance(CreateNativeLunProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"CreateNativeLunProcessor: context is null.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (!this.generateSubProcessor(context)) {
            logger.error((Object)"create subprocessors failed.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.executeSubProcessor(context);
    }

    private boolean generateSubProcessor(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return true;
        }
        ProtectGroupReplica pgReplica = context.getProtectGroupReplica();
        String imageId = pgReplica.getProperty("IMAGE_ID");
        if (VerifyUtil.isEmpty((String)imageId)) {
            logger.error((Object)"CreateNativeLunProcessor: IMAGE_ID is null.");
            return false;
        }
        IBackupManager manager = BackupManagerProxy.getInstance().getBackupService("NativeBackupEngine");
        BackupImage backupImage = manager.queryImage(pgReplica.getStorageDeviceId(), imageId);
        HashSet<CreateNativeLunSubProcessor> createLunProcessors = new HashSet<CreateNativeLunSubProcessor>();
        for (Lun lun : backupImage.getLunList()) {
            CreateNativeLunSubProcessor subProcessor = new CreateNativeLunSubProcessor();
            subProcessor.setProcName("com.huawei.ism.drm.storage.recovery.process.CreateNativeLunSubProcessor");
            subProcessor.setProcType(this.getProcType());
            subProcessor.setDeviceId(lun.getDevSn());
            subProcessor.setImageId(backupImage.getId());
            subProcessor.setLunId(lun.getLunId());
            subProcessor.setLunCapacity(lun.getCapacity());
            subProcessor.setLunName(lun.getName());
            subProcessor.setLunWwn(lun.getWwn());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            createLunProcessors.add(subProcessor);
        }
        this.setChildProc(createLunProcessors);
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

