/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class CreateNativeLunSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 154467600096479191L;
    private static final Log logger = LogFactory.getInstance(CreateNativeLunSubProcessor.class);
    private String deviceId;
    private String imageId;
    private String lunId;
    private String lunName;
    private Long lunCapacity;
    private String lunWwn;
    private String dstLunId;
    private String dstLunWwn;
    private String dstLunName;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public Long getLunCapacity() {
        return this.lunCapacity;
    }

    public void setLunCapacity(Long lunCapacity) {
        this.lunCapacity = lunCapacity;
    }

    public String getLunWwn() {
        return this.lunWwn;
    }

    public void setLunWwn(String lunWwn) {
        this.lunWwn = lunWwn;
    }

    public String getDstLunId() {
        return this.dstLunId;
    }

    public void setDstLunId(String dstLunId) {
        this.dstLunId = dstLunId;
    }

    public String getDstLunWwn() {
        return this.dstLunWwn;
    }

    public void setDstLunWwn(String dstLunWwn) {
        this.dstLunWwn = dstLunWwn;
    }

    public String getDstLunName() {
        return this.dstLunName;
    }

    public void setDstLunName(String dstLunName) {
        this.dstLunName = dstLunName;
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.dstLunName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"CreateNativeLunSubProcessor: context is null.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.createNativeLun(context);
    }

    private boolean createNativeLun(RecoveryProcessorContext context) {
        Lun lunParam = new Lun();
        lunParam.setDevSn(this.deviceId);
        lunParam.setCapacity(this.lunCapacity);
        String newName = "RDBackup_" + this.lunId + "_" + System.currentTimeMillis();
        lunParam.setName(newName);
        try {
            this.updateProcessNameParams(new String[]{newName});
            Lun dstLun = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(this.deviceId).createLun(lunParam);
            if (VerifyUtil.isEmpty((Object)dstLun)) {
                throw new LegoCheckedException(1073947726L, new String[]{this.deviceId});
            }
            this.setDstLunId(dstLun.getLunId());
            this.setDstLunWwn(dstLun.getWwn());
            this.setDstLunName(dstLun.getName());
            dstLun.setTopMoUuid("HvsStorage" + dstLun.getDevSn());
            CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)dstLun);
        }
        catch (Exception e) {
            logger.error((Object)("create lun from lun " + this.lunId + " in " + lunParam.getDevSn() + " failed."));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (!((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this)) {
            logger.error((Object)"CreateNativeLunSubProcessor: save process failed.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }
}

