/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HvsProtectionGroup;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageProtectGroupManagerProxy;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class CreateProtectionGroupSubProcessor
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(CreateProtectionGroupSubProcessor.class);
    private String createdGroupId;
    private String devSn;
    private String protectGroupName;
    private HvsProtectionGroup protectionGroup;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.protectionGroup.getDevSn(), this.protectionGroup.getProtectGroupName()});
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            this.updateProcessDetail(this.getName() + ".created", null);
            return true;
        }
        StorageProtectGroupManagerProxy proxy = StorageProtectGroupManagerProxy.getInstance();
        try {
            HvsProtectionGroup createdGroup = proxy.createProtectGroup(this.protectionGroup);
            this.setCreatedGroupId(createdGroup.getProtectGroupId());
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1077948993L || e.getErrorCode() == 1073807384L) {
                logger.error((Object)"Name repeated:%s", new Object[]{this.protectionGroup.getProtectGroupName()});
                List existGroups = proxy.batchQueryProtectionGroup(this.protectionGroup.getDevSn(), "?filter=protectGroupName:" + this.protectionGroup.getProtectGroupName());
                this.setCreatedGroupId(((HvsProtectionGroup)existGroups.get(0)).getProtectGroupId());
                return this.success(this.getName() + ".created", null);
            }
            logger.error((Object)"Create protection group failed with error:%s, errorMsg:%s", new Object[]{e.getErrorCode(), e.getMessage()});
            this.updateProcessDetail("lego.err." + e.getErrorCode(), e.getParameters());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        logger.info((Object)"Create protection group success.");
        return true;
    }

    public String getCreatedGroupId() {
        return this.createdGroupId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getProtectGroupName() {
        return this.protectGroupName;
    }

    public HvsProtectionGroup getProtectionGroup() {
        return this.protectionGroup;
    }

    public void setCreatedGroupId(String createdGroupId) {
        this.createdGroupId = createdGroupId;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public void setProtectGroupName(String protectGroupName) {
        this.protectGroupName = protectGroupName;
    }

    public void setProtectionGroup(HvsProtectionGroup protectionGroup) {
        this.protectionGroup = protectionGroup;
    }
}

