/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class CreateReplicationGroupSubProcessor
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(CreateReplicationGroupSubProcessor.class);
    private ReplicationGroup group;
    private String createdGroupId;
    private String devSn;
    private String tgtDevSn;
    private String replicationName;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.group.getSrcDevSN(), this.group.getTgtDevSN(), this.group.getReplicationName()});
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            this.updateProcessDetail(this.getName() + ".created", null);
            return true;
        }
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        try {
            ReplicationGroup createdGroup = proxy.createReplicationGroup(this.group);
            this.setCreatedGroupId(createdGroup.getReplicationId());
            this.saveReplicationGroup(createdGroup);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 50338311L) {
                logger.error((Object)"Name repeated:%s", new Object[]{this.group.getReplicationName()});
                List existGroups = proxy.batchQueryReplicationGroup(this.group.getSrcDevSN(), "?filter=NAME:" + this.group.getReplicationName());
                this.setCreatedGroupId(((ReplicationGroup)existGroups.get(0)).getReplicationId());
                return this.success(this.getName() + ".created", null);
            }
            logger.error((Object)"Create replication group failed with error:%s, errorMsg:%s", new Object[]{e.getErrorCode(), e.getMessage()});
            this.updateProcessDetail("lego.err." + e.getErrorCode(), e.getParameters());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        logger.info((Object)"Create replication group success.");
        return true;
    }

    private void saveReplicationGroup(ReplicationGroup createdGroup) {
        createdGroup.setTopMoUuid(HvsStorage.class.getSimpleName() + this.group.getSrcDevSN());
        CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)createdGroup);
        ManagedObject cloned = createdGroup.clone();
        if (cloned instanceof ReplicationGroup) {
            ReplicationGroup replicationGroup = (ReplicationGroup)cloned;
            replicationGroup.setMoId(null);
            replicationGroup.setTopMoUuid(HvsStorage.class.getSimpleName() + this.group.getTgtDevSN());
            replicationGroup.setDevSn(this.group.getTgtDevSN());
            replicationGroup.setUuid(replicationGroup.getUuid().replace(this.group.getSrcDevSN(), this.group.getTgtDevSN()));
            replicationGroup.setIsPrimary(Boolean.valueOf(false));
            CommonDAOLocator.getMoDao().saveOrUpdateMo(cloned);
        }
    }

    public ReplicationGroup getGroup() {
        return this.group;
    }

    public String getCreatedGroupId() {
        return this.createdGroupId;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getTgtDevSn() {
        return this.tgtDevSn;
    }

    public String getReplicationName() {
        return this.replicationName;
    }

    public void setGroup(ReplicationGroup group) {
        this.group = group;
    }

    public void setCreatedGroupId(String createdGroupId) {
        this.createdGroupId = createdGroupId;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public void setTgtDevSn(String tgtDevSn) {
        this.tgtDevSn = tgtDevSn;
    }

    public void setReplicationName(String replicationName) {
        this.replicationName = replicationName;
    }
}

