/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collections;

public class CreateReplicationSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(CreateReplicationSubProcessor.class);
    private static final String PROCESSOR_NAME = "com.huawei.ism.drm.storage.recovery.process.CreateReplicationSubProcessor";
    private String srcDevSn;
    private String targetDevSn;
    private String srcResourceId;
    private String remoteResourceId;
    private String srcResourceName;
    private String remoteResourceName;
    private int srcResourceType;
    private int replicationMode;
    private String replicationId;

    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start to create replication, srcResourceName=%s, srcDevSn=%s, remoteResourceName=%s, targetDevSn=%s.", new Object[]{this.srcResourceName, this.srcDevSn, this.remoteResourceName, this.targetDevSn});
        this.updateProcessName(PROCESSOR_NAME);
        this.updateProcessNameParams(new String[]{this.srcDevSn, this.srcResourceId, this.targetDevSn, this.remoteResourceId});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ReplicationPair replicationPair = new ReplicationPair();
        replicationPair.setSrcDevSN(this.srcDevSn);
        ReplicationTargetLun targetLun = new ReplicationTargetLun();
        targetLun.setTgtDevSN(this.targetDevSn);
        targetLun.setTgtLunId(this.remoteResourceId);
        replicationPair.setSrcLunId(this.srcResourceId);
        replicationPair.setRepTgtLuns(Collections.singletonList(targetLun));
        replicationPair.setSrcLunName(this.srcResourceName);
        replicationPair.setLocalResType(Integer.valueOf(this.srcResourceType));
        replicationPair.setReplicationMode(Integer.valueOf(this.replicationMode));
        replicationPair.setReplicationRate(this.getReplicationRate(context));
        try {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            replicationPair = proxy.createReplicationPair(replicationPair);
            this.replicationId = replicationPair.getReplicationId();
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Create replication failed, error msg: %s", new Object[]{e.getMessage()});
            this.updateProcessDetail("lego.err." + e.getErrorCode(), e.getParameters());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        LOGGER.info((Object)"Create replication(id: %s) successfully.", new Object[]{this.replicationId});
        this.saveReplicationInDb(replicationPair);
        return true;
    }

    private void saveReplicationInDb(ReplicationPair replicationPair) {
        replicationPair.setTopMoUuid(HvsStorage.class.getSimpleName() + this.srcDevSn);
        CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)replicationPair);
        ManagedObject managedObject = replicationPair.clone();
        if (!(managedObject instanceof ReplicationPair)) {
            return;
        }
        ReplicationPair standbyReplicationPair = (ReplicationPair)managedObject;
        standbyReplicationPair.setMoId(null);
        standbyReplicationPair.setTopMoUuid(HvsStorage.class.getSimpleName() + this.targetDevSn);
        standbyReplicationPair.setDevSn(this.targetDevSn);
        standbyReplicationPair.setUuid(replicationPair.getUuid().replace(this.srcDevSn, this.targetDevSn));
        standbyReplicationPair.setIsPrimary(Boolean.valueOf(false));
        CommonDAOLocator.getMoDao().saveOrUpdateMo((ManagedObject)standbyReplicationPair);
    }

    private String getReplicationRate(RecoveryProcessorContext context) {
        String rollbackRateStr = (String)context.getRecoveryPlan().getGlobalSettings().get("ROLLBACK_RATE");
        LOGGER.debug((Object)"Replication rate is %s.", new Object[]{rollbackRateStr});
        return rollbackRateStr;
    }

    public void setSrcDevSn(String srcDevSn) {
        this.srcDevSn = srcDevSn;
    }

    public void setTargetDevSn(String targetDevSn) {
        this.targetDevSn = targetDevSn;
    }

    public void setSrcResourceId(String srcResourceId) {
        this.srcResourceId = srcResourceId;
    }

    public void setRemoteResourceId(String remoteResourceId) {
        this.remoteResourceId = remoteResourceId;
    }

    public void setSrcResourceName(String srcResourceName) {
        this.srcResourceName = srcResourceName;
    }

    public void setRemoteResourceName(String remoteResourceName) {
        this.remoteResourceName = remoteResourceName;
    }

    public void setSrcResourceType(int srcResourceType) {
        this.srcResourceType = srcResourceType;
    }

    public void setReplicationMode(int replicationMode) {
        this.replicationMode = replicationMode;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getSrcDevSn() {
        return this.srcDevSn;
    }

    public String getTargetDevSn() {
        return this.targetDevSn;
    }

    public String getSrcResourceId() {
        return this.srcResourceId;
    }

    public String getRemoteResourceId() {
        return this.remoteResourceId;
    }

    public String getSrcResourceName() {
        return this.srcResourceName;
    }

    public String getRemoteResourceName() {
        return this.remoteResourceName;
    }

    public int getSrcResourceType() {
        return this.srcResourceType;
    }

    public int getReplicationMode() {
        return this.replicationMode;
    }

    public String getReplicationId() {
        return this.replicationId;
    }
}

