/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class DeleteLunSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteLunSubProcessor.class);
    protected String deviceId;
    protected String lunId;
    protected String lunName;

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.lunName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        if (VerifyUtil.isEmpty((String)this.lunId) || VerifyUtil.isEmpty((String)this.deviceId)) {
            LOGGER.error((Object)"Illegal param, no need to delete. lun id=%s, device id=%s, lunName=%s.", new Object[]{this.lunId, this.deviceId, this.lunName});
            return true;
        }
        return this.deleteLun();
    }

    private boolean deleteLun() {
        LOGGER.info((Object)"Begin to delete lun(id: %s) from device(sn: %s)", new Object[]{this.lunId, this.deviceId});
        try {
            Lun lun = StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(this.deviceId).getLunById(this.deviceId, this.lunId);
            if (lun == null) {
                LOGGER.info((Object)"The lun(id: %s) is already not exists on device(sn: %s)", new Object[]{this.lunId, this.deviceId});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            StorageLunManagerProxy.getInstance().getStorageLunMgrByDevId(this.deviceId).deleteLun(this.deviceId, new String[]{this.lunId});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            LOGGER.info((Object)"Delete lun(id: %s) from device(sn: %s) successfully.", new Object[]{this.lunId, this.deviceId});
            if (((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this)) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1077936859L) {
                LOGGER.info((Object)"The lun(id: %s) is already not exists on device(sn: %s)", new Object[]{this.lunId, this.deviceId});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
            LOGGER.error((Object)"Delete lun(id: %s) from device(sn: %s) failed, error msg: %s.", new Object[]{this.lunId, this.deviceId, ExceptionUtil.getErrorMessage((Throwable)e)});
            this.updateProcessDetail(e.getErrorMessageKey(), null);
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return false;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getLunId() {
        return this.lunId;
    }

    public String getLunName() {
        return this.lunName;
    }
}

