/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.DeleteReplicationSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;

public class DeleteReplicationProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteReplicationProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        Collection recoveryTasks = context.getRecoveryTask(this.getRecoveryTasksKey());
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            LOGGER.warn((Object)"No replication recovery task was found.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
            return true;
        }
        if (!this.generateSubProcessor(recoveryTasks)) {
            LOGGER.error((Object)"Create subProcessors failed.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.executeSubProcessor(context);
    }

    private boolean generateSubProcessor(Collection<RecoveryTask> recoveryTasks) {
        HashSet<DeleteReplicationSubProcessor> subProcessorSet = new HashSet<DeleteReplicationSubProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            DeleteReplicationSubProcessor subProcessor = new DeleteReplicationSubProcessor();
            subProcessor.setProcType(this.getProcType());
            subProcessor.setParentProc((RecoveryProcessor)this);
            subProcessor.setProcessId(this.getProcessId());
            subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            subProcessor.setSrcDevSn(recoveryTask.getSrcDeviceId());
            subProcessor.setTargetDevSn(recoveryTask.getTgtDevcieId());
            subProcessor.setReplicationId(recoveryTask.getProtectId());
            subProcessor.setIsNeedSave(this.getIsNeedSave());
            subProcessor.setIsNeedCreateDetail(this.getIsNeedCreateDetail());
            subProcessorSet.add(subProcessor);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(subProcessorSet);
        } else {
            this.updateSubProcessors(subProcessorSet);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

