/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.recovery.process.DeleteReplicationProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;

public class DeleteReplicationSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(DeleteReplicationProcessor.class);
    private String srcDevSn;
    private String targetDevSn;
    private String replicationId;

    protected boolean execute(RecoveryProcessorContext context) {
        LOGGER.info((Object)"Start to delete replication(id=%s), srcDevSn=%s, targetDevSn=%s.", new Object[]{this.replicationId, this.srcDevSn, this.targetDevSn});
        this.updateProcessNameParams(new String[]{this.srcDevSn, this.targetDevSn, this.replicationId});
        if (this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
            return true;
        }
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        ReplicationRelation replicationRelation = recoveryService.queryReplication(this.srcDevSn, this.targetDevSn, this.replicationId, false);
        if (VerifyUtil.isEmpty((Object)replicationRelation)) {
            LOGGER.info((Object)"Replication(%s) is not exist in db, skip this step", new Object[]{this.replicationId});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
            return true;
        }
        ReplicationPair replicationPair = new ReplicationPair();
        replicationPair.setSrcDevSN(this.srcDevSn);
        ReplicationTargetLun targetLun = new ReplicationTargetLun();
        targetLun.setTgtDevSN(this.targetDevSn);
        replicationPair.setRepTgtLuns(Collections.singletonList(targetLun));
        replicationPair.setReplicationId(this.replicationId);
        try {
            StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
            proxy.deleteReplicationPair(replicationPair);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Delete replication failed, error msg: %s", new Object[]{e.getMessage()});
            this.updateProcessDetail("lego.err." + e.getErrorCode(), e.getParameters());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        LOGGER.info((Object)"Delete replication(id: %s) successfully.", new Object[]{this.replicationId});
        return true;
    }

    public void setSrcDevSn(String srcDevSn) {
        this.srcDevSn = srcDevSn;
    }

    public void setTargetDevSn(String targetDevSn) {
        this.targetDevSn = targetDevSn;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getSrcDevSn() {
        return this.srcDevSn;
    }

    public String getTargetDevSn() {
        return this.targetDevSn;
    }

    public String getReplicationId() {
        return this.replicationId;
    }
}

