/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroBaseManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.recovery.process.DisableHyperMetroSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class DisableHyperMetroOnRemoteSubProcessor
extends DisableHyperMetroSubProcessor {
    private static final long serialVersionUID = -8961736813282353459L;
    private static final Log LOGGER = LogFactory.getInstance(DisableHyperMetroOnRemoteSubProcessor.class);
    private String remoteDeviceId;

    public String getRemoteDeviceId() {
        return this.remoteDeviceId;
    }

    public void setRemoteDeviceId(String remoteDeviceId) {
        this.remoteDeviceId = remoteDeviceId;
    }

    @Override
    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getPairId()});
        return this.disableHyperMetroPairOnRemote();
    }

    @Override
    protected String generateResultKey() {
        return this.getDisableHyperMetroPairResultKey();
    }

    private boolean disableHyperMetroPairOnRemote() {
        try {
            if (!this.isNormalStatus()) {
                this.updateProcessDetail("lego.err.1073948754", new String[]{this.getPairId()});
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
            this.setRoleType(this.getIsPrimary() != false ? DrmEnumDefine.RoleType.NONE_PRIORITY.getValue() : DrmEnumDefine.RoleType.PRIORITY.getValue());
            DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.getDeviceId());
            if (drResource == null) {
                LOGGER.error((Object)("DrResource is null, sn=" + this.getDeviceId()));
                return false;
            }
            IStorageHyperMetroBaseManager baseManager = StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(this.getDeviceId());
            IStorageHyperMetroManager manager = null;
            if (baseManager instanceof IStorageHyperMetroManager) {
                manager = (IStorageHyperMetroManager)baseManager;
            }
            if (manager == null) {
                LOGGER.error((Object)"IStorageHyperMetroManager is not init, please check!");
                throw new LegoCheckedException(2117645L);
            }
            if (this.getIsConsistentGroup().booleanValue()) {
                LOGGER.info((Object)"Is cg.");
                manager.disableCgOnRemote(this.getDeviceId(), this.getRemoteDeviceId(), this.getPairId(), DrmEnumDefine.RoleType.getType((int)this.getRoleType()));
            } else {
                LOGGER.info((Object)"Is not cg.");
                manager.disablePairOnRemote(this.getDeviceId(), this.getRemoteDeviceId(), this.getPairId(), DrmEnumDefine.RoleType.getType((int)this.getRoleType()), this.getVstoreId());
            }
            LOGGER.info((Object)"Local: Success!");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Disable HyperMetro pair failed. PairId:%s", new Object[]{this.getPairId()});
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Disable HyperMetro pair failed. PairId:%s", new Object[]{this.getPairId()});
            this.updateProcessDetail("lego.err.1073948755", new String[]{this.getPairId()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
    }

    private boolean isNormalStatus() {
        return XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == this.getRunningState().intValue();
    }

    private boolean isStopped() {
        return XveEuumDefineParent.RUNNING_STATUS_E.PAUSE.getValue() == this.getRunningState().intValue();
    }

    private String getDisableHyperMetroPairResultKey() {
        StringBuilder builder = new StringBuilder();
        builder.append("DisableHyperMetroPair:");
        builder.append("DeviceId=");
        builder.append(this.getDeviceId());
        builder.append(";");
        builder.append("RemoteDeviceId=");
        builder.append(this.getRemoteDeviceId());
        builder.append(";");
        builder.append("PairId=");
        builder.append(this.getPairId());
        builder.append("IsConsistentGroup=");
        builder.append(this.getIsConsistentGroup());
        return builder.toString();
    }
}

