/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.operation.sdk.model.OperationResultBill;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.SyncReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SyncReplicationTask;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ReplicationSynchronizedChecker {
    private static final Log logger = LogFactory.getInstance(ReplicationSynchronizedChecker.class);
    private static final long MAX_TIME_OUT = 0x6DDD00L;
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private final IRecoveryProcessHandler recoveryProcessHandler;
    private final List<SyncReplicationTask> tasks = new ArrayList<SyncReplicationTask>();
    private boolean isNeedWait = true;

    public ReplicationSynchronizedChecker(IRecoveryProcessHandler processHandler, SyncReplicationTask task, boolean isNeedWait) {
        this.recoveryProcessHandler = processHandler;
        this.tasks.add(task);
        this.isNeedWait = isNeedWait;
    }

    public boolean hasNoTask() {
        return this.tasks.isEmpty();
    }

    public void forceStopTasks() {
        for (SyncReplicationTask task : this.tasks) {
            task.setTaskRunning(false);
        }
    }

    public int countSuccessResult() {
        int successCount = 0;
        for (SyncReplicationTask task : this.tasks) {
            if (!task.isCompleted() || !task.isSuccess()) continue;
            ++successCount;
        }
        return successCount;
    }

    public boolean checkSyncResult() {
        long startTime = System.currentTimeMillis();
        while (!this.isTasksCompleted()) {
            CommUtil.pauseThread((long)5000L);
            long curTime = System.currentTimeMillis();
            if (0x6DDD00L > curTime - startTime) continue;
            this.stopAllTasks();
            throw new LegoCheckedException(1073948744L);
        }
        return this.hasSuccessedTask();
    }

    public void startProcess() {
        Iterator<SyncReplicationTask> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            SyncReplicationTask task;
            final SyncReplicationTask syncTask = task = iterator.next();
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReplicationSynchronizedChecker.this.synchronize(syncTask);
                    }
                    catch (Throwable t) {
                        logger.error((Object)("Synchronizing failed." + ExceptionUtil.getErrorMessage((Throwable)t)), 90160758784001L);
                        syncTask.setSuccess(false);
                        syncTask.setCompleted(true);
                        syncTask.getProcessor().updateProcessDetail("lego.err.1073948673", new String[]{syncTask.getReplication().getName()});
                    }
                }
            });
        }
    }

    private void synchronize(SyncReplicationTask task) {
        OperationResultBill bill;
        SyncReplicationSubProcessor processor = task.getProcessor();
        processor.updateProcessNameParams(new String[]{processor.getCurrentSrcDeviceSN(), processor.getCurrentTgtDeviceSN(), task.getReplication().getReplicationId()});
        boolean isConsistentGroup = ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)processor.getRelationType());
        boolean isVstoreReplicationPair = ReplicationConstantDefine.ReplicationDescription.isVsotrePair((int)processor.getRelationType());
        List lastTargetLuns = null;
        if (isVstoreReplicationPair) {
            lastTargetLuns = this.recoveryProcessHandler.queryVstorePairSyncStatus(processor.getSrcDeviceId(), processor.getTgtDeviceId(), processor.getReplicationId(), true);
            this.checkPairStatus(lastTargetLuns);
            bill = this.recoveryProcessHandler.synchronizeVstorePair(processor.getSrcDeviceId(), processor.getTgtDeviceId(), processor.getReplicationId());
        } else {
            bill = this.recoveryProcessHandler.synchronize(processor.getReplicationId(), processor.getSrcDeviceId(), processor.getTgtDeviceId(), isConsistentGroup);
        }
        if (2 == task.getReplication().getReplicationMode() && bill.isHasFailRecord() && !VerifyUtil.isEmpty((Collection)bill.getOperationResults())) {
            OperationResult operationResult = (OperationResult)bill.getOperationResults().get(0);
            if (this.isUnaffectedSyncProcessor(task)) {
                processor.updateProcessDetail("--", new String[0]);
                task.setSuccess(true);
                task.setCompleted(true);
                return;
            }
            processor.updateProcessDetail("lego.err." + operationResult.getErrorCode(), operationResult.getArgs());
            task.setSuccess(false);
            task.setCompleted(true);
            return;
        }
        if (!this.isNeedWait) {
            this.checkSyncResultWithNotWait(task, processor, lastTargetLuns);
        } else {
            this.checkSyncResultWithWait(task, processor, lastTargetLuns);
        }
    }

    private boolean isUnaffectedSyncProcessor(SyncReplicationTask syncTask) {
        boolean is4DCVault;
        RecoveryProcessorContext context = syncTask.getContext();
        String disasterSiteId = context.getDisasterSiteId();
        ProtectGroup protectGroup = context.getProtectGroup();
        int templateType = protectGroup.getTemplate().getType();
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = (DrmEnumDefine.RecoveryPlanExecuteTypeE)context.getAttribute("PLAN_EXEXUTE_TYPE");
        if (type != DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK) {
            return false;
        }
        boolean bl = is4DCVault = templateType == 41 || templateType == 40 || templateType == 42 || templateType == 43;
        if (!is4DCVault) {
            return false;
        }
        Set hmSet = protectGroup.getHyperMetroSiteIdSet();
        if (hmSet.contains(disasterSiteId)) {
            return false;
        }
        if (RecoveryTaskUtil.isMultiDisasterSite((ProtectGroup)protectGroup, (String)disasterSiteId)) {
            return false;
        }
        SyncReplicationSubProcessor processor = syncTask.getProcessor();
        String srcDeviceId = processor.getSrcDeviceId();
        return !Objects.equals(srcDeviceId, protectGroup.getPoProviderSN());
    }

    private void checkSyncResultWithWait(SyncReplicationTask syncRepTask, SyncReplicationSubProcessor processor, List<ReplicationTargetLun> lastTargetLuns) {
        while (syncRepTask.isTaskRunning()) {
            CommUtil.pauseThread((long)5000L);
            String replicationId = syncRepTask.getReplication().getReplicationId();
            try {
                boolean isConsistentGroup = ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)processor.getRelationType());
                boolean isVstorePair = ReplicationConstantDefine.ReplicationDescription.isVsotrePair((int)processor.getRelationType());
                boolean isCompleted = this.isSyncCompleted(syncRepTask.getProcessor().getReplicationId(), syncRepTask.getProcessor().getSrcDeviceId(), syncRepTask.getProcessor().getTgtDeviceId(), isConsistentGroup, isVstorePair, lastTargetLuns);
                if (!isCompleted) continue;
                syncRepTask.setSuccess(true);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("Sync rep failed. Id:" + replicationId), (Throwable)e, 90160758784001L);
                processor.updateProcessDetail(e);
                syncRepTask.setSuccess(false);
            }
            catch (Exception e) {
                logger.error((Object)("Sync rep failed. Id:" + replicationId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                processor.updateProcessDetail("lego.err.1073948673", new String[]{replicationId});
                syncRepTask.setSuccess(false);
            }
            break;
        }
        syncRepTask.setCompleted(true);
    }

    private void checkSyncResultWithNotWait(SyncReplicationTask task, SyncReplicationSubProcessor processor, List<ReplicationTargetLun> lastTargetLuns) {
        boolean isSuccessed = false;
        CommUtil.pauseThread((long)5000L);
        try {
            boolean isConsistentGroup = ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)processor.getRelationType());
            boolean isVstorePair = ReplicationConstantDefine.ReplicationDescription.isVsotrePair((int)processor.getRelationType());
            isSuccessed = this.isExecSynchronizeCmdSuccessed(task.getProcessor().getReplicationId(), task.getProcessor().getSrcDeviceId(), task.getProcessor().getTgtDeviceId(), isConsistentGroup, isVstorePair, lastTargetLuns);
        }
        catch (LegoCheckedException e) {
            processor.updateProcessDetail(e);
        }
        catch (Exception e) {
            String replicationId = task.getReplication().getReplicationId();
            processor.updateProcessDetail("lego.err.1073948673", new String[]{replicationId});
        }
        task.setSuccess(isSuccessed);
        task.setCompleted(true);
    }

    private boolean isSyncCompleted(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup, boolean isVstorePair, List<ReplicationTargetLun> lastTargetLuns) {
        List targetLuns = isVstorePair ? this.recoveryProcessHandler.queryVstorePairSyncStatus(srcDeviceId, tgtDeviceId, replicationId, true) : this.recoveryProcessHandler.querySyncStatus(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
        if (VerifyUtil.isEmpty((Collection)targetLuns)) {
            logger.error((Object)"Sync replication failed. There is no target luns.", 90160758784001L);
            throw new LegoCheckedException(1073948673L, "Query Replication Target Lun error.");
        }
        boolean isCompleted = true;
        for (ReplicationTargetLun repTargetLun : targetLuns) {
            int pairStatus = repTargetLun.getPairStatus();
            if (2 == pairStatus || XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() == pairStatus) {
                isCompleted = false;
                break;
            }
            if (1 == pairStatus && XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == pairStatus) continue;
            logger.error((Object)"pair status abnormal. pairId:[%s]. pairStatus:[%s]", new Object[]{replicationId, pairStatus});
            throw new LegoCheckedException(1073948673L);
        }
        if (isCompleted && isVstorePair && !this.checkSynchronizeWithTime(lastTargetLuns, targetLuns, false)) {
            throw new LegoCheckedException(1073948729L);
        }
        return isCompleted;
    }

    private boolean isExecSynchronizeCmdSuccessed(String replicationId, String srcDeviceId, String tgtDeviceId, boolean isConsistentGroup, boolean isVstorePair, List<ReplicationTargetLun> lastTargetLuns) {
        List targetLuns = isVstorePair ? this.recoveryProcessHandler.queryVstorePairSyncStatus(srcDeviceId, tgtDeviceId, replicationId, false) : this.recoveryProcessHandler.querySyncStatus(srcDeviceId, tgtDeviceId, replicationId, isConsistentGroup);
        if (null == targetLuns || targetLuns.isEmpty()) {
            logger.error((Object)"Sync replication failed. There is no target luns.", 90160758784001L);
            throw new LegoCheckedException(1073948673L);
        }
        for (ReplicationTargetLun targetLun : targetLuns) {
            if (1 == targetLun.getPairStatus() || 2 == targetLun.getPairStatus() || XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() == targetLun.getPairStatus().intValue()) continue;
            logger.error((Object)("Sync replication failed. Pair status is not normal or synchronizing. PairStatus:" + targetLun.getPairStatus()), 90160758784001L);
            throw new LegoCheckedException(1073948729L);
        }
        if (isVstorePair && !this.checkSynchronizeWithTime(lastTargetLuns, targetLuns, true)) {
            throw new LegoCheckedException(1073948729L);
        }
        return true;
    }

    private boolean hasSuccessedTask() {
        boolean hasSuccessed = false;
        for (SyncReplicationTask task : this.tasks) {
            if (!task.isCompleted() || !task.isSuccess()) continue;
            hasSuccessed = true;
            break;
        }
        return hasSuccessed;
    }

    private boolean isTasksCompleted() {
        boolean isCompleted = true;
        for (SyncReplicationTask task : this.tasks) {
            if (task.isCompleted()) continue;
            isCompleted = false;
        }
        return isCompleted;
    }

    private void stopAllTasks() {
        for (SyncReplicationTask task : this.tasks) {
            SyncReplicationSubProcessor processor = task.getProcessor();
            StringBuilder strBuilder = new StringBuilder();
            if (null != processor) {
                strBuilder.append("SrcDeviceId:");
                strBuilder.append(processor.getSrcDeviceId());
                strBuilder.append(",TgtDeviceId:");
                strBuilder.append(processor.getTgtDeviceId());
                strBuilder.append(",ReplicationId:");
                strBuilder.append(processor.getReplicationId());
            }
            logger.error((Object)("Synchronize replication time out. " + strBuilder), 90160758784001L);
            task.setTaskRunning(false);
        }
    }

    private boolean checkSynchronizeWithTime(List<ReplicationTargetLun> lastTargetLuns, List<ReplicationTargetLun> targetLuns, boolean isStartTime) {
        if (VerifyUtil.isEmpty(lastTargetLuns)) {
            logger.error((Object)"lastTargetLuns is null");
            return false;
        }
        HashMap<String, String> startMap = new HashMap<String, String>();
        HashMap<String, String> endMap = new HashMap<String, String>();
        for (ReplicationTargetLun lastTargetLun : lastTargetLuns) {
            startMap.put(lastTargetLun.getReplicationPairId(), lastTargetLun.getStartTime());
            endMap.put(lastTargetLun.getReplicationPairId(), lastTargetLun.getEndTime());
        }
        for (ReplicationTargetLun targetLun : targetLuns) {
            String lastStartTimeOrEndTime = (String)endMap.get(targetLun.getReplicationPairId());
            String startTimeOrEndTIme = targetLun.getEndTime();
            if (isStartTime) {
                lastStartTimeOrEndTime = (String)startMap.get(targetLun.getReplicationPairId());
                startTimeOrEndTIme = targetLun.getStartTime();
            }
            if (VerifyUtil.isEmpty((String)startTimeOrEndTIme)) {
                logger.error((Object)"endTime is null");
                return false;
            }
            if (VerifyUtil.isEmpty((String)lastStartTimeOrEndTime) || Long.parseLong(startTimeOrEndTIme) > Long.parseLong(lastStartTimeOrEndTime)) continue;
            logger.error((Object)("Sync replication failed. Pair status is not normal or synchronizing. PairStatus:" + targetLun.getPairStatus() + "isStarttime:" + isStartTime + "lastTime:" + lastStartTimeOrEndTime + "endTime or startTime:" + startTimeOrEndTIme), 90160758784001L);
            return false;
        }
        return true;
    }

    private void checkPairStatus(List<ReplicationTargetLun> targetLuns) {
        for (ReplicationTargetLun targetLun : targetLuns) {
            if (2 != targetLun.getPairStatus() && XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != targetLun.getPairStatus().intValue()) continue;
            logger.error((Object)("Sync replication failed. Pair status is not normal or synchronizing. PairStatus:" + targetLun.getPairStatus()), 90160758784001L);
            throw new LegoCheckedException(1073948729L);
        }
    }
}

