/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.base.BaseHyperVaultRefactorReplicationSubProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.List;

public class SanHyperMetroAirGapRefactorReplicationSubProcessor
extends BaseHyperVaultRefactorReplicationSubProcessor {
    private static final long serialVersionUID = -4121427043737391510L;
    private static final Log LOGGER = LogFactory.getInstance(SanHyperMetroAirGapRefactorReplicationSubProcessor.class);
    private final boolean isRevertRep;

    public SanHyperMetroAirGapRefactorReplicationSubProcessor(RecoveryProcessor parentProcess, boolean isRevertRep) {
        super(parentProcess, isRevertRep);
        this.isRevertRep = isRevertRep;
    }

    @Override
    protected List<RemoteStorageReplica> getRemoteReplicas(RecoveryProcessorContext context, ProtectGroup protectGroup, String disasterSiteId) {
        ArrayList<RemoteStorageReplica> remoteStorageReplicas = new ArrayList<RemoteStorageReplica>();
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || replica.getRecoverySite() == null || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            this.putRemoteStorageReplicas(remoteStorageReplicas, replica);
        }
        if (this.isRevertRep) {
            try {
                return this.revertRemoteReplicas(remoteStorageReplicas);
            }
            catch (CloneNotSupportedException e) {
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
        return remoteStorageReplicas;
    }

    private void putRemoteStorageReplicas(List<RemoteStorageReplica> remoteStorageReplicas, ProtectGroupReplica protectGroupReplica) {
        int location = protectGroupReplica.getProtectLocation();
        for (ProtectObjectReplica protectObjectReplica : protectGroupReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : protectObjectReplica.getStorageInfos()) {
                if (!(storageInfo instanceof RemoteStorageReplica)) continue;
                RemoteStorageReplica remoteStorage = (RemoteStorageReplica)storageInfo;
                remoteStorage.setLocation(location);
                LOGGER.info((Object)"Need to reverse replicationPair direction:%s", new Object[]{remoteStorage.getReplicationPairId()});
                remoteStorageReplicas.add(remoteStorage);
            }
        }
    }

    private List<RemoteStorageReplica> revertRemoteReplicas(List<RemoteStorageReplica> remoteReplicas) throws CloneNotSupportedException {
        if (VerifyUtil.isEmpty(remoteReplicas)) {
            return new ArrayList<RemoteStorageReplica>();
        }
        ArrayList<RemoteStorageReplica> list = new ArrayList<RemoteStorageReplica>();
        for (RemoteStorageReplica remoteStorageReplica : remoteReplicas) {
            Object clone = remoteStorageReplica.clone();
            if (!(clone instanceof RemoteStorageReplica)) {
                LOGGER.error((Object)"Clone remote Storage Replica error! Replication pair id is %s.", new Object[]{remoteStorageReplica.getReplicationPairId()});
                throw new LegoCheckedException(1073947393L);
            }
            RemoteStorageReplica newRemoteStorageReplica = (RemoteStorageReplica)clone;
            String srcStorageProviderSN = newRemoteStorageReplica.getSrcStorageProviderSN();
            String srcStorageId = newRemoteStorageReplica.getSrcStorageId();
            newRemoteStorageReplica.setSrcStorageProviderSN(newRemoteStorageReplica.getStorageProviderSN());
            newRemoteStorageReplica.setSrcStorageId(newRemoteStorageReplica.getStorageId());
            newRemoteStorageReplica.setStorageProviderSN(srcStorageProviderSN);
            newRemoteStorageReplica.setStorageId(srcStorageId);
            list.add(newRemoteStorageReplica);
        }
        return list;
    }
}

