/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperMetroManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Date;

public class SynchronizeHyperMetroSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7112165745708016198L;
    private static final Log logger = LogFactory.getInstance(SynchronizeHyperMetroSubProcessor.class);
    private static final long SYNC_HYPER_METRO_TIME_OUT = 1800000L;
    private static final long SYNC_HYPER_METRO_INTERVAL = 10000L;
    private String deviceId;
    private String pairId;
    private String vstoreId;
    private boolean isAllAwaysContinue = false;
    private Boolean isConsistentGroup;

    public boolean isAllAwaysContinue() {
        return this.isAllAwaysContinue;
    }

    public void setAllAwaysContinue(boolean allAwaysContinue) {
        this.isAllAwaysContinue = allAwaysContinue;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getPairId() {
        return this.pairId;
    }

    public void setPairId(String pairId) {
        this.pairId = pairId;
    }

    public Boolean getIsConsistentGroup() {
        return this.isConsistentGroup;
    }

    public void setIsConsistentGroup(Boolean isConsistentGroup) {
        this.isConsistentGroup = isConsistentGroup;
    }

    public String getVstoreId() {
        return this.vstoreId;
    }

    public void setVstoreId(String vstoreId) {
        this.vstoreId = vstoreId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getPairId()});
        return this.synchronizeHyperMetroPair();
    }

    protected String generateResultKey() {
        return this.getSynchronizeHyperMetroPairResultKey();
    }

    private boolean synchronizeHyperMetroPair() {
        boolean isResult = true;
        try {
            DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.getDeviceId());
            if (null == drResource) {
                logger.error((Object)("DrResource is null, sn=" + this.getDeviceId()));
                return false;
            }
            IStorageHyperMetroManager manager = (IStorageHyperMetroManager)StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(this.getDeviceId());
            manager.synchronize(this.getDeviceId(), this.getPairId(), this.getIsConsistentGroup().booleanValue(), this.vstoreId);
            this.waitHyperMetroPairComplete(this.getDeviceId(), this.getPairId(), this.getIsConsistentGroup());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            isResult = true;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Swap HyperMetro pair failed. PairId:" + this.getPairId() + ", IsConsistentGroup:" + this.getIsConsistentGroup() + ", DevSN:" + this.getDeviceId()), (Throwable)e, 90160758784001L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            isResult = false;
        }
        catch (Exception e) {
            logger.error((Object)("Swap HyperMetro pair failed. PairId:" + this.getPairId() + ", IsConsistentGroup:" + this.getIsConsistentGroup() + ", DevSN:" + this.getDeviceId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.updateProcessDetail("lego.err.1073948758", new String[]{this.getPairId()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            isResult = false;
        }
        if (this.isAllAwaysContinue) {
            return true;
        }
        return isResult;
    }

    private void waitHyperMetroPairComplete(String devSn, String id, boolean isCg) throws InterruptedException {
        IStorageHyperMetroManager manager = (IStorageHyperMetroManager)StorageHyperMetroManagerProxy.getInstance().getMgrByDevId(this.getDeviceId());
        Date beginTime = new Date();
        while (true) {
            int runningStatus;
            if (isCg) {
                HyperMetroConsistentGroup hyperMetroCG = manager.queryHyperMetroConsistentGroup(devSn, id);
                runningStatus = Integer.parseInt(hyperMetroCG.getRunningState());
            } else {
                HyperMetroPair pair = manager.queryHyperMetroPair(devSn, id, this.vstoreId);
                runningStatus = Integer.parseInt(pair.getRunningState());
            }
            Date currentTime = new Date();
            long takeTime = currentTime.getTime() - beginTime.getTime();
            if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == runningStatus) {
                Thread.sleep(10000L);
                logger.info((Object)"sync success! devSn:%s, id:%s, isCg:%s, complete sync %s", new Object[]{devSn, id, isCg, takeTime});
                break;
            }
            if (takeTime > 1800000L) {
                logger.error((Object)"devSn:%s, id:%s, isCg:%s, not complete sync in 30min", new Object[]{devSn, id, isCg});
                break;
            }
            Thread.sleep(10000L);
        }
    }

    private String getSynchronizeHyperMetroPairResultKey() {
        StringBuilder builder = new StringBuilder();
        builder.append("SynchronizeHyperMetroPair:");
        builder.append("DeviceId=");
        builder.append(this.getDeviceId());
        builder.append(";");
        builder.append("PairId=");
        builder.append(this.getPairId());
        builder.append("IsConsistentGroup=");
        builder.append(this.getIsConsistentGroup());
        return builder.toString();
    }
}

