/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process.replication;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.common.CommonRecoveryProcessor;
import com.huawei.ism.drm.storage.recovery.process.replication.ReplicationSubProcessorFactory;
import com.huawei.ism.drm.storage.recovery.process.util.RecoveryProcessorContextUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ReplicationProcessor
extends CommonRecoveryProcessor {
    private static final long serialVersionUID = 3470065263652820120L;
    private final transient ReplicationSubProcessorFactory replicationGroupSubProcessorFactory;
    private final transient ReplicationSubProcessorFactory replicationPairSubProcessorFactory;

    public ReplicationProcessor(ReplicationSubProcessorFactory replicationGroupSubProcessorFactory, ReplicationSubProcessorFactory replicationPairSubProcessorFactory) {
        this.replicationGroupSubProcessorFactory = replicationGroupSubProcessorFactory;
        this.replicationPairSubProcessorFactory = replicationPairSubProcessorFactory;
    }

    @Override
    protected Set<RecoveryProcessor> createProcessors(RecoveryProcessorContext context) {
        List<ReplicationPair> replications = this.queryReplicationPair(context);
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        processors.addAll(this.createReplicationGroupSplitProcessors(replications));
        processors.addAll(this.createReplicationPairSplitProcessors(replications));
        return processors;
    }

    protected List<ReplicationPair> queryReplicationPair(RecoveryProcessorContext context) {
        List<String> wwnList = RecoveryProcessorContextUtil.getStorageWwn(context);
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        return storageService.queryReplicationPairsByMasterLunWWN(wwnList, true);
    }

    private Set<RecoveryProcessor> createReplicationGroupSplitProcessors(List<ReplicationPair> replications) {
        return replications.stream().filter(pair -> Objects.nonNull(pair.getConsistentGroupId())).map(pair -> this.createRecoveryProcessor(this.replicationGroupSubProcessorFactory, (ReplicationPair)pair, pair.getConsistentGroupId())).collect(Collectors.toSet());
    }

    private Set<RecoveryProcessor> createReplicationPairSplitProcessors(List<ReplicationPair> replications) {
        return replications.stream().filter(pair -> Objects.isNull(pair.getConsistentGroupId())).map(pair -> this.createRecoveryProcessor(this.replicationPairSubProcessorFactory, (ReplicationPair)pair, pair.getReplicationId())).collect(Collectors.toSet());
    }

    private RecoveryProcessor createRecoveryProcessor(ReplicationSubProcessorFactory factory, ReplicationPair pair, String replication) {
        RecoveryProcessor processor = factory.createRecoveryProcessor(pair.getSrcDevSN(), pair.getTgtDevSN(), replication);
        this.initProcessorProps(processor);
        return processor;
    }

    private void initProcessorProps(RecoveryProcessor processor) {
        Map props = processor.getProps();
        processor.setIsNeedCreateDetail(this.getIsNeedCreateDetail());
        processor.setIsNeedSave(this.getIsNeedSave());
        this.getProps().forEach((key, value) -> {
            if (!props.containsKey(key)) {
                props.put(key, value);
            }
        });
    }
}

