/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.CloneConsistentGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.util.HyperCloneProtectionUtil;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.storage.topology.CloneLinkSkin;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.topo.builder.AbstractTopoBuilder;
import com.huawei.ism.drm.topo.element.LunElement;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.topology.Skin;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.topology.IData;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-16")
public class ArrayCloneTopoBuilder
extends AbstractTopoBuilder {
    public static final Log logger = LogFactory.getInstance(ArrayCloneTopoBuilder.class);
    private static final double CLONE_LUN_GAP = 80.0;

    public void buildTopo(TopoBaseContext context) {
        this.checkContext(context);
        ProtectGroup pg = context.getProtectGroup();
        ArrayList<String> srcLunIds = new ArrayList<String>();
        ArrayList<String> trgLunIds = new ArrayList<String>();
        ProtectGroupReplica replica = this.getProtectGroupReplica(pg, srcLunIds, trgLunIds);
        String devSn = replica.getProductArray();
        Set schedules = pg.getTemplate().getSchedules();
        DrStorage drStorage = (DrStorage)this.getDrResource(devSn);
        String srcSiteId = drStorage.getSiteId();
        Site srcSite = context.getSiteService().getSiteById(srcSiteId);
        Node srcStorageNode = this.addSiteNode(context, drStorage, srcSite);
        Node srcLunStyles = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)(devSn + ":srcLunStyles"));
        Node trgLunStyles = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)(devSn + ":trgLunStyles"));
        context.addChild((IData)srcStorageNode, (IData)srcLunStyles);
        context.addChild((IData)srcStorageNode, (IData)trgLunStyles);
        List sources = this.getLunListFromDB(devSn, srcLunIds);
        List trgLuns = this.getLunListFromDB(devSn, trgLunIds);
        List<HyperCloneTargetLun> targets = this.getTrgLunListFromDB(devSn, trgLunIds);
        Map<String, Lun> srcLunIDMap = this.getLunIDMap(sources);
        Map<String, Lun> trgLunIDMap = this.getLunIDMap(trgLuns);
        Map<String, HyperCloneTargetLun> cloneLunIDMap = this.getCloneLunIDMap(targets);
        Schedule schedule = this.getSchedule(schedules);
        String scheduleInfo = TooltipUtil.getScheduleInfo((Schedule)schedule);
        StringBuilder lunIdList = new StringBuilder();
        for (String srcLunId : srcLunIds) {
            Lun source = this.getLun(srcLunIDMap, srcLunId);
            LunElement srcLunNode = new LunElement((Object)(devSn + srcLunId), source);
            srcLunNode = (Node)context.addChild((IData)srcLunStyles, (IData)srcLunNode);
            String trgLunID = (String)trgLunIds.get(srcLunIds.indexOf(srcLunId));
            Lun trgLun = trgLunIDMap.get(trgLunID);
            LunElement trgLunNode = trgLun != null ? new LunElement((Object)(devSn + trgLunID), trgLun) : new LunElement((Object)(devSn + trgLunID), source, trgLunID);
            trgLunNode = (Node)context.addChild((IData)trgLunStyles, (IData)trgLunNode);
            HyperCloneTargetLun repLunInfo = cloneLunIDMap.get(trgLunIds.get(srcLunIds.indexOf(srcLunId)));
            String linkId = devSn + ":" + srcLunId + ":" + devSn + ":" + trgLunID;
            lunIdList.append(linkId);
            lunIdList.append(";");
            context.linkTos((Node)srcLunNode, (Node)trgLunNode, linkId, new Skin[]{new CloneLinkSkin(repLunInfo, scheduleInfo)});
        }
        context.setLinkIdList(lunIdList.toString());
    }

    private Lun getLun(Map<String, Lun> srcLunIDMap, String srcLunId) {
        Lun source = srcLunIDMap.get(srcLunId);
        if (VerifyUtil.isEmpty((Object)source)) {
            source = new Lun();
            source.setLunId(srcLunId);
            source.setName("--");
        }
        return source;
    }

    private ProtectGroupReplica getProtectGroupReplica(ProtectGroup pg, List<String> srcLunIds, List<String> trgLunIds) {
        ProtectGroupReplica replica = this.getReplicaInfoFromPg(pg);
        if (null == replica) {
            logger.error((Object)"get protect group replica failed.");
            throw new LegoCheckedException(1073947393L);
        }
        Set poReplicaList = replica.getReplicas();
        for (ProtectObjectReplica poReplica : poReplicaList) {
            Set storageInfoList = poReplica.getStorageInfos();
            for (RelicaStorageInfo storageInfo : storageInfoList) {
                srcLunIds.add(storageInfo.getSrcStorageId());
                trgLunIds.add(storageInfo.getStorageId());
            }
        }
        return replica;
    }

    private void checkContext(TopoBaseContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (context.getRootNode() == null) {
            this.initialize(context);
        }
    }

    private ProtectGroupReplica getReplicaInfoFromPg(ProtectGroup protectGroup) {
        ProtectGroupReplica replica = null;
        if (null == protectGroup) {
            logger.error((Object)"getReplicaFromPg failed, protectGroup is null.");
            return replica;
        }
        CloneConsistentGroup cloneConsistentGroup = HyperCloneProtectionUtil.getCloneConsistentGroup(protectGroup);
        if (null != cloneConsistentGroup) {
            logger.debug((Object)"start get Replica from protectGroup.");
            replica = HyperCloneProtectionUtil.createProtectGroupReplica(protectGroup, cloneConsistentGroup);
            replica.setPg(protectGroup);
        }
        return replica;
    }

    private Schedule getSchedule(Set<Schedule> schedules) {
        if (VerifyUtil.isEmpty(schedules)) {
            return null;
        }
        Schedule result = null;
        for (Schedule schedule : schedules) {
            if (schedule.getScheduleMode() == 0) {
                return schedule;
            }
            result = schedule;
        }
        return result;
    }

    private Map<String, HyperCloneTargetLun> getCloneLunIDMap(List<HyperCloneTargetLun> targets) {
        HashMap<String, HyperCloneTargetLun> cloneLunIDMap = new HashMap<String, HyperCloneTargetLun>();
        if (null == targets) {
            return cloneLunIDMap;
        }
        for (HyperCloneTargetLun cloneLun : targets) {
            cloneLunIDMap.put(cloneLun.getId(), cloneLun);
        }
        return cloneLunIDMap;
    }

    private Map<String, Lun> getLunIDMap(List<Lun> luns) {
        HashMap<String, Lun> lunIDMap = new HashMap<String, Lun>();
        for (Lun lun : luns) {
            lunIDMap.put(lun.getLunId(), lun);
        }
        return lunIDMap;
    }

    protected List<ReplicaRelation> transform(Set<ProtectGroupReplica> replicas) {
        ArrayList<ReplicaRelation> relations = new ArrayList<ReplicaRelation>();
        if (VerifyUtil.isEmpty(replicas)) {
            return relations;
        }
        for (ProtectGroupReplica replica : replicas) {
            ReplicaRelation relation = new ReplicaRelation(replica);
            if (relation.isEmpty() || relation.getType() == 3) continue;
            relations.add(relation);
        }
        Collections.sort(relations);
        return relations;
    }

    protected Node addSiteNode(TopoBaseContext context, DrStorage drStorage, Site siteInfo) {
        Node site = (Node)context.getElementBox().getDataByID((Object)siteInfo.getSiteId());
        if (null == site) {
            site = this.createSiteNode(context, siteInfo, context.getRootNode());
        }
        String snid = drStorage.getDeviceSn() + ":storage";
        Node storage = (Node)context.getElementBox().getDataByID((Object)snid);
        if (null == storage) {
            storage = (Node)context.addChild((IData)site, (IData)new StorageElement(drStorage));
        }
        storage.setClient("layout", (Object)"leftright");
        storage.setClient("sonsGap", 80.0);
        return storage;
    }

    private List<HyperCloneTargetLun> getTrgLunListFromDB(String srcSN, List<String> trgLunIds) {
        List<Object> listCloneTargetLun = new ArrayList<HyperCloneTargetLun>();
        try {
            HashMap<String, Object> trgProps = new HashMap<String, Object>();
            trgProps.put("devSn", srcSN);
            trgProps.put("id", trgLunIds.toArray());
            listCloneTargetLun = CommonDAOLocator.getMoDao().findMoBy(HyperCloneTargetLun.class, trgProps);
        }
        catch (Exception e) {
            logger.error((Object)("get TargetLuns By devSn And LunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listCloneTargetLun;
    }
}

