/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.topology.SnapTopoBuilder;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.model.po.SnapNode;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.topology.ElementBox;
import com.huawei.topology.IData;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-17")
public class HyperVaultTopoBuilder
extends SnapTopoBuilder {
    private static final String CLIENT_PROP_TRANSFERNODE = "transferNode";
    private static final int UNVISABLEPIC_OFFERSET_PIC = -15;
    private static final double ICON_XOFFSET = 30.0;
    private static final double ICON_YOFFSET = -7.0;

    @Override
    public void buildTopo(TopoBaseContext context) {
        if (context.getRootNode() == null) {
            this.initialize(context);
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        Node siteNode = this.addSiteNode(context, protectGroup);
        Node protectGroupStyleNode = this.addProtectGroupStyleNode(context, protectGroup, siteNode);
        Node protectGroupNode = this.addProtectGroupNode(context, protectGroup, protectGroupStyleNode);
        protectGroupStyleNode.setToolTip(protectGroupNode.getToolTip());
        Set schedules = context.getPolicyTemplateManager().getPtByUuid(protectGroup.getTemplate().getUuid()).getSchedules();
        HashMap<String, List<ProtectGroupReplica>> snToReplica = new HashMap<String, List<ProtectGroupReplica>>();
        HashMap<String, Schedule> snToSchedule = new HashMap<String, Schedule>();
        block0: for (ProtectGroupReplica one : protectGroup.getReplicaList()) {
            if (!ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)one)) continue;
            String devSn = one.getRecoveryArray();
            if (snToReplica.containsKey(devSn)) {
                ((List)snToReplica.get(devSn)).add(one);
            } else {
                ArrayList<ProtectGroupReplica> replicas = new ArrayList<ProtectGroupReplica>();
                replicas.add(one);
                snToReplica.put(devSn, replicas);
            }
            for (Schedule oneSchedule : schedules) {
                if (snToSchedule.containsKey(devSn) && ((Schedule)snToSchedule.get(devSn)).getScheduleMode() == 0) continue block0;
                if (one.getProtectLocation() != oneSchedule.getProtectLocation()) continue;
                snToSchedule.put(devSn, oneSchedule);
            }
        }
        this.buildSnapInfo(context, siteNode, protectGroupNode, snToReplica, snToSchedule);
    }

    private void buildSnapInfo(TopoBaseContext context, Node siteNode, Node protectGroupNode, Map<String, List<ProtectGroupReplica>> snToReplica, Map<String, Schedule> snToSchedule) {
        ElementBox box = context.getElementBox();
        Node unvisiableSnapStyleNode = null;
        String unvisableSnapStyleNodeId = siteNode.getID() + "-" + protectGroupNode.getID() + "-unvisalbesnapStyle";
        unvisiableSnapStyleNode = TopoServiceUtil.findNodeByIdInBox((ElementBox)box, (String)unvisableSnapStyleNodeId);
        if (unvisiableSnapStyleNode == null) {
            unvisiableSnapStyleNode = this.createUnVisibleStyleNode(context, unvisableSnapStyleNodeId);
            context.addChild((IData)siteNode, (IData)unvisiableSnapStyleNode);
        }
        HashMap<String, Node> snToStyleNode = new HashMap<String, Node>();
        HashMap<String, Node> snToLUnVisableNode = new HashMap<String, Node>();
        for (Map.Entry<String, List<ProtectGroupReplica>> entry : snToReplica.entrySet()) {
            String snapStyleNodeId;
            Node snapStyleNode;
            String lUnVisableNodeId;
            Node lUnVisableNode;
            String arraySn = entry.getKey();
            String lRUnVisableNodeId = siteNode.getID() + "-" + arraySn + "-LRUnVisableNode";
            Node lRUnVisableNode = TopoServiceUtil.findNodeByIdInBox((ElementBox)box, (String)lRUnVisableNodeId);
            if (lRUnVisableNode == null) {
                lRUnVisableNode = this.createUnVisibleStyleNode(context, lRUnVisableNodeId);
                lRUnVisableNode.setClient("layout", (Object)"leftright");
                context.addChild((IData)unvisiableSnapStyleNode, (IData)lRUnVisableNode);
            }
            if ((lUnVisableNode = TopoServiceUtil.findNodeByIdInBox((ElementBox)box, (String)(lUnVisableNodeId = siteNode.getID() + "-" + arraySn + "-LUnVisableNode"))) == null) {
                this.setlUnVisableNode(context, snToSchedule, siteNode, arraySn, snToLUnVisableNode);
            }
            if ((snapStyleNode = TopoServiceUtil.findNodeByIdInBox((ElementBox)box, (String)(snapStyleNodeId = siteNode.getID() + "-" + arraySn + "-snapStyle"))) == null) {
                snapStyleNode = this.setSnapStyleNode(snapStyleNodeId, arraySn);
                context.addChild((IData)lRUnVisableNode, (IData)snapStyleNode);
                snToStyleNode.put(arraySn, snapStyleNode);
            }
            Link linkToUnvisableNode = this.buildBaseSnapLink(protectGroupNode, (Node)snToLUnVisableNode.get(arraySn), false);
            context.addChild((IData)context.getRootNode(), (IData)linkToUnvisableNode);
            List<ProtectGroupReplica> replicaList = entry.getValue();
            Collections.sort(replicaList, new CommonComparator("timeStamp", false));
            for (ProtectGroupReplica oneReplica : replicaList) {
                String snapID = oneReplica.getId() + "-snap";
                Node oneSnapStyleNode = (Node)snToStyleNode.get(arraySn);
                Node snapNode = (Node)box.getElementByID((Object)snapID);
                if (snapNode == null) {
                    snapNode = (Node)new SnapNode(oneReplica, this.getTopoResourceManager()).getLocalView();
                    context.addChild((IData)oneSnapStyleNode, (IData)snapNode);
                }
                if (TopoServiceUtil.isExistLinkBetweenNodes((Node)protectGroupNode, (Node)snapNode)) continue;
                Link link = this.buildBaseSnapLink((Node)snToLUnVisableNode.get(arraySn), snapNode, true);
                this.setLinkOffset(link);
                context.addChild((IData)context.getRootNode(), (IData)link);
            }
        }
    }

    private Node setSnapStyleNode(String snapStyleNodeId, String arraySn) {
        Node snapStyleNode = this.createPoInstanceStyleNode(snapStyleNodeId);
        snapStyleNode.setIcon("/theme/recoverydirector/images/topo/arrayIcon.png");
        snapStyleNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/arrayIcon.png");
        snapStyleNode.setStyle("icons.position", (Object)"topleft.topright");
        snapStyleNode.setClient("iconHeight", 48.0);
        snapStyleNode.setClient("iconWidth", 48.0);
        snapStyleNode.setStyle("label.position", (Object)"topleft.topright");
        snapStyleNode.setStyle("label.xoffset", 30.0);
        snapStyleNode.setStyle("label.yoffset", -7.0);
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(arraySn);
        if (null != drResource) {
            snapStyleNode.setName(TopoServiceUtil.getNodeShowName((String)drResource.getName()));
            snapStyleNode.setToolTip(StorageElement.createStorageTooltip((DrStorage)((DrStorage)drResource)));
        }
        return snapStyleNode;
    }

    private void setlUnVisableNode(TopoBaseContext context, Map<String, Schedule> snToSchedule, Node siteNode, String arraySn, Map<String, Node> snToLUnVisableNode) {
        String lUnVisableNodeId = siteNode.getID() + "-" + arraySn + "-LUnVisableNode";
        String lRUnVisableNodeId = siteNode.getID() + "-" + arraySn + "-LRUnVisableNode";
        Node lRUnVisableNode = this.createUnVisibleStyleNode(context, lRUnVisableNodeId);
        Node lUnVisableNode = this.createUnVisibleStyleNode(context, lUnVisableNodeId);
        lUnVisableNode.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/ic_asynchronous.png");
        lUnVisableNode.setStyle("icons.xoffset", -15);
        lUnVisableNode.setClient(CLIENT_PROP_TRANSFERNODE, (Object)"true");
        String scheduleInfo = TooltipUtil.getScheduleInfo((Schedule)snToSchedule.get(arraySn));
        lUnVisableNode.setToolTip(scheduleInfo);
        context.addChild((IData)lRUnVisableNode, (IData)lUnVisableNode);
        snToLUnVisableNode.put(arraySn, lUnVisableNode);
    }

    protected void setLinkOffset(Link link) {
        link.setClient("linkType", (Object)"hyperSnapLink");
    }

    protected Node createUnVisibleStyleNode(TopoBaseContext context, String styleNodeId) {
        Node group = TopoServiceUtil.createUnVisibleStyleNode((TopoBaseContext)context, (String)styleNodeId);
        group.setStyle("vector.outline.alpha", 0.0);
        group.setStyle("icons.position", (Object)"right.right");
        group.setClient("iconHeight", 48.0);
        group.setClient("iconWidth", 48.0);
        group.setClient("ISSNAPPO", (Object)"FALSE");
        return group;
    }
}

