/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.adventnet.nms.util;

import com.huawei.adventnet.nms.util.CmdLineImpl;
import com.huawei.adventnet.nms.util.Response;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class LegoBatchPing {
    private static final Log LOGGER = LogFactory.getInstance(LegoBatchPing.class);
    private static String osname = System.getProperty("os.name");
    private static String sPingPath = "";
    private static final String WIN_PING_BAT = "legoping.bat";
    private static final String LINUX_PING_SH = "legoping.sh";
    private static final String START_FLAG = "=============LEGO PING=============";
    private static final int MAX_RETRY_TIMES = 10;
    private static final int MIN_RETRY_TIMES = 1;
    private static final int MAX_TIMEOUT_SEC_TIME = 300;
    private static final int MIN_TIMEOUT_SEC_TIME = 1;

    public Boolean[] ping(List<String> ipList, int retries, int timeout) {
        if (VerifyUtil.isEmpty(ipList)) {
            return new Boolean[0];
        }
        for (String ip : ipList) {
            if (AddressUtil.isIpAddress((String)ip) || CommonUtil.isDrmDomain((String)ip)) continue;
            LOGGER.error((Object)"Illegal ip or host: %s", new Object[]{ip});
            throw new LegoCheckedException(1073947393L);
        }
        int validRetries = Math.min(Math.max(1, retries), 10);
        int validTimeout = Math.min(Math.max(1, timeout), 300);
        String cmd = this.getPingCmd(ipList, validRetries, validTimeout);
        return this.execCmd(cmd, ipList, timeout);
    }

    private String getPingCmd(List<String> ipList, int retries, int timeout) {
        StringBuffer cmd = new StringBuffer();
        cmd.append(sPingPath);
        cmd.append(' ');
        cmd.append(retries);
        cmd.append(' ');
        if (osname.startsWith("Windows")) {
            cmd.append(timeout * 1000);
        } else {
            cmd.append(timeout);
        }
        for (String ip : ipList) {
            cmd.append(' ');
            cmd.append(ip);
        }
        return cmd.toString();
    }

    private Boolean[] execCmd(String cmd, List<String> ipList, int timeout) {
        int maxTime = 1000;
        int multiTimes = 3000;
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Exec command %s.", cmd));
        Boolean[] results = new Boolean[ipList.size()];
        long timeOut = timeout < 1000 ? (long)timeout * 3000L : (long)timeout;
        CmdLineImpl cmdLine = new CmdLineImpl();
        Response resp = cmdLine.exec(timeOut, cmd);
        String[] replys = this.parsePingResult(resp == null ? "" : resp.getContent(), ipList.size());
        for (int i = 0; i < replys.length; ++i) {
            try {
                String reply = replys[i];
                this.buildResult(reply, results, i);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
                results[i] = Boolean.FALSE;
            }
        }
        return results;
    }

    private void buildResult(String reply, Boolean[] results, int i) {
        if (osname.startsWith("Windows")) {
            boolean result;
            boolean bl = result = reply.indexOf("Reply from") != -1 && reply.indexOf("bytes=") != -1;
            if (!result) {
                result = reply.indexOf("s TTL=") != -1;
            }
            results[i] = result;
        }
        if (osname.startsWith("Linux") || osname.startsWith("FreeBSD")) {
            results[i] = reply.indexOf("64 bytes from") != -1;
        }
    }

    private String[] parsePingResult(String reply, int size) {
        String[] results = new String[size];
        String[] replys = reply.split(START_FLAG);
        int j = 0;
        for (int i = 0; i < replys.length; ++i) {
            if ("".equals(replys[i]) || j >= size) continue;
            results[j] = replys[i];
            ++j;
        }
        return results;
    }

    static {
        File file = new File(".");
        String path = "";
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error((Object)"LegoBatchPing getCanonicalPath() error!", 102L);
        }
        sPingPath = path + File.separator;
        sPingPath = sPingPath + "tools" + File.separator;
        sPingPath = osname != null && osname.startsWith("Windows") ? sPingPath + WIN_PING_BAT : sPingPath + LINUX_PING_SH;
        if (sPingPath.indexOf(" ") != -1) {
            sPingPath = "\"" + sPingPath + "\"";
        }
    }
}

