/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.adventnet.nms.util;

import com.huawei.adventnet.nms.util.JavaPing;
import com.huawei.adventnet.nms.util.PingUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Properties;

public class LegoPing {
    private static final Log LOGGER = LogFactory.getInstance(LegoPing.class);
    private String osname = System.getProperty("os.name");
    private String pingCmd = "ping -w 0 -n 1";
    private int numTry = 1;

    public boolean ping(String host) {
        return this.ping(host, 1);
    }

    private String getSolarisPing(String host) {
        this.pingCmd = "/usr/sbin/ping ";
        return this.pingCmd + " " + host + " " + this.numTry;
    }

    private String getLinuxPing(String host, int retries) {
        this.pingCmd = "/bin/ping -c " + retries + " -w " + this.numTry;
        return this.pingCmd + " " + host;
    }

    private String getFreeBSDPing(String host, int retries) {
        this.pingCmd = "/sbin/ping -c " + retries;
        return this.pingCmd + " " + host;
    }

    private String getWindowsPing(String host, int retries) {
        int tryTimes = 1000;
        this.pingCmd = "ping -n " + retries + " -w";
        return this.pingCmd + " " + this.numTry * 1000 + " " + host;
    }

    private String getNonWinPing(String host, int retries) {
        this.pingCmd = "ping -n " + retries;
        return this.pingCmd + " " + host;
    }

    private boolean execPing(String host, int retries) {
        if (!AddressUtil.isIpAddress((String)host) && !CommonUtil.isDrmDomain((String)host)) {
            LOGGER.info((Object)"Illegal ip or host: %s", new Object[]{host});
            return false;
        }
        String cmd = this.osname.startsWith("SunOS") || this.osname.startsWith("Solaris") ? this.getSolarisPing(host) : (this.osname.startsWith("Linux") ? this.getLinuxPing(host, retries) : (this.osname.startsWith("FreeBSD") ? this.getFreeBSDPing(host, retries) : (this.osname.startsWith("Windows") ? this.getWindowsPing(host, retries) : (!this.osname.startsWith("Windows") ? this.getNonWinPing(host, retries) : this.pingCmd + " " + host))));
        return this.execCmd(cmd);
    }

    private boolean execCmd(String cmd) {
        LOGGER.debug((Object)"Exec command %s.", new Object[]{cmd});
        JavaPing ping = new JavaPing();
        String resp = ping.shping(cmd);
        if (this.osname.startsWith("Windows")) {
            boolean result;
            String reply = resp;
            boolean bl = result = reply.indexOf("Reply from") != -1 && reply.indexOf("bytes=") != -1;
            if (!result) {
                result = reply.indexOf("s TTL=") != -1;
            }
            return result;
        }
        if (this.osname.startsWith("Linux") || this.osname.startsWith("FreeBSD")) {
            String reply = resp;
            return reply.indexOf("64 bytes from") != -1;
        }
        return false;
    }

    private String getSolarisCmd(String hostname, int pingTimeout) {
        this.pingCmd = "/usr/sbin/ping ";
        return this.pingCmd + " " + hostname + " " + pingTimeout;
    }

    private String getLinuxCmd(String hostname, int pingTimeout, int pingRetries) {
        this.pingCmd = "/bin/ping -c " + pingRetries + " -w";
        return this.pingCmd + " " + pingTimeout + " " + hostname;
    }

    private String getFreeBSDCmd(String hostname, int pingRetries) {
        this.pingCmd = "/sbin/ping -c " + pingRetries;
        return this.pingCmd + " " + hostname;
    }

    private String getWindowsCmd(String hostname, int pingTimeout, int pingRetries) {
        this.pingCmd = "ping -n " + pingRetries + " -w";
        return this.pingCmd + " " + pingTimeout * 1000 + " " + hostname;
    }

    private String getNonWinCmd(String hostname, int pingRetries) {
        this.pingCmd = "ping -n " + pingRetries;
        return this.pingCmd + " " + hostname;
    }

    public boolean ping(Properties properties) {
        int pingRetries = PingUtil.parseRetries(properties);
        int pingTimeout = PingUtil.parseTimeout(properties, this.osname);
        String hostname = properties.getProperty("hostName");
        if (hostname == null) {
            LOGGER.error((Object)"ping host properties is null.");
            return false;
        }
        String cmd = this.pingCmd + " " + hostname;
        cmd = this.checkOS() ? this.getSolarisCmd(hostname, pingTimeout) : (this.osname.startsWith("Linux") ? this.getLinuxCmd(hostname, pingTimeout, pingRetries) : this.getCmd(pingRetries, pingTimeout, hostname, cmd));
        boolean result = this.execCmd(cmd);
        if (!result) {
            LOGGER.info((Object)"Lego ICMP Ping failed for host %s, Ping Properties %s.", new Object[]{hostname, properties});
        }
        return result;
    }

    private String getCmd(int pingRetries, int pingTimeout, String hostname, String cmd) {
        if (this.osname.startsWith("FreeBSD")) {
            cmd = this.getFreeBSDCmd(hostname, pingRetries);
        } else if (this.osname.startsWith("Windows")) {
            cmd = this.getWindowsCmd(hostname, pingTimeout, pingRetries);
        } else if (!this.osname.startsWith("Windows")) {
            cmd = this.getNonWinCmd(hostname, pingRetries);
        } else {
            return cmd;
        }
        return cmd;
    }

    private boolean checkOS() {
        return this.osname.startsWith("SunOS") || this.osname.startsWith("Solaris");
    }

    public boolean ping(String host, int retries) {
        boolean result = this.execPing(host, retries);
        if (!result) {
            LOGGER.info((Object)"Lego ICMP Ping failed for host %s.", new Object[]{host});
        }
        return result;
    }

    public void setPingTimeout(int timeout) {
        if (timeout <= 0) {
            if (this.osname.startsWith("Linux") || this.osname.startsWith("Solaris")) {
                this.numTry = 1;
            }
        } else {
            this.numTry = timeout;
        }
    }

    public int getPingTimeout() {
        return this.numTry;
    }
}

