/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.service.security;

import com.huawei.lego.cbb.user.thirdauth.sdk.IThirdAuthority;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ThirdAuthorityFactory
implements InitializingBean,
DisposableBean {
    private static ThirdAuthorityFactory sInstance = null;
    private Map<Integer, IThirdAuthority> serviceMap = new HashMap<Integer, IThirdAuthority>();

    public static synchronized ThirdAuthorityFactory getInstance() {
        if (sInstance == null) {
            sInstance = new ThirdAuthorityFactory();
        }
        return sInstance;
    }

    public void afterPropertiesSet() {
        if (this.serviceMap != null) {
            this.serviceMap.clear();
        }
    }

    public void destroy() {
        if (this.serviceMap != null) {
            this.serviceMap.clear();
        }
    }

    public void onBind(IThirdAuthority service, Map properties) {
        this.serviceMap.put(service.getAuthorityType().getValue(), service);
    }

    public void unBind(IThirdAuthority service, Map properties) {
        this.serviceMap.remove(service.getAuthorityType().getValue());
    }

    public IThirdAuthority getThirdAuthorityByType(int type) {
        IThirdAuthority thirdAuthority = null;
        if (this.serviceMap != null) {
            thirdAuthority = this.serviceMap.get(type);
        }
        return thirdAuthority;
    }

    public Set<Integer> getAuthorityType() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(UserAuthorityType.LOCAL.getValue());
        if (this.serviceMap != null) {
            set.addAll(this.serviceMap.keySet());
        }
        return set;
    }
}

