/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms.productor;

import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.comm.internal.jms.core.MsqQueueClient;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.exception.jms.LegoJMSDestoryException;
import com.huawei.lego.core.sdk.exception.jms.LegoJMSInitializeException;
import com.huawei.lego.core.sdk.exception.jms.LegoJMSRuntimeException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.ReflectUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.transport.AbstractInactivityMonitor;
import org.apache.activemq.util.ThreadPoolUtils;

public class TopicClient
implements MsqQueueClient {
    private static final Log LOGGER = LogFactory.getInstance(TopicClient.class);
    private TopicConnection conn;
    private TopicSession session;
    private String name;
    private Topic topic;
    private TopicPublisher publisher;
    private TopicSubscriber subscriber;
    private MessageListener messagelistener = null;
    private String filter = "";
    private String url = "";
    private final ReentrantLock sessionLock = new ReentrantLock();
    private BlockingQueue<MessageUnit> failMsgs = new LinkedBlockingQueue<MessageUnit>();

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public void setListener(MessageListener listener) {
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Set listener %s.", this.topic), 1L);
        try {
            this.subscriber = "".equals(this.filter) ? this.session.createSubscriber(this.topic) : this.session.createSubscriber(this.topic, this.filter, false);
            if (null == this.messagelistener) {
                this.messagelistener = listener;
            }
            this.subscriber.setMessageListener(listener);
        }
        catch (JMSException e) {
            LOGGER.error((Object)"setListener create subscriber error!", (Throwable)e, 1L);
            throw new LegoJMSRuntimeException("setListener create subscriber error!", (Throwable)e);
        }
    }

    @Override
    public void connect(String connectFactory) {
        this.url = connectFactory;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectFactory);
        try {
            this.doReConnect((TopicConnectionFactory)connectionFactory);
            LOGGER.info((Object)"conn.start() is successful!", 1L);
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
        }
        catch (JMSException e) {
            LOGGER.error((Object)"connect activemq server error!", (Throwable)e, 1L);
            throw new LegoJMSInitializeException("connect activemq server error!", (Throwable)e);
        }
    }

    private void doReConnect(TopicConnectionFactory tcf) {
        try {
            this.conn = tcf.createTopicConnection();
            LOGGER.info((Object)"conn = connectionFactory.createTopicConnection()!", 1L);
            this.conn.start();
        }
        catch (Exception e) {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
                LOGGER.info((Object)"Attempt to connect Broker is failed, Do reconnect after 3s!", 1L);
                CommonUtil.sleep((long)3000L);
            }
            catch (Exception e1) {
                LOGGER.error((Object)("sleep is error : --" + ExceptionUtil.getErrorMessage((Throwable)e1)), 1L);
            }
            this.doReConnect(tcf);
        }
    }

    @Override
    public void closeRecv() {
        try {
            this.subscriber.close();
        }
        catch (JMSException e) {
            LOGGER.error((Object)"error occur closing receiver ", (Throwable)e, 1L);
            throw new LegoJMSDestoryException("error occur closing receiver ", (Throwable)e);
        }
    }

    @Override
    public void sendObj(MessageUnit detail) {
        this.sendObj(detail, true);
    }

    private void sendObj(MessageUnit detail, boolean retry) {
        BytesMessage bytesMessage;
        try {
            bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(this.encodeSendMessage(detail));
            bytesMessage.setLongProperty("filter", detail.getCmdcode());
        }
        catch (JMSException e) {
            LOGGER.error((Object)"ActiveMQ create message object error!", (Throwable)e, 1L);
            if (this.sessionLock.isLocked()) {
                LOGGER.warn((Object)"sessionLock is lock! add message to failMsgs.");
                this.addFailMsg(detail);
                return;
            }
            if (retry) {
                this.rebuildsession();
                this.sendObj(detail, false);
                while (this.failMsgs.peek() != null) {
                    MessageUnit mu = (MessageUnit)this.failMsgs.poll();
                    this.sendObj(mu, false);
                }
                return;
            }
            throw new LegoJMSRuntimeException("ActiveMQ create message object error!", (Throwable)e);
        }
        try {
            this.publisher.publish((Message)bytesMessage);
        }
        catch (JMSException e) {
            LOGGER.error((Object)"ActiveMQ publisher error!", (Throwable)e, 1L);
            throw new LegoJMSRuntimeException("ActiveMQ publisher error!", (Throwable)e);
        }
    }

    private void addFailMsg(MessageUnit detail) {
        try {
            if (!this.containFailMsg(detail)) {
                this.failMsgs.put(detail);
            }
        }
        catch (InterruptedException e1) {
            LOGGER.error((Object)"failMsgs.put(mu) is InterruptedException!!", 1L);
            return;
        }
    }

    private boolean containFailMsg(MessageUnit detail) {
        Object[] data0 = this.getMessageUnitDataArray(detail);
        for (MessageUnit failMsg : this.failMsgs) {
            Object[] data1 = this.getMessageUnitDataArray(failMsg);
            if (!Arrays.equals(data0, data1)) continue;
            return true;
        }
        return false;
    }

    private Object[] getMessageUnitDataArray(MessageUnit detail) {
        return new Object[]{detail.getMt(), detail.getSourceAppName(), detail.getCmdcode(), detail.getObj()};
    }

    public byte[] encodeSendMessage(MessageUnit detail) {
        byte[] bytes = null;
        ByteArrayOutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            os = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(detail);
            bytes = os.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error((Object)"encodeMessage is error!", (Throwable)e, 1L);
            throw new LegoUncheckedException("encodeSendMessage is error!", (Throwable)e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"stream's closing is error!", (Throwable)e, 1L);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"stream's closing is error!", (Throwable)e, 1L);
            }
        }
        return bytes;
    }

    private void reconnect(String connectFactory) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectFactory);
        try {
            this.disconnect();
            this.conn = connectionFactory.createTopicConnection();
            this.conn.start();
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
            if (this.messagelistener != null) {
                this.setListener(this.messagelistener);
            } else {
                LOGGER.error((Object)"when reconnect,the TopoicClient's SubscriberProxy-messagelistener is null !!", 1L);
            }
        }
        catch (JMSException e) {
            LOGGER.error((Object)"reconnect activemq server error!", (Throwable)e, 1L);
            throw new LegoJMSInitializeException("reconnect activemq server error!", (Throwable)e);
        }
    }

    private void rebuildsession() {
        this.sessionLock.lock();
        try {
            this.closeSubscriberPublisherAndSession();
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
            if (this.messagelistener != null) {
                this.setListener(this.messagelistener);
            } else {
                LOGGER.error((Object)"when rebuildsession,the TopoicClient's SubscriberProxy-messagelistener is null !!", 1L);
            }
        }
        catch (JMSException e) {
            LOGGER.error((Object)"rebuildsession error!!", (Throwable)e, 1L);
            this.reconnect(this.url);
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        JMSException ex = null;
        boolean shouldThrow = false;
        try {
            this.closeSubscriberPublisherAndSession();
        }
        catch (JMSException e) {
            ex = e;
            shouldThrow = true;
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (JMSException e) {
                ex = e;
                shouldThrow = true;
            }
        }
        if (shouldThrow) {
            LOGGER.error((Object)"disconnect topic error!", (Throwable)ex, 1L);
            throw new LegoJMSDestoryException("disconnect topic error!", (Throwable)ex);
        }
        Class<AbstractInactivityMonitor> clazz = AbstractInactivityMonitor.class;
        synchronized (AbstractInactivityMonitor.class) {
            Field checkerCounterField = ReflectUtil.field(AbstractInactivityMonitor.class, (String)"CHECKER_COUNTER", Integer.TYPE);
            int checkerCounter = (Integer)Integer.class.cast(ReflectUtil.get(AbstractInactivityMonitor.class, (Field)checkerCounterField));
            LOGGER.error((Object)("TopicClient disconnect checkerCounter=" + checkerCounter));
            ReflectUtil.set(AbstractInactivityMonitor.class, (Field)checkerCounterField, (Object)0);
            this.closeTimer("WRITE_CHECK_TIMER");
            this.closeTimer("READ_CHECK_TIMER");
            Field field = ReflectUtil.field(AbstractInactivityMonitor.class, (String)"ASYNC_TASKS", ThreadPoolExecutor.class);
            ThreadPoolExecutor asyncTasks = (ThreadPoolExecutor)ThreadPoolExecutor.class.cast(ReflectUtil.get(AbstractInactivityMonitor.class, (Field)field));
            if (!VerifyUtil.isEmpty((Object)asyncTasks)) {
                try {
                    ThreadPoolUtils.shutdownGraceful((ExecutorService)asyncTasks, (long)TimeUnit.SECONDS.toMillis(10L));
                }
                finally {
                    ReflectUtil.set(AbstractInactivityMonitor.class, (Field)field, null);
                }
            }
            // ** MonitorExit[var3_5] (shouldn't be in output)
            return;
        }
    }

    private void closeTimer(String name) {
        Field field = ReflectUtil.field(AbstractInactivityMonitor.class, (String)name, Timer.class);
        if (field == null) {
            return;
        }
        Timer timer = this.getField(AbstractInactivityMonitor.class, name, Timer.class);
        if (timer == null) {
            return;
        }
        timer.purge();
        timer.cancel();
        ReflectUtil.set(AbstractInactivityMonitor.class, (Field)field, null);
    }

    private <T> T getField(Class<?> clazz, String name, Class<T> fieldType) {
        Field field = ReflectUtil.field(clazz, (String)name, fieldType);
        return fieldType.cast(ReflectUtil.get(clazz, (Field)field));
    }

    private void closeSubscriberPublisherAndSession() throws JMSException {
        JMSException ex = null;
        boolean shouldThrow = false;
        try {
            if (this.subscriber != null) {
                this.subscriber.close();
            }
        }
        catch (JMSException e) {
            ex = e;
            shouldThrow = true;
        }
        try {
            if (this.publisher != null) {
                this.publisher.close();
            }
        }
        catch (JMSException e) {
            ex = e;
            shouldThrow = true;
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (JMSException e) {
            ex = e;
            shouldThrow = true;
        }
        if (shouldThrow) {
            throw ex;
        }
    }
}

