/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance.track;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;
import org.hibernate.SessionFactory;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.Statistics;

public class OperationTrackListener
implements LoadEventListener {
    private static final long serialVersionUID = -5043950293766506842L;
    private static final Log LOGGER = LogFactory.getInstance(OperationTrackListener.class);

    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) {
        EventSource session = event.getSession();
        SessionFactory sf = session.getSessionFactory();
        Statistics statistics = sf.getStatistics();
        this.trackSessionStatistics(session.getStatistics());
        this.trackSessionFactoryStatistics(statistics);
        this.trackEntityStatistics(event.getEntityClassName(), statistics.getEntityStatistics(event.getEntityClassName()));
    }

    private void trackSessionStatistics(SessionStatistics statistics) {
        statistics.getCollectionCount();
        statistics.getEntityCount();
    }

    private void trackSessionFactoryStatistics(Statistics statistics) {
        statistics.getConnectCount();
        statistics.getEntityDeleteCount();
        statistics.getEntityFetchCount();
        statistics.getEntityInsertCount();
        statistics.getEntityLoadCount();
        statistics.getEntityUpdateCount();
        statistics.getFlushCount();
        statistics.getOptimisticFailureCount();
        statistics.getPrepareStatementCount();
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Invoke %s Queries,Max time query is:%s spends %s.", statistics.getQueryExecutionCount(), statistics.getQueryExecutionMaxTimeQueryString(), statistics.getQueryExecutionMaxTime()), 1L);
        double queryCacheHitCount = statistics.getQueryCacheHitCount();
        double queryCacheMissCount = statistics.getQueryCacheMissCount();
        double allCount = queryCacheHitCount + queryCacheMissCount;
        if (allCount > 0.0) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Query Hit ratio:%s.", queryCacheHitCount / allCount), 1L);
        }
        statistics.getSessionCloseCount();
        statistics.getSessionOpenCount();
        LOGGER.info((Object)String.format(Locale.ENGLISH, "%s sessions was opened,%s sessions was closed,%s sessions need to closed!", statistics.getSessionOpenCount(), statistics.getSessionCloseCount(), statistics.getSessionOpenCount() - statistics.getSessionCloseCount()), 1L);
        if (statistics.getTransactionCount() > 0L) {
            double tranHitRatio = (double)statistics.getSuccessfulTransactionCount() / (double)statistics.getTransactionCount();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Transaction invoked successful ratio:%s.", tranHitRatio), 1L);
        }
    }

    private void trackEntityStatistics(String entity, EntityStatistics statistics) {
        statistics.getDeleteCount();
        statistics.getFetchCount();
        statistics.getInsertCount();
        statistics.getLoadCount();
        statistics.getOptimisticFailureCount();
        statistics.getUpdateCount();
        long changes = statistics.getInsertCount() + statistics.getUpdateCount() + statistics.getDeleteCount();
        LOGGER.info((Object)String.format(Locale.ENGLISH, "%s changed %stimes", entity, changes), 1L);
    }
}

