/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.comm.internal.jms.core.MessageCenter;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import com.huawei.lego.nem.discover.sdk.service.INodeEditor;
import com.huawei.lego.nem.discover.service.AbstractDiscoveryThread;
import com.huawei.lego.nem.discover.util.DiscoveryUtil;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.util.StringUtils;

public class IcmpDiscoveryThread
extends AbstractDiscoveryThread {
    private static final Log LOGGER = LogFactory.getInstance(IcmpDiscoveryThread.class);
    private static final int VALUE_3000 = 3000;
    private List<INodeEditor> nodeEditorList = null;

    public IcmpDiscoveryThread(DiscoveryPolicy policy) {
        super(policy);
    }

    public IcmpDiscoveryThread(DiscoveryPolicy policy, List<INodeEditor> nodeEditorList) {
        this(policy);
        this.nodeEditorList = nodeEditorList;
    }

    @Override
    public void run() {
        DiscoveryResult discoveryResult = new DiscoveryResult();
        String ip = this.getPolicy().getStartIP();
        try {
            if (this.isSocketReachable(ip)) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Socket is reachable, ip=%s, port=%s.", ip, this.getPolicy().getParamMap().get("port")));
                this.doDisc(ip);
            } else {
                LOGGER.warn((Object)"Icmp ping is failed, need catch the error : %s", new Object[]{ip});
                discoveryResult.setDiscoveryPolicy(this.getPolicy());
                discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
                discoveryResult.setIpAddress(ip);
                discoveryResult.setSuccess(Boolean.valueOf(false));
                discoveryResult.setErrorCode(Long.valueOf(1061L));
                ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
            }
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Exception when discovery, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            discoveryResult.setDiscoveryPolicy(this.getPolicy());
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            discoveryResult.setIpAddress(ip);
            discoveryResult.setSuccess(Boolean.valueOf(false));
            discoveryResult.setErrorCode(Long.valueOf(ex.getErrorCode()));
            if (ex.getParameters() != null) {
                String[] errorparam = ex.getParameters();
                StringBuffer sbf = new StringBuffer();
                for (int i = 0; i < errorparam.length - 1; ++i) {
                    sbf.append(errorparam[i]);
                    sbf.append(',');
                }
                sbf.append(errorparam[errorparam.length - 1]);
                discoveryResult.setErrorParam(sbf.toString());
            }
            ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"exception when discovery,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            discoveryResult.setDiscoveryPolicy(this.getPolicy());
            discoveryResult.setFinishTime(new Timestamp(System.currentTimeMillis()));
            discoveryResult.setIpAddress(ip);
            discoveryResult.setSuccess(Boolean.valueOf(false));
            discoveryResult.setErrorCode(Long.valueOf(1053L));
            ServiceProvider.getDiscoveryService().updateDiscoveryResultAndPolicy(discoveryResult, true);
        }
    }

    private void doDisc(String ip) {
        DiscoveryPolicy policy = this.getPolicy();
        String sysoid = DiscoveryUtil.getSysOidByDeviceType(policy.getDeviceType(), policy.getDeviceSubType());
        boolean flag = false;
        for (INodeEditor nodeEditor : this.nodeEditorList) {
            Node node = new Node();
            node.setIpAddress(ip);
            node.setSysOid(sysoid);
            node = nodeEditor.editNode(node, policy);
            if (!StringUtils.hasText((String)node.getSysOid())) {
                LOGGER.warn((Object)"sys oid is null or empty after edit node, NodeEditor is : %s.", new Object[]{nodeEditor});
                continue;
            }
            node.setLocation(policy.getLocation());
            for (Protocol managementProtocol : policy.getManagementProtocolMap().values()) {
                managementProtocol.setIsTemplate(Boolean.valueOf(false));
                managementProtocol.setIsManagementProtocol(Boolean.valueOf(true));
                managementProtocol.setId(null);
                managementProtocol.setDiscoveryPolicy(null);
            }
            node.setManagementProtocolMap(policy.getManagementProtocolMap());
            node.setMainType(policy.getDeviceType());
            node.setSubType(policy.getDeviceSubType());
            HashMap<String, Object> messageBody = new HashMap<String, Object>();
            messageBody.put("icmpDiscoveredNode", node);
            messageBody.put("discoveryPolicy", policy);
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(101L);
            mu.setObj(messageBody);
            mu.setMt(MessageTopic.COMMAND);
            mu.setSourceAppName(this.getClass().getName());
            MessageCenter.getInstance().sendMessage(mu);
            flag = true;
            LOGGER.info((Object)"Send message after edit node.");
            CommonUtil.sleep((long)3000L);
            break;
        }
        if (!flag) {
            throw new LegoCheckedException(1057L);
        }
    }
}

