/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.backup;

import com.huawei.lego.cbb.i18n.sdk.I18nMgr;
import com.huawei.lego.core.sdk.file.util.FileFactory;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.nem.fault.dao.IFaultDao;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class BackupUtil {
    private static final int VALUE_2 = 2;
    private static final int VALUE_3 = 3;
    private static final Log LOGGER = LogFactory.getInstance(BackupUtil.class);
    private I18nMgr i18nMgr = null;
    private IFaultDao faultDao = null;

    public <T> int getTotalCount(Class<T> className, long endTime) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("createTimeEnd", String.valueOf(endTime));
        if (Alarm.class.getSimpleName().equals(className.getSimpleName())) {
            condition.put("clearStatus", String.valueOf(1));
        }
        return this.faultDao.getFaultCount(className, condition, false);
    }

    public <T> int getCurrentAlarmCount(Class<T> className) {
        HashMap<String, String> condition = new HashMap<String, String>();
        if (Alarm.class.getSimpleName().equals(className.getSimpleName())) {
            condition.put("clearStatus", String.valueOf(0));
        }
        return this.faultDao.getFaultCount(className, condition, false);
    }

    public <T> List<T> queryCurrentAlarms(Class<T> className, String orderField, boolean orderByAscend, int startIndex, int pageSize) {
        HashMap<String, String> condition = new HashMap<String, String>();
        if (Alarm.class.getSimpleName().equals(className.getSimpleName())) {
            condition.put("clearStatus", String.valueOf(0));
        }
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(startIndex);
        queryInfo.setTotalRow(pageSize);
        queryInfo.setOrderByField(orderField);
        queryInfo.setOrderByAscend(orderByAscend);
        return this.faultDao.queryFaults(className, condition, true, queryInfo);
    }

    public <T> List<T> queryFaults(Class<T> className, long endTime, String orderField, boolean orderByAscend, int startIndex, int pageSize) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("createTimeEnd", String.valueOf(endTime));
        if (Alarm.class.getSimpleName().equals(className.getSimpleName())) {
            condition.put("clearStatus", String.valueOf(1));
        }
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(startIndex);
        queryInfo.setTotalRow(pageSize);
        queryInfo.setOrderByField(orderField);
        queryInfo.setOrderByAscend(orderByAscend);
        return this.faultDao.queryFaults(className, condition, true, queryInfo);
    }

    public <T> void deleteFaults(Class<T> clazz, List<T> faultList) {
        if (null == faultList || faultList.isEmpty()) {
            return;
        }
        if (Alarm.class.getSimpleName().equals(clazz.getSimpleName())) {
            this.faultDao.deleteHistorys(clazz, faultList);
        }
        this.faultDao.deleteFaults(clazz, faultList);
    }

    public List<String> getColumn(String lang, String[] keys) {
        ArrayList<String> column = new ArrayList<String>();
        if (null == keys) {
            return column;
        }
        for (String key : keys) {
            column.add(this.getText(key, lang));
        }
        return column;
    }

    public boolean exportFaultData(List<?> faultList, String[] fileInfo, int exportType, File tempFile, int serialNum) {
        if (null == fileInfo || fileInfo.length < 3) {
            LOGGER.error((Object)"invalid fileInfo length ", 1L);
            return false;
        }
        String fileType = fileInfo[0];
        String lang = fileInfo[1];
        String fileNameTmp = fileInfo[2];
        CommonUtil.sleep((long)100L);
        List<String> column = this.getColumn(lang, exportType);
        String fileNameIndex = "";
        List<Object> faultInfo = new ArrayList();
        if (exportType == 1) {
            faultInfo = this.convertAlarmContent(faultList, lang);
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Write alarm info to file, alarm count: %s.", faultInfo.size()), 1L);
            fileNameIndex = "history_alarm_";
        } else if (exportType == 2) {
            faultInfo = this.convertEventContent(faultList, lang);
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Write event info to file, event count: %s.", faultInfo.size()), 1L);
            fileNameIndex = "event_";
        }
        try {
            FileUtil fileUtil = FileFactory.getFileUtil((String)fileType);
            if (fileUtil == null) {
                return false;
            }
            String downloadPath = fileNameTmp.contains("currentAlarm") ? this.getCurrentAlarmFile(tempFile, serialNum, fileNameTmp) : tempFile.getCanonicalPath() + File.separator + fileNameIndex + fileNameTmp + serialNum;
            fileUtil.fileSet("", column, downloadPath);
            if (null != lang && "en".equals(lang)) {
                fileUtil.setStrChar("UTF-8");
            } else {
                fileUtil.setStrChar("GBK");
            }
            fileUtil.writeFile(faultInfo);
            fileUtil.closeFile();
        }
        catch (IOException e) {
            LOGGER.error((Object)"write file error in exportFaultData", (Throwable)e, 1L);
        }
        return true;
    }

    private String getCurrentAlarmFile(File tempFile, int serialNum, String fileNameTmp) throws IOException {
        boolean isSuccess;
        String downloadPath = tempFile.getCanonicalPath() + File.separator + fileNameTmp;
        File exportFile = new File(downloadPath + ".csv");
        if (exportFile.exists() && serialNum == 0 && !(isSuccess = exportFile.delete())) {
            LOGGER.error((Object)"delete file error");
        }
        return downloadPath;
    }

    private List<List<String>> convertAlarmContent(List<Alarm> alarmList, String lang) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        if (null == alarmList) {
            return lstStr;
        }
        for (Alarm alarm : alarmList) {
            ArrayList<String> tempLst = new ArrayList<String>();
            tempLst.add(this.getText(FaultEnum.AlarmSeverity.getI18n((int)alarm.getSeverity()), lang));
            tempLst.add(this.getText(FaultEnum.ConfirmState.getI18n((int)alarm.getConfirmStatus()), lang));
            tempLst.add(this.getText(alarm.getAlarmName(), lang));
            tempLst.add(this.getText(FaultEnum.AlarmType.getI18n((int)alarm.getAlarmType()), lang));
            tempLst.add(String.valueOf(alarm.getCount()));
            tempLst.add(alarm.getMoName());
            tempLst.add(this.formateTime(alarm.getGmt(), alarm.getCreateTime()));
            tempLst.add(this.formateTime(alarm.getGmt(), alarm.getModTime()));
            tempLst.add(this.formateTime(alarm.getGmt(), alarm.getClearTime()));
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    private List<String> getColumn(String lang, int exportType) {
        String[] keys = null;
        if (exportType == 1) {
            keys = new String[]{"lego.lab.fault.alarmLevel", "lego.dic.confirmstatus", "lego.lab.fault.saveAlarm.name", "lego.dic.warningtype", "lego.lab.fault.alarmCount", "lego.lab.fault.saveAlarm.alarmSource", "lego.lab.fault.firstTime", "lego.lab.fault.lastTime", "lego.lab.fault.clearTime"};
        } else if (exportType == 2) {
            keys = new String[]{"lego.lab.fault.saveAlarm.name", "lego.lab.fault.saveEvent.eventSource", "lego.lab.fault.saveAlarm.createTime"};
        } else if (exportType == 3) {
            keys = new String[]{"lego.lab.fault.alarmLevel", "lego.lab.fault.saveAlarm.name", "lego.dic.warningtype", "lego.lab.fault.saveAlarm.alarmSource", "lego.lab.fault.saveAlarm.createTime", "lego.lab.fault.rule"};
        }
        return this.getColumn(lang, keys);
    }

    private List<List<String>> convertEventContent(List<Event> eventList, String lang) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        if (null == eventList) {
            return lstStr;
        }
        for (Event event : eventList) {
            ArrayList<String> tempLst = new ArrayList<String>();
            tempLst.add(this.getText(event.getEventName(), lang));
            tempLst.add(event.getMoName());
            tempLst.add(this.formateTime(event.getGmt(), event.getTime()));
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    public String getText(String key, String lang) {
        Locale locale = null;
        locale = "en".equals(lang) ? new Locale(lang) : new Locale("zh", "CN");
        return this.i18nMgr.getString(key, locale);
    }

    private String formateTime(String gmt, long date) {
        String resultString = "";
        if (date == 0L) {
            return resultString;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (gmt == null || "".equals(gmt)) {
            gmt = "";
        }
        resultString = "".equals(gmt) ? simpleDateFormat.format(new Date(date)) : simpleDateFormat.format(new Date(date)) + " " + gmt;
        return resultString;
    }

    public I18nMgr getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMgr i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    public void setFaultDao(IFaultDao faultDao) {
        this.faultDao = faultDao;
    }
}

