/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap;

import com.huawei.lego.core.base.thread.CommonThread;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.AlarmPDU;
import com.huawei.lego.nem.fault.sdk.model.SnmpTrapPDU;
import com.huawei.lego.nem.fault.sdk.service.IPDUFilter;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import org.snmp4j.CommandResponderEvent;

public final class PDUDispatcher {
    private static PDUDispatcher sInstance = null;
    private static final int QUEUE_SIZE = 10000;
    private static final Log LOG = LogFactory.getInstance(PDUDispatcher.class);
    private BlockingQueue<AlarmPDU> pduQueue = new LinkedBlockingQueue<AlarmPDU>(10000);
    private List<IPDUFilter> filters = new ArrayList<IPDUFilter>();
    private boolean isContinueRunning = true;
    private RunnableFuture<Integer> runnableFuture = null;

    private PDUDispatcher() {
    }

    public static synchronized PDUDispatcher getInstance() {
        if (null == sInstance) {
            sInstance = new PDUDispatcher();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<PDUDispatcher> clazz = PDUDispatcher.class;
        synchronized (PDUDispatcher.class) {
            final PDUDispatcher pduDispatcher = this;
            CommonThread thread = new CommonThread(){

                @Override
                protected void execute() {
                    pduDispatcher.execute();
                }
            };
            thread.setThreadName("alarm pdu dispatch thread");
            this.runnableFuture = ExecutionService.newTaskFor(thread, 0);
            ExecutionService.submitTask(this.runnableFuture);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stop() {
        this.isContinueRunning = false;
        if (null != this.runnableFuture) {
            this.runnableFuture.cancel(true);
        }
        this.removeAllPDUFilters();
    }

    public void notifyPDU(AlarmPDU alarmPdu) {
        if (10000 <= this.pduQueue.size()) {
            LOG.info((Object)"PduQueue exceeds queue size, current size: %s trapoid: %s", new Object[]{this.pduQueue.size(), this.getTrapOid(alarmPdu)});
            return;
        }
        this.pduQueue.add(alarmPdu);
    }

    public void execute() {
        while (this.isContinueRunning) {
            try {
                AlarmPDU alarmPdu = this.pduQueue.take();
                for (IPDUFilter filter : this.filters) {
                    filter.doFilter(alarmPdu);
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupt Thread[alarm pdu dispatch thread].");
                break;
            }
            catch (Exception e) {
                LOG.error((Object)"Throwable was caught when in Thread[alarm pdu dispatch thread].", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public List<IPDUFilter> getPDUFilters() {
        return this.filters;
    }

    public synchronized void registerPDUFilter(IPDUFilter filter) {
        this.filters.add(filter);
    }

    public synchronized void deRegisterPDUFilter(IPDUFilter filter) {
        this.filters.remove(filter);
    }

    public synchronized void removeAllPDUFilters() {
        this.filters.clear();
    }

    public void setFilters(List<IPDUFilter> filters) {
        this.filters = filters;
    }

    private String getTrapOid(AlarmPDU alarmPdu) {
        String trapOid = "";
        if (alarmPdu == null || alarmPdu.getPduObj() == null) {
            return trapOid;
        }
        Serializable pduObj = alarmPdu.getPduObj();
        if (pduObj instanceof CommandResponderEvent) {
            CommandResponderEvent snmpEvent = (CommandResponderEvent)pduObj;
            SnmpTrapPDU snmpPdu = FaultUtil.convertSnmpPDU(snmpEvent);
            return snmpPdu.getTrapoid();
        }
        return trapOid;
    }
}

