/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.listener;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.trap.listener.IForceDecodeAlarmListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ForceDecodeDefender {
    private static final Log logger = LogFactory.getInstance(ForceDecodeDefender.class);
    private static final String ADDR_SPLIT = "/";
    private static final int LOCK_TIME = 120;
    private static final int CACHE_SIZE = 1000;
    private static final int FAILED_THRESHOLD = 5;
    private static Map<String, Long> cache = new ConcurrentHashMap<String, Long>();
    private static Map<String, Integer> failedTimeCache = new ConcurrentHashMap<String, Integer>();
    private static List<IForceDecodeAlarmListener> listeners = new ArrayList<IForceDecodeAlarmListener>();
    private static ForceDecodeDefender defender = null;
    private static long globalLockTime = 0L;

    private ForceDecodeDefender() {
    }

    public static long getGlobalLockTime() {
        return globalLockTime;
    }

    public static void setGlobalLockTime(long globalLockTime) {
        ForceDecodeDefender.globalLockTime = globalLockTime;
    }

    public static synchronized ForceDecodeDefender getInstance() {
        if (defender == null) {
            defender = new ForceDecodeDefender();
        }
        return defender;
    }

    public void registAlarmListener(IForceDecodeAlarmListener listener) {
        listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked(String key) {
        Class<ForceDecodeDefender> clazz = ForceDecodeDefender.class;
        synchronized (ForceDecodeDefender.class) {
            String lockKey = key;
            if (lockKey.contains(ADDR_SPLIT)) {
                lockKey = lockKey.substring(0, lockKey.indexOf(ADDR_SPLIT));
            }
            long currentTime = System.currentTimeMillis();
            if (globalLockTime != 0L) {
                long checkTime = currentTime - globalLockTime;
                if (checkTime > 120000L) {
                    ForceDecodeDefender.setGlobalLockTime(0L);
                } else {
                    logger.warn((Object)("##### Global lock is not end, Obj:" + lockKey + ", OOjb" + key + ",release time:" + globalLockTime));
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
            }
            if (cache.containsKey(lockKey)) {
                long locketTime = cache.get(lockKey);
                long compTime = currentTime - locketTime;
                if (compTime > 120000L || compTime < 0L) {
                    cache.remove(lockKey);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                logger.warn((Object)("##### Target locked, Obj:" + lockKey + ", OOjb" + key + ",release time:" + compTime));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key) {
        Class<ForceDecodeDefender> clazz = ForceDecodeDefender.class;
        synchronized (ForceDecodeDefender.class) {
            String lockKey = key;
            if (null == lockKey) {
                logger.error((Object)"Param error, the key is null.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (lockKey.contains(ADDR_SPLIT)) {
                lockKey = lockKey.substring(0, lockKey.indexOf(ADDR_SPLIT));
            }
            long currentTime = System.currentTimeMillis();
            if (cache.size() >= 1000) {
                Set<Map.Entry<String, Long>> set = cache.entrySet();
                Iterator<Map.Entry<String, Long>> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Long> entry = iterator.next();
                    long compTime = currentTime - entry.getValue();
                    if (compTime <= 120000L && compTime >= 0L) continue;
                    iterator.remove();
                }
                if (cache.size() >= 1000) {
                    cache.clear();
                    ForceDecodeDefender.setGlobalLockTime(currentTime);
                    this.generateAlarm(lockKey);
                    logger.warn((Object)("##### global locked, time: " + currentTime + ",Obj:" + lockKey + ", OOjb" + key));
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            if (cache.containsKey(lockKey)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (failedTimeCache.containsKey(lockKey)) {
                int times = failedTimeCache.get(lockKey);
                if (times >= 5) {
                    this.doLock(lockKey, currentTime);
                    logger.warn((Object)("##### target obj locked, time: " + currentTime + ",Obj:" + lockKey + ", OOjb" + key));
                    failedTimeCache.remove(lockKey);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                failedTimeCache.put(lockKey, times + 1);
            } else {
                failedTimeCache.put(lockKey, 1);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void doLock(String lockKey, long currentTime) {
        this.generateAlarm(lockKey);
        cache.put(lockKey, currentTime);
    }

    private void generateAlarm(String lockKey) {
        for (IForceDecodeAlarmListener listener : listeners) {
            listener.onMessage(lockKey);
        }
    }
}

