/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.recv;

import com.huawei.lego.com.south.snmp.SnmpTrapRecvAPI;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.AlarmPDU;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.SnmpTrapPDU;
import com.huawei.lego.nem.fault.trap.PDUDispatcher;
import com.huawei.lego.nem.fault.trap.listener.ForceDecodeDefender;
import com.huawei.lego.nem.fault.util.FaultUtil;
import com.huawei.lego.nem.fault.util.snmp.SnmpV2cUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;

public class TrapMsgResponder
implements CommandResponder {
    private static final int VALUE_2 = 2;
    private static Log logger = LogFactory.getInstance(TrapMsgResponder.class);
    private static TrapMsgResponder instance = null;

    public static synchronized TrapMsgResponder getInstance() {
        if (null == instance) {
            instance = new TrapMsgResponder();
        }
        return instance;
    }

    public void processPdu(CommandResponderEvent event) {
        if (null == event || null == event.getPDU()) {
            logger.error((Object)"the event or pdu in event is null!", 1L);
            return;
        }
        if (event.getSecurityModel() == 2) {
            String securityName = new String(event.getSecurityName(), Charset.defaultCharset());
            if (!SnmpV2cUtil.validate(event.getPeerAddress().toString(), securityName)) {
                ForceDecodeDefender.getInstance().lock(event.getPeerAddress().toString());
                logger.warn((Object)("#### The v2 event or auth failed! add:" + event.getPeerAddress().toString()), 1L);
            }
        }
        logger.info((Object)new StringBuffer().append("recv an Snmp Trap PDU: ").append(event.getPeerAddress()).append(", VB: " + event.getPDU().getVariableBindings()).toString(), 1L);
        try {
            PDUDispatcher.getInstance().notifyPDU(new AlarmPDU(FaultEnum.PDUType.SNMP, (Serializable)event));
            SnmpTrapPDU snmppdu = FaultUtil.convertSnmpPDU(event);
            SnmpTrapRecvAPI.getInstance().notifyListener(snmppdu);
        }
        catch (Exception ex) {
            logger.error((Object)("exception happened when receive trap event:" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
        }
    }
}

