/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.TraversalSpec;
import java.util.ArrayList;
import java.util.List;

public class DataCenterAction {
    public List<VsDataCenter> queryVsphereDataCenter(String vcenterUuid) {
        ArrayList<String> dsList = new ArrayList<String>();
        dsList.add("Datacenter");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        if (null == conn) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObjectReference containerView = PropertyCollectorUtil.createContainerView(conn, conn.getServiceContent().getRootFolder(), dsList, true);
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(containerView);
        oSpec.setSkip(Boolean.valueOf(false));
        TraversalSpec tSpec = PropertyCollectorUtil.createTraversalSpec("traverseEntities", "ContainerView", "view");
        oSpec.getSelectSet().add(tSpec);
        ArrayList<String> pathSet = new ArrayList<String>();
        pathSet.add("name");
        pathSet.add("datastore");
        pathSet.add("network");
        PropertySpec dsSpec = PropertyCollectorUtil.createPropertySpec("Datacenter", pathSet);
        ArrayList<ObjectSpec> objectSet = new ArrayList<ObjectSpec>();
        objectSet.add(oSpec);
        ArrayList<PropertySpec> propSet = new ArrayList<PropertySpec>();
        propSet.add(dsSpec);
        List<PropertyFilterSpec> fSpecList = PropertyCollectorUtil.createPropertyFilterSpecList(objectSet, propSet);
        List<ObjectContent> queryResult = PropertyCollectorUtil.retrievePropertiesEx(conn, fSpecList);
        VMAction.destroyContainerView(containerView, conn.getVimPort());
        ArrayList<VsDataCenter> result = new ArrayList<VsDataCenter>();
        if (!VerifyUtil.isEmpty(queryResult)) {
            for (ObjectContent oc : queryResult) {
                VsDataCenter dc = new VsDataCenter();
                dc.setMoId(oc.getObj().getValue());
                dc.setName(PropertyCollectorUtil.getPropertyByPath(oc, "name", String.class));
                List<ManagedObjectReference> dsMors = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "datastore", ManagedObjectReference.class);
                for (ManagedObjectReference mor : dsMors) {
                    dc.getDataStores().add(mor.getValue());
                }
                List<ManagedObjectReference> netWorkMors = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "network", ManagedObjectReference.class);
                for (ManagedObjectReference mor : netWorkMors) {
                    dc.getNetWorks().add(mor.getValue());
                }
                result.add(dc);
            }
        }
        return result;
    }
}

