/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereTaskResultMonitor;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.discovery.util.PropertyCollectorUtil;
import com.huawei.ism.drm.vsphere.discovery.util.VsphereEnumParse;
import com.huawei.ism.drm.vsphere.sdk.model.VCenterNicIpInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VmConfigRdmInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.cbb.network.sdk.model.IPv6Address;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.AlreadyExists;
import com.huawei.vmware.vim25.AlreadyExistsFaultMsg;
import com.huawei.vmware.vim25.ArrayOfHostDatastoreBrowserSearchResults;
import com.huawei.vmware.vim25.ArrayOfVirtualDevice;
import com.huawei.vmware.vim25.ClusterPowerOnVmOption;
import com.huawei.vmware.vim25.ClusterPowerOnVmResult;
import com.huawei.vmware.vim25.CustomizationAdapterMapping;
import com.huawei.vmware.vim25.CustomizationDhcpIpGenerator;
import com.huawei.vmware.vim25.CustomizationDhcpIpV6Generator;
import com.huawei.vmware.vim25.CustomizationFault;
import com.huawei.vmware.vim25.CustomizationFaultFaultMsg;
import com.huawei.vmware.vim25.CustomizationFixedIp;
import com.huawei.vmware.vim25.CustomizationFixedIpV6;
import com.huawei.vmware.vim25.CustomizationFixedName;
import com.huawei.vmware.vim25.CustomizationGlobalIPSettings;
import com.huawei.vmware.vim25.CustomizationIPSettings;
import com.huawei.vmware.vim25.CustomizationIPSettingsIpV6AddressSpec;
import com.huawei.vmware.vim25.CustomizationIdentitySettings;
import com.huawei.vmware.vim25.CustomizationIpGenerator;
import com.huawei.vmware.vim25.CustomizationIpV6Generator;
import com.huawei.vmware.vim25.CustomizationLinuxOptions;
import com.huawei.vmware.vim25.CustomizationLinuxPrep;
import com.huawei.vmware.vim25.CustomizationName;
import com.huawei.vmware.vim25.CustomizationOptions;
import com.huawei.vmware.vim25.CustomizationSpec;
import com.huawei.vmware.vim25.DeviceBackedVirtualDiskSpec;
import com.huawei.vmware.vim25.DisallowedOperationOnFailoverHost;
import com.huawei.vmware.vim25.DistributedVirtualSwitchPortConnection;
import com.huawei.vmware.vim25.DrsBehavior;
import com.huawei.vmware.vim25.DuplicateName;
import com.huawei.vmware.vim25.DuplicateNameFaultMsg;
import com.huawei.vmware.vim25.FileFault;
import com.huawei.vmware.vim25.FileFaultFaultMsg;
import com.huawei.vmware.vim25.FileInfo;
import com.huawei.vmware.vim25.GuestInfo;
import com.huawei.vmware.vim25.HostDatastoreBrowserSearchResults;
import com.huawei.vmware.vim25.HostDatastoreBrowserSearchSpec;
import com.huawei.vmware.vim25.InsufficientResourcesFault;
import com.huawei.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.huawei.vmware.vim25.InvalidArgument;
import com.huawei.vmware.vim25.InvalidArgumentFaultMsg;
import com.huawei.vmware.vim25.InvalidDatastore;
import com.huawei.vmware.vim25.InvalidDatastoreFaultMsg;
import com.huawei.vmware.vim25.InvalidName;
import com.huawei.vmware.vim25.InvalidNameFaultMsg;
import com.huawei.vmware.vim25.InvalidPowerState;
import com.huawei.vmware.vim25.InvalidPowerStateFaultMsg;
import com.huawei.vmware.vim25.InvalidState;
import com.huawei.vmware.vim25.InvalidStateFaultMsg;
import com.huawei.vmware.vim25.LocalizableMessage;
import com.huawei.vmware.vim25.ManagedEntityStatus;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;
import com.huawei.vmware.vim25.NotEnoughLicenses;
import com.huawei.vmware.vim25.NotFound;
import com.huawei.vmware.vim25.NotFoundFaultMsg;
import com.huawei.vmware.vim25.NotSupported;
import com.huawei.vmware.vim25.NotSupportedFaultMsg;
import com.huawei.vmware.vim25.ObjectContent;
import com.huawei.vmware.vim25.ObjectSpec;
import com.huawei.vmware.vim25.OptionValue;
import com.huawei.vmware.vim25.OutOfBounds;
import com.huawei.vmware.vim25.OutOfBoundsFaultMsg;
import com.huawei.vmware.vim25.PropertyFilterSpec;
import com.huawei.vmware.vim25.PropertySpec;
import com.huawei.vmware.vim25.RuntimeFault;
import com.huawei.vmware.vim25.RuntimeFaultFaultMsg;
import com.huawei.vmware.vim25.SharesInfo;
import com.huawei.vmware.vim25.SharesLevel;
import com.huawei.vmware.vim25.StorageIOAllocationInfo;
import com.huawei.vmware.vim25.TaskInProgress;
import com.huawei.vmware.vim25.TaskInProgressFaultMsg;
import com.huawei.vmware.vim25.ToolsUnavailableFaultMsg;
import com.huawei.vmware.vim25.TraversalSpec;
import com.huawei.vmware.vim25.VimPortType;
import com.huawei.vmware.vim25.VirtualDevice;
import com.huawei.vmware.vim25.VirtualDeviceBackingInfo;
import com.huawei.vmware.vim25.VirtualDeviceConfigSpec;
import com.huawei.vmware.vim25.VirtualDeviceConfigSpecFileOperation;
import com.huawei.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.huawei.vmware.vim25.VirtualDeviceConnectInfo;
import com.huawei.vmware.vim25.VirtualDisk;
import com.huawei.vmware.vim25.VirtualDiskAdapterType;
import com.huawei.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.huawei.vmware.vim25.VirtualDiskRawDiskMappingVer1BackingInfo;
import com.huawei.vmware.vim25.VirtualDiskSpec;
import com.huawei.vmware.vim25.VirtualDiskType;
import com.huawei.vmware.vim25.VirtualEthernetCard;
import com.huawei.vmware.vim25.VirtualEthernetCardDistributedVirtualPortBackingInfo;
import com.huawei.vmware.vim25.VirtualEthernetCardLegacyNetworkBackingInfo;
import com.huawei.vmware.vim25.VirtualEthernetCardNetworkBackingInfo;
import com.huawei.vmware.vim25.VirtualMachineConfigInfo;
import com.huawei.vmware.vim25.VirtualMachineConfigSpec;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineQuestionInfo;
import com.huawei.vmware.vim25.VirtualMachineRuntimeInfo;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import com.huawei.vmware.vim25.VirtualMachineToolsVersionStatus;
import com.huawei.vmware.vim25.VmConfigFault;
import com.huawei.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VMAction {
    private static final Log LOG = LogFactory.getInstance(VMAction.class);
    private static final String GUEST_STATE = "guest.guestState";
    private static final String GUEST_VMTOOL_STATUS = "guest.toolsRunningStatus";
    private static final int THOUNDS_NUM = 1000;
    private static final int RDM_DEFAULT_SHARE = 1000;
    private static final String INFO_RESULT = "info.result";
    private static final String MAC_MAP = "virtualEthernetCardMacMap";

    public static void destroyContainerView(ManagedObjectReference viewMor, VimPortType vimPort) {
        if (Objects.isNull(viewMor)) {
            return;
        }
        try {
            vimPort.destroyView(viewMor);
        }
        catch (RuntimeFaultFaultMsg e) {
            String localizedMessage = e.getFaultInfo().getFaultCause().getLocalizedMessage();
            LOG.error((Object)"Failing to destroy view: %s", new Object[]{localizedMessage});
        }
    }

    public List<VsphereVirtualMachine> queryAllVms(VmwareConnection conn) {
        LOG.debug((Object)"QueryAllVms start");
        if (null == conn) {
            LOG.error((Object)"Query all vms, but connection is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return this.queryVmByContainer(conn.getServiceContent().getRootFolder(), conn);
    }

    public List<VsphereVirtualMachine> queryVmByContainer(ManagedObjectReference containerMor, VmwareConnection conn) {
        if (Objects.isNull(conn)) {
            LOG.error((Object)"Query vm by container, but connection is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> vmList = new ArrayList<String>();
        vmList.add("VirtualMachine");
        ManagedObjectReference containerView = PropertyCollectorUtil.createContainerView(conn, containerMor, vmList, true);
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(containerView);
        oSpec.setSkip(Boolean.valueOf(true));
        TraversalSpec tSpec = PropertyCollectorUtil.createTraversalSpec("traverseEntities", "ContainerView", "view");
        oSpec.getSelectSet().add(tSpec);
        List<String> pathSet = this.createPathSetForVm();
        PropertySpec vmSpec = PropertyCollectorUtil.createPropertySpec("VirtualMachine", pathSet);
        ArrayList<ObjectSpec> objectSet = new ArrayList<ObjectSpec>();
        objectSet.add(oSpec);
        ArrayList<PropertySpec> propSet = new ArrayList<PropertySpec>();
        propSet.add(vmSpec);
        List<PropertyFilterSpec> fSpecList = PropertyCollectorUtil.createPropertyFilterSpecList(objectSet, propSet);
        List<ObjectContent> queryResult = PropertyCollectorUtil.retrievePropertiesEx(conn, fSpecList);
        VMAction.destroyContainerView(containerView, conn.getVimPort());
        List<VsphereDataStore> dataStoreList = new DataStoreAction().queryDataStoreByContainer(containerMor, conn);
        HashMap<String, VsphereDataStore> dsMap = new HashMap<String, VsphereDataStore>();
        for (VsphereDataStore dataStore : dataStoreList) {
            dsMap.put(dataStore.getUuid(), dataStore);
        }
        ArrayList<VsphereVirtualMachine> result = new ArrayList<VsphereVirtualMachine>();
        if (!VerifyUtil.isEmpty(queryResult)) {
            for (ObjectContent oc : queryResult) {
                VsphereVirtualMachine vm = this.parseVM(oc, conn, dsMap);
                if (VerifyUtil.isEmpty((Object)vm)) continue;
                result.add(vm);
            }
        }
        return result;
    }

    private List<String> createPathSetForVm() {
        ArrayList<String> pathSet = new ArrayList<String>();
        pathSet.add("name");
        pathSet.add("parentVApp");
        pathSet.add("guest");
        pathSet.add("config");
        pathSet.add("guestHeartbeatStatus");
        pathSet.add("resourcePool");
        pathSet.add("config.hardware.device");
        pathSet.add("runtime.host");
        pathSet.add("summary.config.guestFullName");
        pathSet.add("network");
        return pathSet;
    }

    private VsphereVirtualMachine parseVM(ObjectContent oc, VmwareConnection conn, Map<String, VsphereDataStore> dsMap) {
        VsphereVirtualMachine vm = new VsphereVirtualMachine();
        try {
            String vCenterUuid = conn.getVcenterUuid();
            vm.setUuid(vCenterUuid + ":" + oc.getObj().getValue());
            vm.setName(PropertyCollectorUtil.getPropertyByPath(oc, "name", String.class));
            vm.setIsVApp(Boolean.valueOf(PropertyCollectorUtil.getPropertyByPath(oc, "parentVApp", ManagedObjectReference.class) != null));
            String hostMoId = PropertyCollectorUtil.getPropertyByPath(oc, "runtime.host", ManagedObjectReference.class).getValue();
            vm.setHostUuid(vCenterUuid + ":" + hostMoId);
            this.getOSInfo(oc, vm);
            this.setVmGuestInfo(oc, vm);
            List<VirtualDevice> virtualDevices = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "config.hardware.device", VirtualDevice.class);
            JSONArray array = this.getVmVirtualDeviceInfo(vm, conn, virtualDevices, oc, dsMap);
            vm.setVmConfig(array.toString());
            VirtualMachineConfigInfo vmConfig = PropertyCollectorUtil.getPropertyByPath(oc, "config", VirtualMachineConfigInfo.class);
            if (null != vmConfig) {
                String uuid = vmConfig.getUuid();
                vm.setVmUuid(uuid);
                String vmPath = vmConfig.getFiles().getVmPathName();
                vm.setVmPath(vmPath);
                vm.setIsTemplate(Boolean.valueOf(vmConfig.isTemplate()));
            }
            ManagedEntityStatus health = PropertyCollectorUtil.getPropertyByPath(oc, "guestHeartbeatStatus", ManagedEntityStatus.class);
            DrmVsphereEnumDefine.VSPHERE_MANAGEDENTITY_STATUS_E healthStatus = VsphereEnumParse.parseManagedEntityStatus(health);
            vm.setHealthStatus(Integer.valueOf(healthStatus.getValue()));
            ManagedObjectReference rpMor = PropertyCollectorUtil.getPropertyByPath(oc, "resourcePool", ManagedObjectReference.class);
            if (null != rpMor) {
                vm.setResourcePoolUuid(vCenterUuid + ":" + rpMor.getValue());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Parse vm info failed:vmUuid=%s, vmName=%s. %s", new Object[]{vm.getUuid(), vm.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            vm = null;
        }
        return vm;
    }

    private void getOSInfo(ObjectContent oc, VsphereVirtualMachine vm) {
        String summaryFullName = PropertyCollectorUtil.getPropertyByPath(oc, "summary.config.guestFullName", String.class);
        vm.setGuestFullName(summaryFullName);
        GuestInfo guestInfo = PropertyCollectorUtil.getPropertyByPath(oc, "guest", GuestInfo.class);
        if (null != guestInfo) {
            String guestFullName;
            String guestFamily = guestInfo.getGuestFamily();
            if (!VerifyUtil.isEmpty((String)guestFamily) && !"Unset".equals(guestFamily)) {
                vm.setGuestFamily(guestFamily);
            }
            if (!VerifyUtil.isEmpty((String)(guestFullName = guestInfo.getGuestFullName())) && !"Unset".equals(guestFullName)) {
                vm.setGuestFullName(this.getTempWorkaroundVersion(summaryFullName, guestFullName));
            }
        }
    }

    private String getTempWorkaroundVersion(String summaryFullName, String guestFullName) {
        return "CentOS 7 (64-bit)".equals(summaryFullName) ? summaryFullName : guestFullName;
    }

    private JSONArray getVmVirtualDeviceInfo(VsphereVirtualMachine vm, VmwareConnection conn, List<VirtualDevice> virtualDevices, ObjectContent oc, Map<String, VsphereDataStore> dsMap) {
        LOG.debug((Object)"GetVmVirtualDeviceInfo start");
        JSONArray array = new JSONArray();
        String vCenterUuid = conn.getVcenterUuid();
        for (VirtualDevice virtualDevice : virtualDevices) {
            VmVirtualDisk disk;
            if (virtualDevice instanceof VirtualEthernetCard) {
                JSONObject jsonObject = this.getNetworkInfo(conn, virtualDevice, oc);
                if (jsonObject == null) continue;
                jsonObject.put((Object)"devType", (Object)"VirtualEthernetCard");
                jsonObject.put((Object)"macAddress", (Object)((VirtualEthernetCard)virtualDevice).getMacAddress());
                jsonObject.put((Object)"ethernetCardName", (Object)this.translateIfNull(virtualDevice.getDeviceInfo().getLabel()));
                array.add((Object)jsonObject);
                continue;
            }
            if (!(virtualDevice instanceof VirtualDisk) || null == (disk = this.generateStorageDevice(virtualDevice, vCenterUuid, dsMap))) continue;
            vm.getVirtualDisk().add(disk);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"devType", (Object)"VirtualDisk");
            jsonObj.put((Object)"uuid", (Object)disk.getUuid());
            jsonObj.put((Object)"devKey", (Object)disk.getDeviceKey());
            jsonObj.put((Object)"storageType", (Object)disk.getStorageType());
            jsonObj.put((Object)"unitNumber", (Object)disk.getUnitNumber());
            jsonObj.put((Object)"storageUuid", (Object)disk.getDataStoreOrLunUuid());
            jsonObj.put((Object)"sharing", (Object)disk.getSharing());
            jsonObj.put((Object)"contentDataStoreUuid", (Object)disk.getContentDataStoreUuid());
            jsonObj.put((Object)"storageFileName", (Object)disk.getStorageFileName());
            jsonObj.put((Object)"datastoreId", (Object)disk.getDatastoreId());
            array.add((Object)jsonObj);
        }
        return array;
    }

    private void setVmGuestInfo(ObjectContent oc, VsphereVirtualMachine vm) {
        LOG.debug((Object)"SetVmGuestInfo start");
        GuestInfo guestInfo = PropertyCollectorUtil.getPropertyByPath(oc, "guest", GuestInfo.class);
        if (null != guestInfo) {
            String guestState = guestInfo.getGuestState();
            DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E guestStatus = VsphereEnumParse.parseGuestState(guestState);
            vm.setOsStatus(Integer.valueOf(guestStatus.getValue()));
            String hostName = guestInfo.getHostName();
            vm.setHostName(hostName);
            String ipAddress = guestInfo.getIpAddress();
            vm.setIpAddress(ipAddress);
        }
    }

    private JSONObject getNetworkInfo(VmwareConnection conn, VirtualDevice virtualDevice, ObjectContent oc) {
        JSONObject jsonObject = new JSONObject();
        LOG.debug((Object)"GetNetworkInfo start");
        String vCenterUuid = conn.getVcenterUuid();
        VirtualDeviceBackingInfo backingInfo = virtualDevice.getBacking();
        if (backingInfo instanceof VirtualEthernetCardNetworkBackingInfo) {
            jsonObject.put((Object)"networkType", (Object)"standardPortGroup");
            VirtualEthernetCardNetworkBackingInfo networkBackingInfo = (VirtualEthernetCardNetworkBackingInfo)virtualDevice.getBacking();
            String netWorkMoId = networkBackingInfo.getNetwork().getValue();
            jsonObject.put((Object)"netWorkUuid", (Object)(vCenterUuid + ":" + netWorkMoId));
            jsonObject.put((Object)"netWorkName", (Object)this.translateIfNull(networkBackingInfo.getDeviceName()));
        } else if (backingInfo instanceof VirtualEthernetCardDistributedVirtualPortBackingInfo) {
            jsonObject.put((Object)"networkType", (Object)"distributePortGroup");
            VirtualEthernetCardDistributedVirtualPortBackingInfo portGroupBackingInfo = (VirtualEthernetCardDistributedVirtualPortBackingInfo)virtualDevice.getBacking();
            String portGroupKey = portGroupBackingInfo.getPort().getPortgroupKey();
            portGroupKey = this.getPortGroupKey(conn, oc, portGroupKey);
            String portGroupName = this.getPortGroupName(conn, portGroupKey);
            jsonObject.put((Object)"netWorkUuid", (Object)(vCenterUuid + ":" + portGroupKey));
            jsonObject.put((Object)"netWorkName", (Object)portGroupName);
        } else if (backingInfo instanceof VirtualEthernetCardLegacyNetworkBackingInfo) {
            return null;
        }
        return jsonObject;
    }

    private String getPortGroupKey(VmwareConnection conn, ObjectContent oc, String portGroupKey) {
        List<ManagedObjectReference> ports = PropertyCollectorUtil.getPropertyCollectionByPath(oc, "network", ManagedObjectReference.class);
        if (VerifyUtil.isEmpty(ports)) {
            return portGroupKey;
        }
        for (ManagedObjectReference managedObjectReference : ports) {
            String netType = managedObjectReference.getType();
            if (!"DistributedVirtualPortgroup".equals(netType)) continue;
            ManagedObjectReference vswitchMor = new ManagedObjectReference();
            vswitchMor.setType("DistributedVirtualPortgroup");
            vswitchMor.setValue(managedObjectReference.getValue());
            String key = (String)GetMoPropsValueUtils.getInstance().entityProps(conn, vswitchMor, new String[]{"key"}).get("key");
            if (key == null || !key.equals(portGroupKey)) continue;
            return managedObjectReference.getValue();
        }
        return portGroupKey;
    }

    private String getPortGroupName(VmwareConnection conn, String portGroupKey) {
        LOG.debug((Object)"GetPortGroupName start");
        if (VerifyUtil.isEmpty((Object)conn) || VerifyUtil.isEmpty((String)portGroupKey)) {
            return "";
        }
        ManagedObjectReference vswitchMor = new ManagedObjectReference();
        vswitchMor.setType("DistributedVirtualPortgroup");
        vswitchMor.setValue(portGroupKey);
        String portGroupName = "UNKNOW";
        try {
            portGroupName = (String)GetMoPropsValueUtils.getInstance().entityProps(conn, vswitchMor, new String[]{"name"}).get("name");
        }
        catch (Exception e) {
            LOG.error((Object)"GetPortGroupName for:%s error", new Object[]{e, portGroupKey});
        }
        return portGroupName;
    }

    private VmVirtualDisk generateStorageDevice(VirtualDevice virtualDevice, String ip, Map<String, VsphereDataStore> dsMap) {
        LOG.debug((Object)"GenerateStorageDevice start");
        if (null == virtualDevice) {
            LOG.error((Object)"Generate storage device, but virtualDevice is null.");
            return null;
        }
        VmVirtualDisk disk = new VmVirtualDisk();
        disk.setControllerKey(virtualDevice.getControllerKey());
        disk.setDeviceKey(Integer.valueOf(virtualDevice.getKey()));
        disk.setUnitNumber(virtualDevice.getUnitNumber());
        if (virtualDevice.getBacking() instanceof VirtualDiskFlatVer2BackingInfo) {
            VirtualDiskFlatVer2BackingInfo vDevice = (VirtualDiskFlatVer2BackingInfo)virtualDevice.getBacking();
            disk.setStorageType("VMFS");
            disk.setUuid(vDevice.getUuid());
            ManagedObjectReference datastore = vDevice.getDatastore();
            disk.setDataStoreOrLunUuid(ip + ":" + (VerifyUtil.isEmpty((Object)datastore) ? "" : datastore.getValue()));
            VsphereDataStore dataStore = dsMap.get(disk.getDataStoreOrLunUuid());
            disk.setDatastoreId(this.checkAndGetDatastoreId(dataStore));
            disk.setSharing(vDevice.getSharing());
            disk.setStorageFileName(vDevice.getFileName());
            disk.setDiskMode(vDevice.getDiskMode());
        } else if (virtualDevice.getBacking() instanceof VirtualDiskRawDiskMappingVer1BackingInfo) {
            VirtualDiskRawDiskMappingVer1BackingInfo vDevice = (VirtualDiskRawDiskMappingVer1BackingInfo)virtualDevice.getBacking();
            disk.setUuid(vDevice.getUuid());
            disk.setStorageType(vDevice.getCompatibilityMode());
            disk.setDataStoreOrLunUuid(vDevice.getLunUuid());
            ManagedObjectReference datastore = vDevice.getDatastore();
            disk.setContentDataStoreUuid(ip + ":" + (VerifyUtil.isEmpty((Object)datastore) ? "" : datastore.getValue()));
            disk.setStorageFileName(vDevice.getFileName());
            disk.setDiskMode(vDevice.getDiskMode());
            disk.setSharing(vDevice.getSharing());
            VsphereDataStore dataStore = dsMap.get(disk.getContentDataStoreUuid());
            disk.setDatastoreId(this.checkAndGetDatastoreId(dataStore));
        } else {
            disk.setStorageType("UNSUPPORTED");
            disk.setDataStoreOrLunUuid("NONE");
        }
        return disk;
    }

    private String checkAndGetDatastoreId(VsphereDataStore dataStore) {
        if (VerifyUtil.isEmpty((Object)dataStore)) {
            return "";
        }
        return VsphereCommUtil.getDatastoreId(dataStore.getUrl());
    }

    private String translateIfNull(String str) {
        if (str == null || str.length() == 0) {
            return "UNKNOWN";
        }
        return str;
    }

    public ClusterPowerOnVmResult powerOnMultiVm(String vcenterUuid, String dcMoId, List<ManagedObjectReference> vmList) {
        ClusterPowerOnVmResult result = null;
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)dcMoId) || VerifyUtil.isEmpty(vmList)) {
            LOG.error((Object)"Power on vms, but parameter is empty: vcenterUuid[%s], dcMoId[%s].", new Object[]{vcenterUuid, dcMoId});
            throw new LegoCheckedException(-1L);
        }
        try {
            ManagedObjectReference dcMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(dcMoId, "Datacenter");
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            ArrayList<OptionValue> optList = new ArrayList<OptionValue>();
            OptionValue opt = new OptionValue();
            opt.setKey(ClusterPowerOnVmOption.OVERRIDE_AUTOMATION_LEVEL.value());
            opt.setValue((Object)DrsBehavior.PARTIALLY_AUTOMATED.value());
            optList.add(opt);
            ManagedObjectReference opTask = vimPort.powerOnMultiVMTask(dcMor, vmList, optList);
            MethodFault fault = new VsphereTaskResultMonitor(conn, opTask).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)fault)) {
                result = (ClusterPowerOnVmResult)GetMoPropsValueUtils.getInstance().entityProps(conn, opTask, new String[]{INFO_RESULT}).get(INFO_RESULT);
            } else {
                this.dealPowerOnException(fault);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Power on multi vm failed\uff1a", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Power on multi vm failed\uff1a", (long)-1L, null, (Log)LOG);
        }
        return result;
    }

    public boolean powerOnVM(String vcenterUuid, String vmMoId) {
        boolean ret = false;
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)vmMoId)) {
            LOG.error((Object)"Power on vm, but parameter is empty: vcenterUuid[%s], vmMoId[%s].", new Object[]{vcenterUuid, vmMoId});
            throw new LegoCheckedException(-1L);
        }
        try {
            ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            ManagedObjectReference opTask = vimPort.powerOnVMTask(vmMor, null);
            this.answerVM(vcenterUuid, vmMoId);
            MethodFault fault = new VsphereTaskResultMonitor(conn, opTask).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)fault)) {
                ret = true;
            } else {
                this.dealPowerOnException(fault);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Power on vm failed vmMoid=%s", new Object[]{e, vmMoId});
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Power on vm failed vmMoid=" + vmMoId), (long)-1L, null, (Log)LOG);
        }
        return ret;
    }

    public void answerVM(String vcenterUuid, String vmMoId) {
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)vmMoId)) {
            LOG.error((Object)"Answer vm, but parameter is empty: vcenterUuid[%s], vmMoId[%s].", new Object[]{vcenterUuid, vmMoId});
            throw new LegoCheckedException(1073947393L);
        }
        String[] props = new String[]{"runtime"};
        ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
        try {
            VmwareConnection tempConn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            for (int i = 0; i < 20; ++i) {
                VimPortType vimPort = tempConn.getVimPort();
                VirtualMachineRuntimeInfo runtime = (VirtualMachineRuntimeInfo)GetMoPropsValueUtils.getInstance().entityProps(tempConn, vmMor, props).get("runtime");
                if (!VerifyUtil.isEmpty((Object)runtime) && !VerifyUtil.isEmpty((Object)runtime.getQuestion())) {
                    VirtualMachineQuestionInfo quest = runtime.getQuestion();
                    vimPort.answerVM(vmMor, quest.getId(), quest.getChoice().getDefaultIndex() + "");
                } else {
                    VirtualMachineToolsRunningStatus state = this.getGuestVMToolState(vcenterUuid, vmMoId);
                    if (VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING != state) {
                        Thread.sleep(6000L);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Answer vm failed ", (long)-1L, null, (Log)LOG);
        }
    }

    public boolean powerOnVmWithoutCheck(String vcenterUuid, String dcMoId, String vmMoId) {
        boolean ret = false;
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)dcMoId) || VerifyUtil.isEmpty((String)vmMoId)) {
            LOG.error((Object)"Power on vm, but parameter is empty: vcenterUuid[%s], dcMoId[%s], vmMoId[%s].", new Object[]{vcenterUuid, dcMoId, vmMoId});
            throw new LegoCheckedException(-1L);
        }
        try {
            ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            ManagedObjectReference opTask = vimPort.powerOnVMTask(vmMor, null);
            MethodFault fault = new VsphereTaskResultMonitor(conn, opTask).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)fault)) {
                ret = true;
            } else {
                this.dealPowerOnException(fault);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Power on vm failed vmMoid=%s", new Object[]{e, vmMoId});
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Power on vm failed vmMoid=" + vmMoId), (long)-1L, null, (Log)LOG);
        }
        return ret;
    }

    public void shutdownGuest(String vcenterUuid, String vmMoId) {
        ManagedObjectReference vmMor = new ManagedObjectReference();
        vmMor.setType("VirtualMachine");
        vmMor.setValue(vmMoId);
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            if (DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.NOTRUNNING.equals((Object)this.getGuestOSState(vcenterUuid, vmMor))) {
                return;
            }
            vimPort.shutdownGuest(vmMor);
        }
        catch (ToolsUnavailableFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Shut down VM " + vmMoId + " failed"), (long)1073948868L, (String[])new String[0], (Log)LOG);
        }
        catch (InvalidStateFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Shut down VM " + vmMoId + " failed"), (long)1073948881L, (String[])new String[0], (Log)LOG);
        }
        catch (RuntimeFaultFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Shut down VM " + vmMoId + " failed"), (long)1073948867L, (String[])new String[0], (Log)LOG);
        }
        catch (TaskInProgressFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Shut down VM " + vmMoId + " failed"), (long)1073948866L, (String[])new String[0], (Log)LOG);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Shut down VM " + vmMoId + " failed"), (long)1073948867L, null, (Log)LOG);
        }
    }

    public boolean isVmToolInstalled(String vcenterUuid, String vmId) {
        boolean ret = true;
        try {
            String toolState = this.getVMProperty(vcenterUuid, vmId, "guest.toolsVersionStatus2", String.class);
            if (VirtualMachineToolsVersionStatus.GUEST_TOOLS_NOT_INSTALLED.value().equals(toolState)) {
                ret = false;
            }
            LOG.debug((Object)"Vm tools status is : %s", new Object[]{toolState == null ? "" : toolState});
        }
        catch (Exception e) {
            LOG.error((Object)"IsVmToolInstalled exception: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            ret = false;
        }
        return ret;
    }

    public boolean unregisterVM(String vcenterUuid, String vmMoid) {
        boolean ret = false;
        try {
            ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoid, "VirtualMachine");
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            vimPort.unregisterVM(vmMor);
            ret = true;
        }
        catch (InvalidPowerStateFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("UnregisterVM failed: RuntimeFaultFaultMsg " + vmMoid), (long)1073948870L, (String[])new String[0], (Log)LOG);
        }
        catch (RuntimeFaultFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("UnregisterVM failed: RuntimeFaultFaultMsg " + vmMoid), (long)1073948870L, (String[])new String[0], (Log)LOG);
        }
        catch (TaskInProgressFaultMsg e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("UnregisterVM failed: TaskInProgressFaultMsg " + vmMoid), (long)1073948866L, (String[])new String[0], (Log)LOG);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("UnregisterVM failed:  " + vmMoid), (long)1073948870L, null, (Log)LOG);
        }
        return ret;
    }

    public boolean deleteVmFromDisk(String vCenterUuid, String vmMoId) {
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"DeleteVmFromDisk: vCenterUuid=%s, vmMoId=%s", new Object[]{vCenterUuid, vmMoId});
        }
        VmwareConnection vmwareConnection = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuid);
        ManagedObjectReference vmRef = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
        VimPortType vimPort = vmwareConnection.getVimPort();
        try {
            ManagedObjectReference resultTask = vimPort.destroyTask(vmRef);
            MethodFault methodFault = new VsphereTaskResultMonitor(vmwareConnection, resultTask).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)methodFault)) {
                ret = true;
            } else {
                this.dealDeleteVmException(methodFault);
            }
            LOG.debug((Object)"DestroyTask result: taskKey=%s", new Object[]{resultTask.getValue()});
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Destroy vm failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw ex;
        }
        catch (Exception e) {
            LOG.error((Object)"Destroy vm fault: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073948948L);
        }
        return ret;
    }

    private void dealDeleteVmException(MethodFault methodFault) {
        if (methodFault instanceof InvalidPowerState) {
            LOG.error((Object)"Fault: InvalidPowerState");
            throw new LegoCheckedException(1073948869L);
        }
        if (methodFault instanceof NotFound) {
            LOG.error((Object)"Fault: NotFount");
            throw new LegoCheckedException(1073948892L);
        }
        LOG.error((Object)"Fault: unknown fault: %s", new Object[]{methodFault});
        throw new LegoCheckedException(1073948948L);
    }

    public boolean renameVM(String vCenterUuid, String vmMoId, String newName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"RenameVM: vCenterUuid=%s, vmMoId=%s", new Object[]{vCenterUuid, vmMoId});
        }
        VmwareConnection connection = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuid);
        ManagedObjectReference virtualMachine = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
        VimPortType vimPort = connection.getVimPort();
        try {
            ManagedObjectReference task = vimPort.renameTask(virtualMachine, newName);
            MethodFault methodFault = new VsphereTaskResultMonitor(connection, task).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)methodFault)) {
                LOG.debug((Object)"Rename task succeed: vmMoId=%s, newName=%s", new Object[]{vmMoId, newName});
                return true;
            }
            if (methodFault instanceof DuplicateName) {
                LOG.error((Object)"Fault: DuplicateName, vmMoId=%s, newName=%s", new Object[]{vmMoId, newName});
                throw new LegoCheckedException(1073948888L);
            }
            if (methodFault instanceof InvalidName) {
                LOG.error((Object)"Fault: InvalidName, vmMoId=%s, invalidName=%s", new Object[]{vmMoId, newName});
                throw new LegoCheckedException(1073948890L);
            }
            LOG.error((Object)"Fault: %s, vmMoId=%s, invalidName=%s", new Object[]{methodFault.getClass().getName(), vmMoId, newName});
            throw new LegoCheckedException(1073948949L);
        }
        catch (Exception ex) {
            if (ex instanceof LegoCheckedException) {
                throw (LegoCheckedException)((Object)ex);
            }
            LOG.error((Object)"Rename fault: vmMoId=%s, newName=%s, ex=%s, message=%s", new Object[]{vmMoId, newName, ex.getCause(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(1073948949L);
        }
    }

    public boolean configLinuxVMIp(String vcenterUuid, String vmMoId, Map<String, VCenterNicIpInfo> adaptersMap, String hostname) {
        boolean ret = false;
        LOG.debug((Object)"Start configLinuxVMIp. vCenterUuid[%s], vmMoid[%s], hostName[%s]", new Object[]{vcenterUuid, vmMoId, hostname});
        if (VerifyUtil.isEmpty(adaptersMap) || VerifyUtil.isEmpty((String)vmMoId)) {
            LOG.error((Object)"ConfigVMIP: configMap or vmMoId is empty.");
            return ret;
        }
        try {
            ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            CustomizationSpec spec = this.constructCustomSpec(adaptersMap, hostname);
            ManagedObjectReference task = vimPort.customizeVMTask(vmMor, spec);
            MethodFault fault = new VsphereTaskResultMonitor(conn, task).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)fault)) {
                ret = true;
            } else {
                this.dealCustomVmException(fault);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"ConfigVMIp failed vmMoid=%s", new Object[]{e, vmMoId});
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Config VM IP failed:vmMoId=" + vmMoId), (long)1073948896L, null, (Log)LOG);
        }
        return ret;
    }

    private CustomizationSpec constructCustomSpec(Map<String, VCenterNicIpInfo> adaptersMap, String hostname) {
        LOG.debug((Object)"ConstructCustomSpec start");
        CustomizationSpec custom = new CustomizationSpec();
        CustomizationGlobalIPSettings gloableSetting = new CustomizationGlobalIPSettings();
        CustomizationLinuxPrep linuxPrep = new CustomizationLinuxPrep();
        linuxPrep.setDomain("");
        CustomizationLinuxOptions option = new CustomizationLinuxOptions();
        custom.setOptions((CustomizationOptions)option);
        for (Map.Entry<String, VCenterNicIpInfo> entry : adaptersMap.entrySet()) {
            String mac = entry.getKey();
            VCenterNicIpInfo cfgMap = entry.getValue();
            CustomizationAdapterMapping adapterMapping = new CustomizationAdapterMapping();
            CustomizationIPSettings ipsettings = new CustomizationIPSettings();
            this.resetIpSettings(gloableSetting, cfgMap, ipsettings);
            CustomizationIPSettingsIpV6AddressSpec ipV6Spec = new CustomizationIPSettingsIpV6AddressSpec();
            ArrayList<CustomizationIpV6Generator> generator = new ArrayList<CustomizationIpV6Generator>();
            this.setIpV6Generator(gloableSetting, cfgMap, ipV6Spec, generator);
            ipV6Spec.getIp().addAll(generator);
            ipsettings.setIpV6Spec(ipV6Spec);
            adapterMapping.setAdapter(ipsettings);
            adapterMapping.setMacAddress(mac.replaceAll("-", ":").toLowerCase(Locale.ENGLISH));
            custom.getNicSettingMap().add(adapterMapping);
            custom.setGlobalIPSettings(gloableSetting);
        }
        CustomizationFixedName fixedName = new CustomizationFixedName();
        fixedName.setName(hostname);
        linuxPrep.setHostName((CustomizationName)fixedName);
        custom.setIdentity((CustomizationIdentitySettings)linuxPrep);
        return custom;
    }

    private void setIpV6Generator(CustomizationGlobalIPSettings gloableSetting, VCenterNicIpInfo cfgMap, CustomizationIPSettingsIpV6AddressSpec ipV6Spec, List<CustomizationIpV6Generator> generator) {
        if (!cfgMap.isOpenIp6()) {
            generator.add((CustomizationIpV6Generator)new CustomizationDhcpIpV6Generator());
        } else {
            if (cfgMap.isDhcpEnabled6()) {
                generator.add((CustomizationIpV6Generator)new CustomizationDhcpIpV6Generator());
            } else {
                for (IPv6Address ipv6Info : cfgMap.getIpv6List()) {
                    CustomizationFixedIpV6 ipv6 = new CustomizationFixedIpV6();
                    ipv6.setIpAddress(ipv6Info.getAddress());
                    ipv6.setSubnetMask(Integer.parseInt(ipv6Info.getPrefix()));
                    generator.add((CustomizationIpV6Generator)ipv6);
                }
                List ipv6Gw = ipV6Spec.getGateway();
                ipv6Gw.add(cfgMap.getGateway6());
            }
            if (!cfgMap.isAutoDns6()) {
                gloableSetting.getDnsServerList().addAll(this.getDnsList(cfgMap, true));
            }
        }
    }

    private List<String> getDnsList(VCenterNicIpInfo cfgMap, boolean isIp6) {
        String alternateDns;
        ArrayList<String> dnsList = new ArrayList<String>();
        String preferredDns = isIp6 ? cfgMap.getPreferredDns6() : cfgMap.getPreferredDns();
        String string = alternateDns = isIp6 ? cfgMap.getAlternateDns6() : cfgMap.getAlternateDns();
        if (!VerifyUtil.isEmpty((String)preferredDns)) {
            dnsList.add(preferredDns);
        }
        if (!VerifyUtil.isEmpty((String)alternateDns)) {
            dnsList.add(alternateDns);
        }
        return dnsList;
    }

    private void resetIpSettings(CustomizationGlobalIPSettings gloableSetting, VCenterNicIpInfo cfgMap, CustomizationIPSettings ipsettings) {
        if (!cfgMap.isOpenIp4()) {
            ipsettings.setIp((CustomizationIpGenerator)new CustomizationDhcpIpGenerator());
        } else {
            if (cfgMap.isDhcpEnabled4()) {
                ipsettings.setIp((CustomizationIpGenerator)new CustomizationDhcpIpGenerator());
            } else {
                CustomizationFixedIp fixedIp = new CustomizationFixedIp();
                fixedIp.setIpAddress(cfgMap.getIp());
                ipsettings.setIp((CustomizationIpGenerator)fixedIp);
                ipsettings.setSubnetMask(cfgMap.getNetmask());
                ipsettings.getGateway().add(cfgMap.getGateway());
            }
            if (!cfgMap.isAutoDns4()) {
                gloableSetting.getDnsServerList().addAll(this.getDnsList(cfgMap, false));
            }
        }
    }

    public boolean configVMNetWorks(String vcenterUuid, String vmMoId, Map<String, VsNetWork> vmNetworkMap, boolean isAutoConn) {
        HashMap<String, Object> keepMacMap = new HashMap<String, Object>();
        keepMacMap.put("keepMac", false);
        return this.configVMNetWorks(vcenterUuid, vmMoId, vmNetworkMap, isAutoConn, keepMacMap);
    }

    public boolean configVMNetWorks(String vcenterUuid, String vmMoId, Map<String, VsNetWork> vmNetworkMap, boolean isAutoConn, Map<String, Object> keepMacMap) {
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)vmMoId) || VerifyUtil.isEmpty(vmNetworkMap)) {
            LOG.error((Object)"Config vm network, but parameter is empty: vcenterUuid[%s], vmMoId[%s].", new Object[]{vcenterUuid, vmMoId});
            return false;
        }
        boolean ret = false;
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            ManagedObjectReference vmMor = new ManagedObjectReference();
            vmMor.setType("VirtualMachine");
            vmMor.setValue(GetMoPropsValueUtils.getInstance().getMoid(vmMoId));
            VirtualMachineConfigSpec vmConfigSpec = new VirtualMachineConfigSpec();
            ArrayList<VirtualDeviceConfigSpec> nicSpecArray = new ArrayList<VirtualDeviceConfigSpec>();
            for (Map.Entry<String, VsNetWork> entry : vmNetworkMap.entrySet()) {
                String vmNetCardName = entry.getKey();
                VsNetWork networkInfo = entry.getValue();
                LOG.debug((Object)"Config VM NetWork:vmMoId=%s, vmNetCardName=%s, networkInfo=%s", new Object[]{vmMoId, vmNetCardName, networkInfo});
                VirtualDeviceConfigSpec nicSpec = this.createNicSpec(conn, vmNetCardName, networkInfo, vmMor, isAutoConn);
                this.setAddressTypeByKeepMacParam(vmNetCardName, nicSpec, keepMacMap);
                if (nicSpec == null) continue;
                nicSpecArray.add(nicSpec);
            }
            vmConfigSpec.getDeviceChange().addAll(nicSpecArray);
            ManagedObjectReference taskMor = conn.getVimPort().reconfigVMTask(vmMor, vmConfigSpec);
            MethodFault fault = new VsphereTaskResultMonitor(conn, taskMor).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)fault)) {
                ret = true;
            } else {
                LOG.error((Object)"Config VM NetWork failed:vmMoId=%s", new Object[]{vmMoId});
                for (LocalizableMessage item : fault.getFaultMessage()) {
                    LOG.error((Object)"Localizable Message key=%s, Msg=%s", new Object[]{item.getKey(), item.getMessage()});
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"ConfigVMNetWork failed::vmMoId=%s. %s", new Object[]{vmMoId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return ret;
    }

    private void setAddressTypeByKeepMacParam(String vmNetCardName, VirtualDeviceConfigSpec nicSpec, Map<String, Object> keepMacMap) {
        if (keepMacMap.get("keepMac") instanceof Boolean) {
            boolean isKeepMac = (Boolean)keepMacMap.get("keepMac");
            Map virtualEthernetCardMacMap = (Map)keepMacMap.get(MAC_MAP);
            if (isKeepMac && virtualEthernetCardMacMap != null && nicSpec.getDevice() instanceof VirtualEthernetCard) {
                VirtualEthernetCard virtualEthernetCard = (VirtualEthernetCard)nicSpec.getDevice();
                virtualEthernetCard.setAddressType("manual");
                virtualEthernetCard.setMacAddress((String)virtualEthernetCardMacMap.get(vmNetCardName));
            }
        }
    }

    private VirtualDeviceConfigSpec createNicSpec(VmwareConnection conn, String vmNetCardName, VsNetWork network, ManagedObjectReference vmMor, boolean isAutoConn) {
        LOG.debug((Object)"Start to create NicSpec: vmNetCardName[%s], vmMor[%s].", new Object[]{vmNetCardName, vmMor != null ? vmMor.getValue() : "unknown"});
        VirtualDeviceConfigSpec nicSpec = new VirtualDeviceConfigSpec();
        if (network != null) {
            String networkDevType;
            nicSpec.setOperation(VirtualDeviceConfigSpecOperation.EDIT);
            VirtualEthernetCard nic = new VirtualEthernetCard();
            Map<String, Object> map = GetMoPropsValueUtils.getInstance().entityProps(conn, vmMor, new String[]{"config.hardware.device"});
            if (null == map) {
                LOG.error((Object)"Create nic spec failed, map is null.");
                throw new LegoCheckedException(1073947393L);
            }
            ArrayOfVirtualDevice arrayOfVirtualDevice = (ArrayOfVirtualDevice)map.get("config.hardware.device");
            if (null == arrayOfVirtualDevice) {
                LOG.error((Object)"Create nic spec failed, arrayOfVirtualDevice is null.");
                throw new LegoCheckedException(1073947393L);
            }
            List listvd = arrayOfVirtualDevice.getVirtualDevice();
            if (null == listvd) {
                LOG.error((Object)"Create nic spec failed, listvd is null.");
                throw new LegoCheckedException(1073947393L);
            }
            for (VirtualDevice device : listvd) {
                if (!(device instanceof VirtualEthernetCard) || !vmNetCardName.equalsIgnoreCase(device.getDeviceInfo().getLabel())) continue;
                nic = (VirtualEthernetCard)device;
                break;
            }
            if ("distributePortGroup".equals(networkDevType = network.getNetworkType())) {
                VirtualEthernetCardDistributedVirtualPortBackingInfo portGroupBacking = new VirtualEthernetCardDistributedVirtualPortBackingInfo();
                DistributedVirtualSwitchPortConnection port = new DistributedVirtualSwitchPortConnection();
                port.setPortgroupKey(network.getPortGroupKey());
                port.setSwitchUuid(network.getVswitchUuid());
                portGroupBacking.setPort(port);
                nic.setBacking((VirtualDeviceBackingInfo)portGroupBacking);
            } else {
                VirtualEthernetCardNetworkBackingInfo nicBacking = new VirtualEthernetCardNetworkBackingInfo();
                nicBacking.setDeviceName(network.getName());
                nic.setBacking((VirtualDeviceBackingInfo)nicBacking);
            }
            VirtualDeviceConnectInfo connectable = new VirtualDeviceConnectInfo();
            connectable.setStartConnected(isAutoConn);
            nic.setConnectable(connectable);
            nic.setAddressType("generated");
            nicSpec.setDevice((VirtualDevice)nic);
        }
        return nicSpec;
    }

    public ManagedObjectReference registerVm(String vcenterUuid, ManagedObjectReference datacenterMor, ManagedObjectReference computeResMor, String vmxFilePath, String vmName) {
        ManagedObjectReference vmMor = null;
        try {
            LOG.debug((Object)"Start to register vm: vCenterUuid[%s], vmName[%s], vmxFilePath[%s].", new Object[]{vcenterUuid, vmName, vmxFilePath});
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            ManagedObjectReference vmFolderMor = (ManagedObjectReference)GetMoPropsValueUtils.getInstance().entityProps(conn, datacenterMor, new String[]{"vmFolder"}).get("vmFolder");
            ManagedObjectReference resPoolMor = (ManagedObjectReference)GetMoPropsValueUtils.getInstance().entityProps(conn, computeResMor, new String[]{"resourcePool"}).get("resourcePool");
            ManagedObjectReference taskMor = vimPort.registerVMTask(vmFolderMor, vmxFilePath, vmName, false, resPoolMor, null);
            long timeout = 600000L;
            MethodFault fault = new VsphereTaskResultMonitor(conn, taskMor, timeout).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)fault)) {
                String[] props = new String[]{INFO_RESULT};
                Map<String, Object> propsMap = GetMoPropsValueUtils.getInstance().entityProps(conn, taskMor, props);
                vmMor = (ManagedObjectReference)propsMap.get(INFO_RESULT);
            } else {
                this.dealRegVmException(fault);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"RegisterVm: vmName=%s", new Object[]{e, vmName});
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("RegisterVm error.vmName=" + vmName), (long)1073948887L, null, (Log)LOG);
        }
        return vmMor;
    }

    public ManagedObjectReference registerTemplate(String vcenterUuid, ManagedObjectReference datacenterMor, String hostMoId, String vmxFilePath, String vmName) {
        ManagedObjectReference vmMor = null;
        try {
            LOG.debug((Object)"Start to register template vm: vCenterUuid[%s], vmName[%s], vmxFilePath[%s].", new Object[]{vcenterUuid, vmName, vmxFilePath});
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
            ManagedObjectReference vmFolderMor = (ManagedObjectReference)util.entityProps(conn, datacenterMor, new String[]{"vmFolder"}).get("vmFolder");
            ManagedObjectReference hostMor = util.getMorByObjUuid(hostMoId, "HostSystem");
            ManagedObjectReference taskMor = vimPort.registerVMTask(vmFolderMor, vmxFilePath, vmName, true, null, hostMor);
            MethodFault fault = new VsphereTaskResultMonitor(conn, taskMor).monitorTaskResultAfterDone();
            if (VerifyUtil.isEmpty((Object)fault)) {
                String[] props = new String[]{INFO_RESULT};
                Map<String, Object> propsMap = GetMoPropsValueUtils.getInstance().entityProps(conn, taskMor, props);
                vmMor = (ManagedObjectReference)propsMap.get(INFO_RESULT);
            } else {
                this.dealRegVmException(fault);
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"RegisterVm failed:vmName=%s", new Object[]{e, vmName});
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("RegisterVm error,vmName=" + vmName), (long)1073948887L, null, (Log)LOG);
        }
        return vmMor;
    }

    public void markVmAsTemplate(String vcenterUuid, String vmMoId) {
        if (VerifyUtil.isEmpty((String)vmMoId) || VerifyUtil.isEmpty((String)vcenterUuid)) {
            LOG.error((Object)"Start to mark vm as template: vCenterUuid[%s], vmMoId[%s].", new Object[]{vcenterUuid, vmMoId});
            throw new LegoCheckedException(1073947393L);
        }
        try {
            ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            vimPort.markAsTemplate(vmMor);
        }
        catch (Exception e) {
            LOG.error((Object)"Mark vm as template failed:vmMoid=%s. %s", new Object[]{vmMoId, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw this.getLegoException(e);
        }
    }

    public DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E getGuestOSState(String vcenterUuid, ManagedObjectReference vmMor) {
        DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E guestStatus;
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((Object)vmMor)) {
            return DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.UNKNOWN;
        }
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            String guestState = (String)GetMoPropsValueUtils.getInstance().entityProps(conn, vmMor, new String[]{GUEST_STATE}).get(GUEST_STATE);
            guestStatus = VsphereEnumParse.parseGuestState(guestState);
        }
        catch (Exception e) {
            LOG.error((Object)"GetVMToolsStatus fault. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            guestStatus = DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.UNKNOWN;
        }
        return guestStatus;
    }

    public VirtualMachineToolsRunningStatus getVMToolsStatus(VsphereVirtualMachine vm) {
        if (!this.isVMValid(vm)) {
            return VirtualMachineToolsRunningStatus.GUEST_TOOLS_NOT_RUNNING;
        }
        VsphereCenter vc = (VsphereCenter)vm.getParentMo();
        return this.getGuestVMToolState(vc.getUuid(), vm.getUuid());
    }

    public VirtualMachineToolsRunningStatus getGuestVMToolState(String vcenterUuid, String id) {
        VirtualMachineToolsRunningStatus vmToolState = VirtualMachineToolsRunningStatus.GUEST_TOOLS_NOT_RUNNING;
        try {
            String toolsRunningStatus = this.getVMProperty(vcenterUuid, id, GUEST_VMTOOL_STATUS, String.class);
            vmToolState = VirtualMachineToolsRunningStatus.fromValue((String)toolsRunningStatus);
        }
        catch (Exception e) {
            LOG.error((Object)"GetVMToolsStatus fault. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return vmToolState;
    }

    public VirtualMachinePowerState getVMPowerState(VsphereVirtualMachine vm) {
        if (!this.isVMValid(vm)) {
            return null;
        }
        VsphereCenter vc = (VsphereCenter)vm.getParentMo();
        return this.getVMPowerState(vc.getUuid(), vm.getUuid());
    }

    private boolean isVMValid(VsphereVirtualMachine vm) {
        ManagedObject parent = vm.getParentMo();
        return null != parent && parent instanceof VsphereCenter;
    }

    public VirtualMachinePowerState getVMPowerState(String vcenterUuid, String uuid) {
        String powerState = "powerState";
        return this.getVMRuntimeState(vcenterUuid, uuid, "powerState", VirtualMachinePowerState.class);
    }

    public <T> T getVMRuntimeState(String vcenterUuid, String uuid, String stateName, Class<T> stateClass) {
        String stateFullName = "summary.runtime." + stateName;
        return this.getVMProperty(vcenterUuid, uuid, stateFullName, stateClass);
    }

    public <T> T getVMProperty(String vcenterUuid, String uuid, String propertyName, Class<T> propertyClass) {
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)uuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        T state = null;
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(uuid, "VirtualMachine");
            Object object = GetMoPropsValueUtils.getInstance().entityProps(conn, vmMor, new String[]{propertyName}).get(propertyName);
            if (null == object) {
                LOG.error((Object)"VmPowerState value : null,unset ");
            } else if (propertyClass.isInstance(object)) {
                LOG.debug((Object)"VmPowerState value: %s", new Object[]{object});
                state = propertyClass.cast(object);
            }
            return state;
        }
        catch (Exception e) {
            LOG.error((Object)"GetVMPowerState fault. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return state;
        }
    }

    public boolean reconfigRdmDisk(String vcenterUuid, String dcMoId, String datastoreMoId, String lunPath, String rdmFilePath, DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E diskType) {
        LOG.debug((Object)"Start to config rdm disk: vCenterUuid[%s], dcMoId[%s], dsMoId[%s], lunPath[%s], rdmFilePath[%s].", new Object[]{vcenterUuid, dcMoId, datastoreMoId, lunPath, rdmFilePath});
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)dcMoId) || VerifyUtil.isEmpty((String)datastoreMoId) || VerifyUtil.isEmpty((String)lunPath) || VerifyUtil.isEmpty((String)rdmFilePath)) {
            LOG.error((Object)"Config rdm disk failed: vCenterUuid[%s], dcMoId[%s], dsMoId[%s], lunPath[%s], rdmFilePath[%s].", new Object[]{vcenterUuid, dcMoId, datastoreMoId, lunPath, rdmFilePath});
            throw new LegoCheckedException(1073947393L);
        }
        boolean ret = false;
        try {
            LOG.debug((Object)"ReconfigRdmDisk:lunPath=%s, rdmFilePath=%s", new Object[]{lunPath, rdmFilePath});
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            ManagedObjectReference dcMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(dcMoId, "Datacenter");
            ManagedObjectReference datastoreMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(datastoreMoId, "Datastore");
            ManagedObjectReference dsBrowser = (ManagedObjectReference)GetMoPropsValueUtils.getInstance().entityProps(conn, datastoreMor, new String[]{"browser"}).get("browser");
            String slash = "/";
            int splitIndex = rdmFilePath.lastIndexOf(slash) + 1;
            String filePath = rdmFilePath.substring(0, splitIndex);
            String fullFileName = rdmFilePath.substring(splitIndex);
            int lastDotIndex = fullFileName.lastIndexOf(".");
            String fileName = fullFileName.substring(0, lastDotIndex);
            String filePostfix = fullFileName.substring(lastDotIndex + 1);
            DeviceBackedVirtualDiskSpec spec = new DeviceBackedVirtualDiskSpec();
            spec.setAdapterType(VirtualDiskAdapterType.LSI_LOGIC.value());
            String preStr = "temp_";
            String mapFileName = this.getRdmMappingFileName(diskType, fileName, filePostfix, spec);
            this.deleteFileIfExist(conn, dsBrowser, filePath, mapFileName);
            spec.setDevice(lunPath);
            String tempMapFileName = preStr + mapFileName;
            String tempCfgFileName = preStr + fullFileName;
            this.createRdmVirtualDisk(conn, dcMor, filePath, spec, tempCfgFileName);
            ret = this.renameRdmMappingFile(conn, dcMor, filePath, mapFileName, tempMapFileName);
            this.deleteFileIfExist(conn, dsBrowser, filePath, tempCfgFileName);
        }
        catch (Exception e) {
            LOG.error((Object)"ReconfigRdmDisk failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw this.getLegoException(e);
        }
        return ret;
    }

    private boolean renameRdmMappingFile(VmwareConnection conn, ManagedObjectReference dcMor, String filePath, String mapFileName, String tempMapFileName) throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg {
        VimPortType vimPort = conn.getVimPort();
        ManagedObjectReference fileMgr = conn.getServiceContent().getFileManager();
        ManagedObjectReference mvTask = vimPort.moveDatastoreFileTask(fileMgr, filePath + tempMapFileName, dcMor, filePath + mapFileName, dcMor, Boolean.valueOf(true));
        MethodFault moveFault = new VsphereTaskResultMonitor(conn, mvTask).monitorTaskResultAfterDone();
        boolean ret = VerifyUtil.isEmpty((Object)moveFault);
        this.checkRet(ret, "Move rdm file failed,from:" + filePath + tempMapFileName + " to:" + filePath + mapFileName);
        return ret;
    }

    private void createRdmVirtualDisk(VmwareConnection conn, ManagedObjectReference dcMor, String filePath, DeviceBackedVirtualDiskSpec spec, String tempCfgFileName) throws FileFaultFaultMsg, InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg {
        VimPortType vimPort = conn.getVimPort();
        ManagedObjectReference diskMgr = conn.getServiceContent().getVirtualDiskManager();
        ManagedObjectReference createTask = vimPort.createVirtualDiskTask(diskMgr, filePath + tempCfgFileName, dcMor, (VirtualDiskSpec)spec);
        MethodFault createFault = new VsphereTaskResultMonitor(conn, createTask).monitorTaskResultAfterDone();
        boolean ret = VerifyUtil.isEmpty((Object)createFault);
        this.checkRet(ret, "create virtual disk failed:" + filePath + tempCfgFileName);
    }

    private void deleteFileIfExist(VmwareConnection conn, ManagedObjectReference dsBrowser, String folderPath, String dsFileName) throws InvalidDatastoreFaultMsg, RuntimeFaultFaultMsg, FileFaultFaultMsg {
        String dsFilePath;
        List<String> filePaths;
        VimPortType vimPort = conn.getVimPort();
        HostDatastoreBrowserSearchSpec searchSpec = new HostDatastoreBrowserSearchSpec();
        String datastorePath = "[" + VsphereCommUtil.getDatastoreName(folderPath) + "]";
        String match = "*" + dsFileName;
        searchSpec.getMatchPattern().add(match);
        ManagedObjectReference searchTaskResult = vimPort.searchDatastoreSubFoldersTask(dsBrowser, datastorePath, searchSpec);
        MethodFault fault = new VsphereTaskResultMonitor(conn, searchTaskResult).monitorTaskResultAfterDone();
        if (!VerifyUtil.isEmpty((Object)fault)) {
            this.checkRet(false, "Finding file failed in datastore\uff1a" + dsFileName);
        }
        if ((filePaths = this.collectFilePaths(conn, searchTaskResult)).contains(dsFilePath = folderPath + dsFileName)) {
            LOG.info((Object)"Delete file:fileName=%s", new Object[]{dsFilePath});
            vimPort.deleteFile(dsBrowser, dsFilePath);
        }
    }

    private List<String> collectFilePaths(VmwareConnection conn, ManagedObjectReference searchTaskResult) {
        Map<String, Object> result = GetMoPropsValueUtils.getInstance().entityProps(conn, searchTaskResult, new String[]{INFO_RESULT});
        ArrayOfHostDatastoreBrowserSearchResults resultsByFolder = (ArrayOfHostDatastoreBrowserSearchResults)result.get(INFO_RESULT);
        List hostDatastoreBrowserSearchResults = resultsByFolder.getHostDatastoreBrowserSearchResults();
        ArrayList<String> results = new ArrayList<String>();
        for (HostDatastoreBrowserSearchResults datastoreBrowserSearchResult : hostDatastoreBrowserSearchResults) {
            String folderPath = datastoreBrowserSearchResult.getFolderPath();
            List matchedFiles = datastoreBrowserSearchResult.getFile();
            matchedFiles = Optional.ofNullable(matchedFiles).orElseGet(ArrayList::new);
            for (FileInfo matchedFile : matchedFiles) {
                String filePathInFolder = matchedFile.getPath();
                results.add(folderPath + filePathInFolder);
            }
        }
        return results;
    }

    private String getRdmMappingFileName(DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E diskType, String fileName, String filePostfix, DeviceBackedVirtualDiskSpec spec) {
        String mapFileName;
        if (DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.equals((Object)diskType)) {
            spec.setDiskType(VirtualDiskType.RDMP.value());
            mapFileName = fileName + "-rdmp." + filePostfix;
        } else {
            spec.setDiskType(VirtualDiskType.RDM.value());
            mapFileName = fileName + "-rdm." + filePostfix;
        }
        return mapFileName;
    }

    public boolean configMappingVmRdmDisk(String vcenterUuid, VmConfigRdmInfo vmConfigRdmInfo, String lunPath, DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E diskType, DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E operateType) {
        boolean ret;
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)lunPath)) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            ManagedObjectReference vmMor = new ManagedObjectReference();
            vmMor.setType("VirtualMachine");
            vmMor.setValue(GetMoPropsValueUtils.getInstance().getMoid(vmConfigRdmInfo.getVirtualMachine().getVmMoId()));
            VirtualDiskRawDiskMappingVer1BackingInfo info = this.getVirtualDiskRawDiskinfo(lunPath, diskType);
            VirtualDisk device = new VirtualDisk();
            device.setControllerKey(vmConfigRdmInfo.getVmVirtualDisk().getControllerKey());
            device.setUnitNumber(vmConfigRdmInfo.getVmVirtualDisk().getUnitNumber());
            VirtualDeviceConfigSpec vmConfigSpec = new VirtualDeviceConfigSpec();
            if (operateType == DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E.Add) {
                if (this.isRdmMountedOnVm(conn, vmMor, vmConfigRdmInfo.getStorageResourceWwn())) {
                    LOG.info((Object)"RDM is existed: %s", new Object[]{vmConfigRdmInfo.getRdmDiskFileName()});
                    return true;
                }
                this.setAddVmConfigSpecObject(vmConfigSpec, vmConfigRdmInfo, info, device);
            } else {
                vmConfigSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.DESTROY);
                vmConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.REMOVE);
                device.setKey(vmConfigRdmInfo.getVmVirtualDisk().getDeviceKey().intValue());
            }
            device.setBacking((VirtualDeviceBackingInfo)info);
            vmConfigSpec.setDevice((VirtualDevice)device);
            ArrayList<VirtualDeviceConfigSpec> reqList = new ArrayList<VirtualDeviceConfigSpec>();
            reqList.add(vmConfigSpec);
            VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
            virtualMachineConfigSpec.getDeviceChange().addAll(reqList);
            LOG.info((Object)"Begin to reconfigVM by unitNumber: %s", new Object[]{String.valueOf(vmConfigRdmInfo.getVmVirtualDisk().getUnitNumber())});
            ManagedObjectReference createTask = conn.getVimPort().reconfigVMTask(vmMor, virtualMachineConfigSpec);
            MethodFault createFault = new VsphereTaskResultMonitor(conn, createTask).monitorTaskResultAfterDone();
            ret = VerifyUtil.isEmpty((Object)createFault);
        }
        catch (Exception e) {
            LOG.error((Object)"ConfigMappingVmRdmDisk failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw this.getLegoException(e);
        }
        return ret;
    }

    private boolean isRdmMountedOnVm(VmwareConnection conn, ManagedObjectReference virtualMachine, String lunWwn) {
        Object object = GetMoPropsValueUtils.getInstance().entityProps(conn, virtualMachine, new String[]{"config.hardware.device"}).get("config.hardware.device");
        if (!(object instanceof ArrayOfVirtualDevice)) {
            LOG.debug((Object)"Object is not devices: %s", new Object[]{object});
            return false;
        }
        ArrayOfVirtualDevice array = (ArrayOfVirtualDevice)object;
        List virtualDevices = array.getVirtualDevice();
        if (VerifyUtil.isEmpty((Collection)virtualDevices)) {
            return false;
        }
        for (VirtualDevice dev : virtualDevices) {
            VirtualDiskRawDiskMappingVer1BackingInfo backingInfo;
            if (!(dev.getBacking() instanceof VirtualDiskRawDiskMappingVer1BackingInfo) || VerifyUtil.isEmpty((String)(backingInfo = (VirtualDiskRawDiskMappingVer1BackingInfo)dev.getBacking()).getLunUuid()) || !backingInfo.getLunUuid().contains(lunWwn)) continue;
            LOG.debug((Object)"Found existed rdm info: rdmFile=%s, vmMoId=%s", new Object[]{backingInfo.getFileName(), virtualMachine.getValue()});
            return true;
        }
        return false;
    }

    private void setAddVmConfigSpecObject(VirtualDeviceConfigSpec vmConfigSpec, VmConfigRdmInfo vmConfigRdmInfo, VirtualDiskRawDiskMappingVer1BackingInfo info, VirtualDisk device) {
        if (DrmVsphereEnumDefine.VSPHERE_RDM_SHARE_TYPE_E.MULTI_SHARE.getValue().equals(vmConfigRdmInfo.getVmVirtualDisk().getSharing())) {
            info.setSharing(vmConfigRdmInfo.getVmVirtualDisk().getSharing());
            StorageIOAllocationInfo share = new StorageIOAllocationInfo();
            SharesInfo si = new SharesInfo();
            si.setShares(1000);
            si.setLevel(SharesLevel.NORMAL);
            share.setShares(si);
            device.setStorageIOAllocation(share);
        }
        vmConfigSpec.setFileOperation(VirtualDeviceConfigSpecFileOperation.CREATE);
        vmConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
    }

    private VirtualDiskRawDiskMappingVer1BackingInfo getVirtualDiskRawDiskinfo(String lunPath, DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E diskType) {
        VirtualDiskRawDiskMappingVer1BackingInfo virtualDiskReq = new VirtualDiskRawDiskMappingVer1BackingInfo();
        if (DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.equals((Object)diskType)) {
            virtualDiskReq.setCompatibilityMode("physicalMode");
        } else {
            virtualDiskReq.setCompatibilityMode("virtualMode");
        }
        virtualDiskReq.setDeviceName(lunPath);
        virtualDiskReq.setFileName("");
        return virtualDiskReq;
    }

    public boolean checkVmShutdownResultAndWait(String moId, String vcenterUuid) {
        boolean ret = false;
        try {
            for (int i = 0; i < 50; ++i) {
                VirtualMachinePowerState status = this.getVMPowerState(vcenterUuid, moId);
                if (null != status && VirtualMachinePowerState.POWERED_OFF == status) {
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Shutdown  VM failed: thread interrupted");
            return false;
        }
        return ret;
    }

    private void checkRet(boolean ret, String errorInfo) {
        if (!ret) {
            LOG.error((Object)errorInfo);
            throw new LegoCheckedException(-1L);
        }
    }

    public ManagedObjectReference findVmByPath(String vcenterUuid, String dcMoId, String vmxPath) {
        Object[] params = new String[]{vcenterUuid, dcMoId, vmxPath};
        LOG.debug((Object)"Find vm by path: vCenterUuid[%s], dcMoId[%s], vmxPath[%s].", params);
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)dcMoId) || VerifyUtil.isEmpty((String)vmxPath)) {
            LOG.error((Object)"Find vm by path failed: vCenterUuid[%s], dcMoId[%s], vmxPath[%s].", params);
            return null;
        }
        ManagedObjectReference result = null;
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            VimPortType vimPort = conn.getVimPort();
            GetMoPropsValueUtils util = GetMoPropsValueUtils.getInstance();
            ManagedObjectReference dcMor = util.getMorByObjUuid(dcMoId, "Datacenter");
            ManagedObjectReference searchIndexMor = conn.getServiceContent().getSearchIndex();
            result = vimPort.findByDatastorePath(searchIndexMor, dcMor, vmxPath);
        }
        catch (Exception e) {
            LOG.error((Object)"FindVmByUuid failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return result;
    }

    private LegoCheckedException getLegoException(Exception e) {
        LOG.error((Object)"Operation failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        if (e instanceof FileFaultFaultMsg) {
            return new LegoCheckedException(1073948886L, (Throwable)e);
        }
        if (e instanceof InsufficientResourcesFaultFaultMsg) {
            return new LegoCheckedException(1073948880L, (Throwable)e);
        }
        if (e instanceof InvalidDatastoreFaultMsg) {
            return new LegoCheckedException(1073948891L, (Throwable)e);
        }
        if (e instanceof InvalidNameFaultMsg) {
            return new LegoCheckedException(1073948890L, (Throwable)e);
        }
        if (e instanceof NotFoundFaultMsg) {
            return new LegoCheckedException(1073948892L, (Throwable)e);
        }
        if (e instanceof OutOfBoundsFaultMsg) {
            return new LegoCheckedException(1073948894L, (Throwable)e);
        }
        if (e instanceof AlreadyExistsFaultMsg || e instanceof DuplicateNameFaultMsg) {
            return new LegoCheckedException(1073948888L, (Throwable)e);
        }
        if (e instanceof VmConfigFaultFaultMsg) {
            return new LegoCheckedException(1073948895L, (Throwable)e);
        }
        if (e instanceof InvalidStateFaultMsg) {
            return new LegoCheckedException(1073948881L, (Throwable)e);
        }
        return new LegoCheckedException(-1L);
    }

    private void dealPowerOnException(MethodFault fault) {
        throw this.getPowerOnLegoException(fault);
    }

    public LegoCheckedException getPowerOnLegoException(MethodFault fault) {
        LegoCheckedException legoException = this.dealPowerOnExceptionOne(fault);
        if (null == legoException) {
            legoException = this.dealPowerOnExceptionTwo(fault);
        }
        if (null == legoException) {
            LocalizableMessage msg = (LocalizableMessage)CommonUtil.getFirstElement((Collection)fault.getFaultMessage());
            if (null != msg) {
                LOG.error((Object)"Unknown fault: %s", new Object[]{msg.getMessage()});
            }
            legoException = new LegoCheckedException(-1L);
        }
        return legoException;
    }

    private LegoCheckedException dealPowerOnExceptionTwo(MethodFault fault) {
        if (fault instanceof NotEnoughLicenses) {
            LOG.error((Object)"PowerOn fault:NotEnoughLicenses ");
            return new LegoCheckedException(1073948882L);
        }
        if (fault instanceof NotSupported) {
            NotSupportedFaultMsg e = new NotSupportedFaultMsg(null, (NotSupported)fault);
            LOG.error((Object)"PowerOn exception ", (Throwable)e);
            return new LegoCheckedException(1073948883L, (Throwable)e);
        }
        if (fault instanceof RuntimeFault) {
            RuntimeFaultFaultMsg e = new RuntimeFaultFaultMsg(null, (RuntimeFault)fault);
            LOG.error((Object)"PowerOn exception ", (Throwable)e);
            return new LegoCheckedException(1073948884L, (Throwable)e);
        }
        if (fault instanceof TaskInProgress) {
            TaskInProgressFaultMsg e = new TaskInProgressFaultMsg(null, (TaskInProgress)fault);
            LOG.error((Object)"PowerOn exception ", (Throwable)e);
            return new LegoCheckedException(1073948866L, (Throwable)e);
        }
        if (fault instanceof VmConfigFault) {
            VmConfigFaultFaultMsg e = new VmConfigFaultFaultMsg(null, (VmConfigFault)fault);
            LOG.error((Object)"PowerOn exception ", (Throwable)e);
            return new LegoCheckedException(1073948885L, (Throwable)e);
        }
        return null;
    }

    private LegoCheckedException dealPowerOnExceptionOne(MethodFault fault) {
        Throwable e;
        if (fault instanceof DisallowedOperationOnFailoverHost) {
            LOG.error((Object)"PowerOn exception: %s", new Object[]{fault.getFaultCause().getLocalizedMessage()});
            return new LegoCheckedException(-1L);
        }
        if (fault instanceof FileFault) {
            FileFaultFaultMsg e2 = new FileFaultFaultMsg(null, (FileFault)fault);
            LOG.error((Object)"PowerOn exception ", (Throwable)e2);
            return new LegoCheckedException(1073948886L, (Throwable)e2);
        }
        if (fault instanceof InsufficientResourcesFault) {
            InsufficientResourcesFaultFaultMsg e3 = new InsufficientResourcesFaultFaultMsg(null, (InsufficientResourcesFault)fault);
            LOG.error((Object)"PowerOn exception ", (Throwable)e3);
            return new LegoCheckedException(1073948880L, (Throwable)e3);
        }
        if (fault instanceof InvalidPowerState) {
            e = new InvalidPowerStateFaultMsg(null, (InvalidPowerState)fault);
            LOG.error((Object)"PowerOn exception ", e);
        }
        if (fault instanceof InvalidState) {
            e = new InvalidStateFaultMsg(null, (InvalidState)fault);
            LOG.error((Object)"PowerOn exception ", e);
            return new LegoCheckedException(1073948881L, e);
        }
        return null;
    }

    private void dealCustomVmException(MethodFault fault) {
        if (fault instanceof CustomizationFault) {
            CustomizationFaultFaultMsg e = new CustomizationFaultFaultMsg(null, (CustomizationFault)fault);
            LOG.error((Object)"Config VM IP failed", (Throwable)e);
            throw new LegoCheckedException(1073948896L, (Throwable)e);
        }
        if (fault instanceof InvalidPowerState) {
            InvalidPowerStateFaultMsg e = new InvalidPowerStateFaultMsg(null, (InvalidPowerState)fault);
            LOG.error((Object)"Config VM IP failed", (Throwable)e);
            throw new LegoCheckedException(1073948869L, (Throwable)e);
        }
        if (fault instanceof InvalidState) {
            InvalidStateFaultMsg e = new InvalidStateFaultMsg(null, (InvalidState)fault);
            LOG.error((Object)"Config VM IP failed", (Throwable)e);
            throw new LegoCheckedException(1073948881L, (Throwable)e);
        }
        if (fault instanceof TaskInProgress) {
            TaskInProgressFaultMsg e = new TaskInProgressFaultMsg(null, (TaskInProgress)fault);
            LOG.error((Object)"Config VM IP failed", (Throwable)e);
            throw new LegoCheckedException(1073948866L, (Throwable)e);
        }
        LOG.error((Object)"Config VM IP failed: %s", new Object[]{fault.getFaultCause().getLocalizedMessage()});
        throw new LegoCheckedException(1073948896L);
    }

    private void dealRegVmException(MethodFault fault) {
        if (fault instanceof AlreadyExists) {
            AlreadyExistsFaultMsg e = new AlreadyExistsFaultMsg(null, (AlreadyExists)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948888L, (Throwable)e);
        }
        if (fault instanceof DuplicateName) {
            DuplicateNameFaultMsg e = new DuplicateNameFaultMsg(null, (DuplicateName)fault);
            LOG.error((Object)"register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948888L, (Throwable)e);
        }
        if (fault instanceof FileFault) {
            FileFaultFaultMsg e = new FileFaultFaultMsg(null, (FileFault)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948886L, (Throwable)e);
        }
        if (fault instanceof InsufficientResourcesFault) {
            InsufficientResourcesFaultFaultMsg e = new InsufficientResourcesFaultFaultMsg(null, (InsufficientResourcesFault)fault);
            LOG.error((Object)"register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948880L, (Throwable)e);
        }
        if (fault instanceof InvalidArgument) {
            InvalidArgumentFaultMsg e = new InvalidArgumentFaultMsg(null, (InvalidArgument)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948889L, (Throwable)e);
        }
        this.dealRegVmException2(fault);
    }

    private void dealRegVmException2(MethodFault fault) {
        if (fault instanceof InvalidDatastore) {
            InvalidDatastoreFaultMsg e = new InvalidDatastoreFaultMsg(null, (InvalidDatastore)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948891L, (Throwable)e);
        }
        if (fault instanceof InvalidName) {
            InvalidNameFaultMsg e = new InvalidNameFaultMsg(null, (InvalidName)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948890L, (Throwable)e);
        }
        if (fault instanceof InvalidState) {
            InvalidStateFaultMsg e = new InvalidStateFaultMsg(null, (InvalidState)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948877L, (Throwable)e);
        }
        if (fault instanceof NotFound) {
            NotFoundFaultMsg e = new NotFoundFaultMsg(null, (NotFound)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948892L, (Throwable)e);
        }
        if (fault instanceof NotSupported) {
            NotSupportedFaultMsg e = new NotSupportedFaultMsg(null, (NotSupported)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948893L, (Throwable)e);
        }
        if (fault instanceof OutOfBounds) {
            OutOfBoundsFaultMsg e = new OutOfBoundsFaultMsg(null, (OutOfBounds)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948894L, (Throwable)e);
        }
        if (fault instanceof VmConfigFault) {
            VmConfigFaultFaultMsg e = new VmConfigFaultFaultMsg(null, (VmConfigFault)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948885L, (Throwable)e);
        }
        if (fault instanceof RuntimeFault) {
            RuntimeFaultFaultMsg e = new RuntimeFaultFaultMsg(null, (RuntimeFault)fault);
            LOG.error((Object)"Register vm failed: ", (Throwable)e);
            throw new LegoCheckedException(1073948887L, (Throwable)e);
        }
        LOG.error((Object)"Register vm failed: %s", new Object[]{fault.getFaultCause().getLocalizedMessage()});
        throw new LegoCheckedException(1073948887L);
    }
}

