/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.action;

import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereTaskResultMonitor;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.FileFault;
import com.huawei.vmware.vim25.FileFaultFaultMsg;
import com.huawei.vmware.vim25.InsufficientResourcesFault;
import com.huawei.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.huawei.vmware.vim25.InvalidState;
import com.huawei.vmware.vim25.InvalidStateFaultMsg;
import com.huawei.vmware.vim25.ManagedObjectNotFound;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;
import com.huawei.vmware.vim25.RuntimeFault;
import com.huawei.vmware.vim25.RuntimeFaultFaultMsg;
import com.huawei.vmware.vim25.TaskInProgress;
import com.huawei.vmware.vim25.TaskInProgressFaultMsg;
import com.huawei.vmware.vim25.VimPortType;
import com.huawei.vmware.vim25.VirtualMachineConnectionState;
import com.huawei.vmware.vim25.VirtualMachineSnapshotInfo;
import com.huawei.vmware.vim25.VirtualMachineSnapshotTree;
import com.huawei.vmware.vim25.VmConfigFault;
import com.huawei.vmware.vim25.VmConfigFaultFaultMsg;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;

public class VMSnapshotAction {
    private static final String SNAPSHOT = "snapshot";
    private static final String CONNECTIONSTATE = "runtime.connectionState";
    private static final String PATTERNSTRING = Normalizer.normalize("^RD_.*", Normalizer.Form.NFKC);
    private static final Pattern SNAPSHOTNAMEPATTERN = Pattern.compile(PATTERNSTRING);
    private static final String SNAPSHOTDESC = "HuaweiRD";
    private static final Log logger = LogFactory.getInstance(VMSnapshotAction.class);

    public boolean createVMSnapshot(VsphereVirtualMachine vm, String snapshotname) {
        boolean flag;
        if (!this.isVMValid(vm)) {
            return false;
        }
        VsphereCenter vc = (VsphereCenter)vm.getParentMo();
        VmwareConnection connection = this.getConnection(vc);
        ManagedObjectReference vmRef = this.getVMmoRef(vm);
        try {
            flag = this.createSnapshot(connection, vmRef, snapshotname, SNAPSHOTDESC);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("create snapshot error .vm:" + vm.getName()), 90160758786989L);
            throw e;
        }
        return flag;
    }

    public boolean deleteVMSnapshot(VsphereVirtualMachine vm, String snapshotname) {
        logger.debug((Object)("deleteVMSnapshot start:snapshot name=" + snapshotname));
        if (!this.isVMValid(vm)) {
            return true;
        }
        if (!this.findVMSnapshot(vm, snapshotname)) {
            return true;
        }
        VsphereCenter vc = (VsphereCenter)vm.getParentMo();
        VmwareConnection connection = this.getConnection(vc);
        ManagedObjectReference vmRef = this.getVMmoRef(vm);
        return this.removeSnapshot(connection, vmRef, snapshotname);
    }

    public boolean findVMSnapshot(VsphereVirtualMachine vm, String snapshotname) {
        ManagedObjectReference vmRef;
        logger.debug((Object)("findVMSnapshot start:snapshot name=" + snapshotname));
        if (!this.isVMValid(vm)) {
            return false;
        }
        VsphereCenter vc = (VsphereCenter)vm.getParentMo();
        VmwareConnection connection = this.getConnection(vc);
        ManagedObjectReference snapShotRef = this.getSnapshotReference(connection, vmRef = this.getVMmoRef(vm), snapshotname);
        return snapShotRef != null;
    }

    public VirtualMachineConnectionState getVMConnectionState(VsphereVirtualMachine vm) {
        if (!this.isVMValid(vm)) {
            return null;
        }
        VsphereCenter vc = (VsphereCenter)vm.getParentMo();
        VmwareConnection connection = this.getConnection(vc);
        try {
            ManagedObjectReference vmRef = this.getVMmoRef(vm);
            VirtualMachineConnectionState vmConnectionState = (VirtualMachineConnectionState)GetMoPropsValueUtils.getInstance().entityProps(connection, vmRef, new String[]{CONNECTIONSTATE}).get(CONNECTIONSTATE);
            if (null == vmConnectionState) {
                logger.error((Object)"vmPowerState value : null,unset ", 90160758786989L);
            }
            return vmConnectionState;
        }
        catch (Exception e) {
            logger.error((Object)("getVMToolsStatus fault." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return null;
        }
    }

    public boolean removeAllRdSnapshotReferenceOfVM(String vcenterUuid, ManagedObjectReference vmRef) {
        logger.debug((Object)("removeAllRdSnapshotReferenceOfVM start:vm moid=" + vmRef.getValue()));
        VmwareConnection connection = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        Set<ManagedObjectReference> allSnapShots = this.getAllRdSnapshotReferenceOfVM(vcenterUuid, vmRef);
        boolean flag = true;
        for (ManagedObjectReference snapShot : allSnapShots) {
            flag = flag && this.removeSnapshot(connection, snapShot);
        }
        return flag;
    }

    public Set<ManagedObjectReference> getAllRdSnapshotReferenceOfVM(String vcenterUuid, ManagedObjectReference vmRef) {
        logger.debug((Object)("getAllRdSnapshotReferenceOfVM start:vm moid=" + vmRef.getValue()));
        HashSet<ManagedObjectReference> allRdSnapshot = new HashSet<ManagedObjectReference>();
        allRdSnapshot.addAll(this.getAllRdSnapshotReferenceInfos(vcenterUuid, vmRef).keySet());
        return allRdSnapshot;
    }

    public ManagedObjectReference getRdSnapshotReferenceOfVM(String vcenterUuid, ManagedObjectReference vmRef) {
        ManagedObjectReference snapmor = null;
        Map<ManagedObjectReference, XMLGregorianCalendar> allRDSnapShotInfos = this.getAllRdSnapshotReferenceInfos(vcenterUuid, vmRef);
        if (allRDSnapShotInfos.isEmpty()) {
            logger.debug((Object)("There are snapshots in VM,But no Snapshot pattern :" + SNAPSHOTNAMEPATTERN), 90160758786989L);
        } else {
            snapmor = this.getLatestRDSnapShot(allRDSnapShotInfos);
        }
        return snapmor;
    }

    private ManagedObjectReference getLatestRDSnapShot(Map<ManagedObjectReference, XMLGregorianCalendar> allRDSnapShots) {
        logger.debug((Object)"getLatestRDSnapShot start");
        Map.Entry<ManagedObjectReference, XMLGregorianCalendar> lastestSnapShot = null;
        for (Map.Entry<ManagedObjectReference, XMLGregorianCalendar> snapShot : allRDSnapShots.entrySet()) {
            if (lastestSnapShot == null) {
                lastestSnapShot = snapShot;
                continue;
            }
            if (!snapShot.getValue().toGregorianCalendar().after(lastestSnapShot.getValue().toGregorianCalendar())) continue;
            lastestSnapShot = snapShot;
        }
        ManagedObjectReference result = null;
        if (null != lastestSnapShot) {
            result = (ManagedObjectReference)lastestSnapShot.getKey();
        }
        return result;
    }

    private void traverseSnapshotInTreeByRegular(List<VirtualMachineSnapshotTree> snapTree, Pattern findNameRegular, Map<ManagedObjectReference, XMLGregorianCalendar> allRDSnapShots) {
        if (snapTree == null || snapTree.isEmpty()) {
            logger.debug((Object)"traverseSnapshotInTreeByRegular end");
            return;
        }
        for (VirtualMachineSnapshotTree node : snapTree) {
            String nodeName = Normalizer.normalize(node.getName(), Normalizer.Form.NFKC);
            if (findNameRegular != null && findNameRegular.matcher(nodeName).matches() && node.getDescription().equals(SNAPSHOTDESC)) {
                allRDSnapShots.put(node.getSnapshot(), node.getCreateTime());
            }
            List childTree = node.getChildSnapshotList();
            this.traverseSnapshotInTreeByRegular(childTree, findNameRegular, allRDSnapShots);
        }
    }

    private ManagedObjectReference getSnapshotReference(VmwareConnection connection, ManagedObjectReference vmmor, String snapName) {
        VirtualMachineSnapshotInfo snapInfo;
        try {
            snapInfo = (VirtualMachineSnapshotInfo)GetMoPropsValueUtils.getInstance().entityProps(connection, vmmor, new String[]{SNAPSHOT}).get(SNAPSHOT);
        }
        catch (Exception e) {
            logger.error((Object)("getSnapshotReference fault." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return null;
        }
        if (snapInfo == null) {
            logger.error((Object)("No Snapshots found for VirtualMachine in serach snap:" + snapName), 90160758786989L);
            return null;
        }
        List listvmst = snapInfo.getRootSnapshotList();
        ManagedObjectReference snapmor = this.traverseSnapshotInTree(listvmst, snapName, false);
        if (null == snapmor) {
            logger.error((Object)("No Snapshot named :" + snapName), 90160758786989L);
        }
        return snapmor;
    }

    private boolean isVMValid(VsphereVirtualMachine vm) {
        logger.debug((Object)"isVMValid start");
        ManagedObject parent = vm.getParentMo();
        return parent instanceof VsphereCenter;
    }

    private VmwareConnection getConnection(VsphereCenter vc) {
        return VmwareConnectionManager.getInstance().getVmwareConnection(vc.getUuid());
    }

    private boolean createSnapshot(VmwareConnection connection, ManagedObjectReference vmMor, String snapshotname, String description) {
        try {
            ManagedObjectReference taskMor = connection.getVimPort().createSnapshotTask(vmMor, snapshotname, description, false, true);
            MethodFault fault = new VsphereTaskResultMonitor(connection, taskMor).monitorTaskResultAfterDone();
            if (null == fault) {
                logger.debug((Object)(" Creating Snapshot:" + snapshotname + " Successful"), 90160758786989L);
                return true;
            }
            logger.error((Object)(" Creating Snapshot:" + snapshotname + " Failure"), 90160758786989L);
            return false;
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947433L) {
                logger.error((Object)("getTaskResultAfterDone fault.snapshotname=" + snapshotname), (Throwable)e, 90160758786989L);
                throw e;
            }
            logger.error((Object)("createSnapshot fault.snapshotName=" + snapshotname), (Throwable)e, 90160758786989L);
        }
        catch (Exception e) {
            logger.error((Object)("createSnapshot fault.snapshotname=" + snapshotname + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return false;
    }

    private boolean removeSnapshot(VmwareConnection connection, ManagedObjectReference vmMor, String snapshotname) {
        logger.debug((Object)("removeSnapshot start:snapshot name=" + snapshotname));
        ManagedObjectReference snapmor = this.getSnapshotReference(connection, vmMor, snapshotname);
        return this.removeSnapshot(connection, snapmor);
    }

    private boolean removeSnapshot(VmwareConnection connection, ManagedObjectReference snapmor) {
        if (snapmor == null) {
            logger.debug((Object)"Snapshot not found");
            return true;
        }
        try {
            ManagedObjectReference taskMor = connection.getVimPort().removeSnapshotTask(snapmor, false, Boolean.valueOf(true));
            if (taskMor != null) {
                MethodFault fault = new VsphereTaskResultMonitor(connection, taskMor).monitorTaskResultAfterDone();
                if (null == fault || fault instanceof ManagedObjectNotFound) {
                    logger.debug((Object)("Removing Snapshot" + snapmor.getValue() + "Successful "), 90160758786989L);
                    return true;
                }
                logger.error((Object)("Removing Snapshot" + snapmor.getValue() + "Failure "), 90160758786989L);
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)("removeSnapshot fault." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return false;
    }

    private ManagedObjectReference traverseSnapshotInTree(List<VirtualMachineSnapshotTree> snapTree, String findName, boolean print) {
        if (snapTree == null || snapTree.isEmpty()) {
            return null;
        }
        ManagedObjectReference snapmor = null;
        for (VirtualMachineSnapshotTree node : snapTree) {
            if (print) {
                logger.debug((Object)("Snapshot Name : " + node.getName()), 90160758786988L);
            }
            if (findName != null && node.getName().equalsIgnoreCase(findName)) {
                return node.getSnapshot();
            }
            List childTree = node.getChildSnapshotList();
            snapmor = this.traverseSnapshotInTree(childTree, findName, print);
        }
        return snapmor;
    }

    private ManagedObjectReference getVMmoRef(VsphereVirtualMachine vm) {
        String id;
        logger.debug((Object)"getVMmoRef start");
        String uuid = vm.getUuid();
        if (!VerifyUtil.isEmpty((String)uuid) && uuid.contains(":") && !VerifyUtil.isEmpty((String)(id = uuid.split(":")[1].trim()))) {
            ManagedObjectReference moRef = new ManagedObjectReference();
            moRef.setType("VirtualMachine");
            moRef.setValue(id);
            return moRef;
        }
        return null;
    }

    public boolean revertToSnapshot(String vcenterUuid, String vmMoId) {
        boolean ret = false;
        try {
            VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
            VimPortType vimPort = conn.getVimPort();
            ManagedObjectReference snapshotMor = this.getRdSnapshotReferenceOfVM(vcenterUuid, vmMor);
            if (VerifyUtil.isEmpty((Object)snapshotMor)) {
                logger.debug((Object)("current vm:" + vmMoId + "has no snapshots"), 90160758786989L);
                return ret;
            }
            logger.debug((Object)"start to revert vmware snapshot.vmMoId:[%s], snapshot:[%s]", new Object[]{vmMoId, snapshotMor.getValue()});
            ManagedObjectReference task = vimPort.revertToSnapshotTask(snapshotMor, null, Boolean.valueOf(false));
            MethodFault fault = new VsphereTaskResultMonitor(conn, task).monitorTaskResultAfterDone();
            if (null == fault) {
                ret = true;
            } else {
                this.dealRevertSnapshotException(fault);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"revertToSnapshot: FileFaultFaultMsg ", (Throwable)e, 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"revertToSnapshot: FileFaultFaultMsg", (long)-1L, null, (Log)logger);
        }
        return ret;
    }

    private void dealRevertSnapshotException(MethodFault fault) {
        if (fault instanceof FileFault) {
            FileFaultFaultMsg e = new FileFaultFaultMsg(null, (FileFault)fault);
            logger.error((Object)"powseron exception ", (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948886L);
        }
        if (fault instanceof InsufficientResourcesFault) {
            InsufficientResourcesFaultFaultMsg e = new InsufficientResourcesFaultFaultMsg(null, (InsufficientResourcesFault)fault);
            logger.error((Object)"powseron exception ", (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948880L);
        }
        if (fault instanceof InvalidState) {
            InvalidStateFaultMsg e = new InvalidStateFaultMsg(null, (InvalidState)fault);
            logger.error((Object)"powseron exception ", (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948881L);
        }
        if (fault instanceof RuntimeFault) {
            RuntimeFaultFaultMsg e = new RuntimeFaultFaultMsg(null, (RuntimeFault)fault);
            logger.error((Object)"powseron exception ", (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948884L);
        }
        if (fault instanceof TaskInProgress) {
            TaskInProgressFaultMsg e = new TaskInProgressFaultMsg(null, (TaskInProgress)fault);
            logger.error((Object)"powseron exception ", (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948866L);
        }
        if (fault instanceof VmConfigFault) {
            VmConfigFaultFaultMsg e = new VmConfigFaultFaultMsg(null, (VmConfigFault)fault);
            logger.error((Object)"powseron exception ", (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073948885L);
        }
    }

    private Map<ManagedObjectReference, XMLGregorianCalendar> getAllRdSnapshotReferenceInfos(String vcenterUuid, ManagedObjectReference vmRef) {
        HashMap<ManagedObjectReference, XMLGregorianCalendar> allRDSnapShots = new HashMap<ManagedObjectReference, XMLGregorianCalendar>();
        VirtualMachineSnapshotInfo snapInfo = null;
        try {
            VmwareConnection connection = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
            snapInfo = (VirtualMachineSnapshotInfo)GetMoPropsValueUtils.getInstance().entityProps(connection, vmRef, new String[]{SNAPSHOT}).get(SNAPSHOT);
        }
        catch (Exception e) {
            logger.error((Object)("getSnapshotReference fault." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return allRDSnapShots;
        }
        if (null == snapInfo) {
            logger.debug((Object)("No Snapshots found for VirtualMachine in serach snap:" + SNAPSHOTNAMEPATTERN), 90160758786989L);
            return allRDSnapShots;
        }
        List listvmst = snapInfo.getRootSnapshotList();
        this.traverseSnapshotInTreeByRegular(listvmst, SNAPSHOTNAMEPATTERN, allRDSnapShots);
        return allRDSnapShots;
    }
}

