/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.adapter.service.impl;

import com.google.common.collect.ImmutableList;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.provider.AbstractProtectObjectProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.virtualization.proxy.VirtualMachineAdapterProxy;
import com.huawei.ism.drm.virtualization.sdk.model.DataStoreInfo;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.service.IDataStoreGroupDelegate;
import com.huawei.ism.drm.virtualization.sdk.service.IVirtualMachineManager;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.ism.drm.virtualization.service.impl.VirtualizationServiceHelper;
import com.huawei.ism.drm.virtualization.util.ProtectionToolsUtil;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.tools.VsVMObjectHelper;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

public class VsphereVMProvider
extends AbstractProtectObjectProvider {
    private static final Log logger = LogFactory.getInstance(VsphereVMProvider.class);
    private static final List<Integer> REPLICATION_TYPE_LIST = Arrays.asList(1, 0, 18, 20, 23, 24, 26, 27);
    private static final List<Integer> SUPPORT_4DC_POLICIES = Arrays.asList(35, 36, 58, 59);
    private static final List<Integer> SUPPORT_HYPER_VAULT_POLICIES = ImmutableList.of((Object)30, (Object)31, (Object)32, (Object)43);

    public List<ProtectObject> getSupportProtectObjectTypes() {
        logger.debug((Object)"getSupportProtectObjectTypes start");
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        ProtectObject po = new ProtectObject();
        po.setPoType(10);
        po.setName("VSPHERE_VM");
        poList.add(po);
        return poList;
    }

    public int getProviderByType() {
        return 10;
    }

    public void buildProtectObjects(ProtectGroup protectGroup) {
        ProtectionToolsUtil.getInstance().checkBuildProtectObjectsParam(protectGroup);
        this.checkDsg(protectGroup);
        List<VsphereVirtualMachine> vms = this.getVmInfos(protectGroup);
        for (ProtectObject po : protectGroup.getPolist()) {
            po.setProtectGroup(protectGroup);
            VsVMObjectHelper.getInstance().generateVmBaseInfo(vms, po);
            if (!VerifyUtil.isEmpty((String)po.getUuid())) continue;
            po.setUuid(UUIDGenerator.getUUID());
        }
        ArrayList<ProtectObject> poList = new ArrayList<ProtectObject>();
        poList.addAll(protectGroup.getPolist());
        this.loadProtectObjectStorageInfo(poList);
        try {
            VsVMObjectHelper.getInstance().getComputeResourceInfo(vms, protectGroup);
        }
        catch (Exception e) {
            logger.error((Object)("save pg topo info failed." + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
        }
        IVirtualMachineManager machineManager = VirtualMachineAdapterProxy.getInstance().getAppManager(this.getProviderByType());
        machineManager.updateProtectObjectRdmInfo(protectGroup);
        poList.clear();
    }

    private List<VsphereVirtualMachine> getVmInfos(ProtectGroup protectGroup) {
        Object[] uuids = new String[protectGroup.getPolist().size()];
        int index = 0;
        for (ProtectObject po : protectGroup.getPolist()) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                logger.error((Object)"uuid is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            uuids[index++] = po.getMoUuid();
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)uuids, 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        qcList.add(new QueryCondition("topMoUuid", (Object)protectGroup.getPoProviderSN(), 1));
        List vms = CommonDAOLocator.getMoDao().findMoBy(VsphereVirtualMachine.class, qcList);
        if (VerifyUtil.isEmpty((Collection)vms)) {
            logger.error((Object)("VsphereVirtualMachine is empty: " + StringUtil.arrayToString((Object[])uuids)), 90160758787071L);
            throw new LegoCheckedException(1073948206L);
        }
        if (uuids.length != vms.size()) {
            logger.error((Object)("some vsphereVirtualMachine is not existed: " + StringUtil.arrayToString((Object[])uuids)), 90160758787071L);
            throw new LegoCheckedException(1073948206L);
        }
        return vms;
    }

    private void checkDsg(ProtectGroup protectGroup) {
        logger.debug((Object)"checkDsg start");
        String dsgId = (String)protectGroup.getProps().get("dsgId");
        String uuid = protectGroup.getTemplate().getUuid();
        PolicyTemplate policyTemplate = ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getPtByUuid(uuid);
        protectGroup.getTemplate().setType(policyTemplate.getType());
        int protectType = VirtualizationServiceHelper.getInstance().getProtectTypeByTemplateType(policyTemplate.getType());
        if (!VerifyUtil.isEmpty((String)dsgId)) {
            ((IDataStoreGroupDelegate)ServiceLocator.getInstance().getService(IDataStoreGroupDelegate.class)).checkDataStoreGroup(dsgId, protectType, protectGroup);
            ((IDataStoreGroupDelegate)ServiceLocator.getInstance().getService(IDataStoreGroupDelegate.class)).setDataStoreInfoForProtectGroup(protectType, dsgId, protectGroup);
        }
    }

    public void refreshProtectObjectProperties(List<ProtectObject> protectObjectList) {
        logger.debug((Object)"refreshProtectObjectProperties start");
        if (VerifyUtil.isEmpty(protectObjectList)) {
            return;
        }
        String vCenterName = "--";
        ManagedObject mo = CommonDAOLocator.getMoDao().getMoByUuid(protectObjectList.get(0).getProviderSN(), Boolean.valueOf(true));
        if (null != mo) {
            vCenterName = mo.getName();
        }
        for (int i = 0; i < protectObjectList.size(); ++i) {
            ProtectObject po = protectObjectList.get(i);
            po.setProviderName(vCenterName);
            po.getProps().remove("PO_OS_NAMEPASSWORD");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProtectObjectStorageInfo> getProtectObjectStorageInfo(ProtectObject po) {
        String datastores;
        String hql;
        ArrayList<ProtectObjectStorageInfo> result = new ArrayList<ProtectObjectStorageInfo>();
        if (null == po || VerifyUtil.isEmpty((String)po.getMoUuid())) {
            return result;
        }
        String providerSn = this.getvCenterSnByVmUuid(po.getMoUuid());
        if (VerifyUtil.isEmpty((String)providerSn)) {
            logger.warn((Object)"providerSn is empty.", 90160758787071L);
            return result;
        }
        po.getUsedStorageResourceSet().clear();
        Session session = null;
        List vmDatastores = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            hql = "select vds from VmDataStore as vds where vds.id.vmUuid in (:uuid)";
            vmDatastores = session.createQuery(hql).setParameter("uuid", (Object)po.getMoUuid()).list();
        }
        catch (Exception e) {
            ArrayList<ProtectObjectStorageInfo> arrayList;
            try {
                logger.error((Object)("query datastore error.vm is " + po.getMoUuid() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                arrayList = new ArrayList<ProtectObjectStorageInfo>();
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return arrayList;
        }
        DBOperationUtil.closeSession((Session)session);
        hql = "from VsphereDataStoreDiskInfo where topMoUuid = ?";
        List dataStoreDisks = CommonDAOLocator.getMoDao().find(hql, new Object[]{providerSn});
        hql = "from VsphereDataStore where topMoUuid = ?";
        List dataStores = CommonDAOLocator.getMoDao().find(hql, new Object[]{providerSn});
        if (VerifyUtil.isEmpty((Collection)vmDatastores)) {
            return new ArrayList<ProtectObjectStorageInfo>();
        }
        boolean needCheckDs = false;
        HashSet<Object> dataStoreSet = new HashSet<DataStoreInfo>();
        ProtectGroup pg = po.getProtectGroup();
        if (null != pg && !VerifyUtil.isEmpty((String)(datastores = (String)pg.getProps().get("pgDsInfo")))) {
            JSONArray jsonArray = JSONArray.fromObject((Object)datastores);
            dataStoreSet = new HashSet(JSONArray.toCollection((JSONArray)jsonArray, DataStoreInfo.class));
            needCheckDs = true;
        }
        VsVMObjectHelper.getInstance().getUsedStorageResourceByDataStores(po, dataStoreSet, vmDatastores, dataStores, dataStoreDisks, needCheckDs);
        result.addAll(po.getUsedStorageResourceSet());
        return result;
    }

    public List<ProtectObject> getAddAvailableProtectObject(String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.warn((Object)"getting Available ProtectObject is error because pgId is empty", 90160758786989L);
            return new ArrayList<ProtectObject>();
        }
        ProtectGroup pg = (ProtectGroup)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroup.class, (Serializable)((Object)pgId));
        if (null == pg) {
            logger.error((Object)("ProtectGroup(" + pgId + ") is not existed."), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        extParamInQueryParam.put("currentPgID", pgId);
        List<ProtectObject> result = this.getAvailableProtectObject(poProviderSn, extParamInQueryParam);
        return result;
    }

    public void checkProtectObjectsInProtectGroup(ProtectGroup protectGroup) {
        this.checkProtectObjectNumber(protectGroup);
    }

    public void checkPolicyProps(PolicyTemplate policyTemplate) {
        super.checkPolicyTemplate(policyTemplate);
        policyTemplate.getSchedules().stream().forEach(schedule -> schedule.checkPeriodInterval());
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList) {
        List list = ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getAllTemplate(0L);
        ArrayList<PolicyTemplate> supportList = new ArrayList<PolicyTemplate>();
        if (this.isProtectObjectUseSanAdnNas(protectObjectList)) {
            return supportList;
        }
        for (int i = 0; i < list.size(); ++i) {
            PolicyTemplate policy = (PolicyTemplate)list.get(i);
            if (this.isReplicationTemplate(policy) || this.is3DCTemplate(policy) || this.isSnapshotTemplate(policy) || this.isHighAvailableTemplate(policy)) {
                supportList.add(policy);
            } else if (policy.getType() == 17 || policy.getType() == 28) {
                supportList.add(policy);
            }
            if (!SUPPORT_4DC_POLICIES.contains(policy.getType())) continue;
            supportList.add(policy);
        }
        return supportList;
    }

    public List<PolicyTemplate> getSupportPolicyTemplate(List<ProtectObject> protectObjectList, int replicationType) {
        List list = ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).getAllTemplate(0L);
        ArrayList<PolicyTemplate> supportList = new ArrayList<PolicyTemplate>();
        if (this.isProtectObjectUseSanAdnNas(protectObjectList)) {
            return supportList;
        }
        for (int i = 0; i < list.size(); ++i) {
            this.checkAndAddPolicy(replicationType, (PolicyTemplate)list.get(i), supportList, protectObjectList);
        }
        return supportList;
    }

    private boolean isProtectObjectUseNas(List<ProtectObject> protectObjectList) {
        boolean isUseNas = false;
        for (ProtectObject po : protectObjectList) {
            for (ProtectObjectStorageInfo storage : po.getUsedStorageResourceSet()) {
                if (DrmEnumDefine.ResourceTypeE.NAS.getValue() != storage.getResourceType().intValue()) continue;
                isUseNas = true;
                break;
            }
            if (!isUseNas) continue;
            break;
        }
        return isUseNas;
    }

    private boolean isProtectObjectUseSan(List<ProtectObject> protectObjectList) {
        boolean isUseSan = false;
        for (ProtectObject po : protectObjectList) {
            for (ProtectObjectStorageInfo storage : po.getUsedStorageResourceSet()) {
                if (DrmEnumDefine.ResourceTypeE.LUN.getValue() != storage.getResourceType().intValue()) continue;
                isUseSan = true;
                break;
            }
            if (!isUseSan) continue;
            break;
        }
        return isUseSan;
    }

    private void checkAndAddPolicy(int protectType, PolicyTemplate policy, List<PolicyTemplate> supportList, List<ProtectObject> protectObjectList) {
        logger.debug((Object)"checkAndAddPolicy start");
        if (ProtectionTypeEnum.STORAGE_SNAPSHOT.getValue() == protectType) {
            if (this.isSnapshotTemplate(policy)) {
                supportList.add(policy);
            }
        } else if (ProtectionTypeEnum.STORAGE_REPLICATION.getValue() == protectType) {
            if (this.isReplicationTemplate(policy) || this.is3DCTemplate(policy) || SUPPORT_4DC_POLICIES.contains(policy.getType())) {
                supportList.add(policy);
            }
        } else if (ProtectionTypeEnum.SAN_HIGHAVAILABILITY.getValue() == protectType) {
            if (this.isHighAvailableTemplate(policy)) {
                supportList.add(policy);
            }
        } else if (this.isNasHyperVault(protectType, policy, protectObjectList)) {
            supportList.add(policy);
        } else if (this.isSanHyperVault(protectType, policy, protectObjectList)) {
            supportList.add(policy);
        }
    }

    private boolean isNasHyperVault(int protectType, PolicyTemplate policy, List<ProtectObject> protectObjectList) {
        return ProtectionTypeEnum.STORAGE_HYPERVAULT.getValue() == protectType && policy.getType() == 17 && this.isProtectObjectUseNas(protectObjectList);
    }

    private boolean isSanHyperVault(int protectType, PolicyTemplate policy, List<ProtectObject> protectObjectList) {
        return SUPPORT_HYPER_VAULT_POLICIES.contains(policy.getType()) && protectType == ProtectionTypeEnum.STORAGE_HYPERVAULT.getValue() && this.isProtectObjectUseSan(protectObjectList);
    }

    private boolean isProtectObjectUseSanAdnNas(List<ProtectObject> protectObjectList) {
        boolean isNasAndSan = false;
        boolean useNas = false;
        boolean useSan = false;
        logger.debug((Object)"isProtectObjectUseSanAdnNas start");
        for (ProtectObject po : protectObjectList) {
            for (ProtectObjectStorageInfo storage : po.getUsedStorageResourceSet()) {
                if (DrmEnumDefine.ResourceTypeE.NAS.getValue() == storage.getResourceType().intValue()) {
                    useNas = true;
                } else if (DrmEnumDefine.ResourceTypeE.LUN.getValue() == storage.getResourceType().intValue()) {
                    useSan = true;
                }
                if (!useNas || !useSan) continue;
                isNasAndSan = true;
                break;
            }
            if (!isNasAndSan) continue;
            break;
        }
        return isNasAndSan;
    }

    private boolean is3DCTemplate(PolicyTemplate policy) {
        logger.debug((Object)"is3DCTemplate start");
        return policy.getType() == 4 || policy.getType() == 3 || policy.getType() == 6 || policy.getType() == 5;
    }

    private boolean isReplicationTemplate(PolicyTemplate policy) {
        logger.debug((Object)"isReplicationTemplate start");
        return REPLICATION_TYPE_LIST.contains(policy.getType());
    }

    private boolean isSnapshotTemplate(PolicyTemplate policy) {
        logger.debug((Object)"isSnapshotTemplate start");
        return policy.getType() == 14 || policy.getType() == 2;
    }

    private boolean isHighAvailableTemplate(PolicyTemplate policy) {
        logger.debug((Object)"isHighAvailableTemplate start");
        return policy.getType() == 15 || policy.getType() == 19 || policy.getType() == 28;
    }

    public void loadProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        logger.debug((Object)"loadProtectObjectStorageInfo start");
        VsVMObjectHelper.getInstance().getProtectObjectStorageInfo(protectObjectList);
    }

    public List<ProtectObject> getAvailableProtectObject(String poProviderSn, Map<String, Object> extendCondition) {
        List<VsphereVirtualMachine> data;
        ArrayList<ProtectObject> result = new ArrayList<ProtectObject>();
        if (VerifyUtil.isEmpty((String)poProviderSn)) {
            logger.warn((Object)"getting Available ProtectObject is error because poProviderSn is empty", 90160758786989L);
            return result;
        }
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        queryConditions.add(new QueryCondition("topMoUuid", (Object)poProviderSn));
        String currentPgID = "";
        if (!VerifyUtil.isEmpty(extendCondition)) {
            currentPgID = this.generateQueryConditions(extendCondition, queryConditions, currentPgID);
        }
        if (VerifyUtil.isEmpty(data = this.getVirtualMachineByProtectType(extendCondition, queryConditions))) {
            return result;
        }
        Set<String> moUUIDs = this.getMouuidsInProtectGroup(currentPgID);
        for (int i = 0; i < data.size(); ++i) {
            VsphereVirtualMachine vm = data.get(i);
            if (moUUIDs.contains(vm.getUuid())) continue;
            ProtectObject po = new ProtectObject();
            po.setMoUuid(vm.getUuid());
            po.setName(vm.getName());
            po.setPoStatus(vm.getOsStatus().intValue());
            po.setPoType(10);
            po.setProviderSN(poProviderSn);
            po.getProps().put("VMPATH", vm.getVmPath());
            po.getProps().put("VMUUID", vm.getVmUuid());
            po.getProps().put("GUSTOS", vm.getGuestFullName());
            po.getProps().put("GUESTHOSTNAME", vm.getHostName());
            result.add(po);
        }
        this.generatePagedList(extendCondition, result);
        return result;
    }

    private String generateQueryConditions(Map<String, Object> extendCondition, List<QueryCondition> queryConditions, String currentPgID) {
        logger.debug((Object)"generateQueryConditions start");
        for (Map.Entry<String, Object> entry : extendCondition.entrySet()) {
            if (this.matchPageParamStr(entry.getKey()) || "protectType".equals(entry.getKey()) || "userId".equals(entry.getKey())) continue;
            if ("currentPgID".equals(entry.getKey())) {
                currentPgID = (String)entry.getValue();
                continue;
            }
            QueryCondition condition = new QueryCondition(entry.getKey(), entry.getValue());
            queryConditions.add(condition);
        }
        return currentPgID;
    }

    private boolean matchPageParamStr(String key) {
        logger.debug((Object)"matchPageParamStr start");
        return "pageSize".equals(key) || "pageIndex".equals(key) || "orderBy".equals(key) || "orderType".equals(key);
    }

    protected void checkProtectObjectNumber(ProtectGroup protectGroup) {
        logger.debug((Object)"checkProtectObjectNumber start");
        ProtectionToolsUtil.getInstance().checkProtectObjectNumber(protectGroup, 256);
    }

    private String getvCenterSnByVmUuid(String tempVmUuid) {
        if (VerifyUtil.isEmpty((String)tempVmUuid)) {
            logger.warn((Object)"tempVmUuid is empty.", 90160758787071L);
            return "";
        }
        VsphereVirtualMachine tempVm = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)tempVmUuid);
        if (null == tempVm || VerifyUtil.isEmpty((String)tempVm.getTopMoUuid())) {
            logger.warn((Object)"tempVm is empty.", 90160758787071L);
            return "";
        }
        String providerSn = tempVm.getTopMoUuid();
        return providerSn;
    }

    private List<VsphereVirtualMachine> getVirtualMachineByProtectType(Map<String, Object> extendCondition, List<QueryCondition> queryConditions) {
        int protectType;
        try {
            protectType = Integer.parseInt((String)extendCondition.get("protectType"));
        }
        catch (NumberFormatException e) {
            logger.error((Object)("parseInt error:" + extendCondition.get("protectType")), (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        List<Object> data = new ArrayList();
        if (ProtectionTypeEnum.VIS_HIGHAVAILABILITY.getValue() == protectType || ProtectionTypeEnum.VIS_STORAGEMIRROR.getValue() == protectType) {
            data = CommonDAOLocator.getMoDao().findMoBy(VsphereVirtualMachine.class, "name", Boolean.TRUE.booleanValue(), queryConditions);
        } else if (1 == protectType && !VerifyUtil.isEmpty((Object)extendCondition.get("groupId"))) {
            String hql = "from VirtualDataStoreGroup where groupId = ?";
            List dsgList = CommonDAOLocator.getBaseDao().find(hql, new Object[]{extendCondition.get("groupId")});
            if (!VerifyUtil.isEmpty((Collection)dsgList)) {
                Set vmUuids = ((VirtualDataStoreGroup)dsgList.get(0)).getVmUuidSet();
                data = this.getVmByDataStoreGroup(vmUuids);
            }
        } else if (4 == protectType && !VerifyUtil.isEmpty((Object)extendCondition.get("groupId"))) {
            String dsgs = (String)extendCondition.get("groupId");
            if (dsgs == null) {
                logger.error((Object)"cant get groupId from extendCondition");
                return data;
            }
            List<VirtualDataStoreGroup> dsgList = this.getDsgByDsgArray(dsgs.split(";"));
            HashSet<String> vmUuids = new HashSet<String>();
            for (VirtualDataStoreGroup dsg : dsgList) {
                if (VerifyUtil.isEmpty((Collection)dsg.getVmUuidSet())) continue;
                vmUuids.addAll(dsg.getVmUuidSet());
            }
            data = this.getVmByDataStoreGroup(vmUuids);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VirtualDataStoreGroup> getDsgByDsgArray(String[] dsgArray) {
        ArrayList<VirtualDataStoreGroup> dsgList = new ArrayList<VirtualDataStoreGroup>();
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hql = "from VirtualDataStoreGroup where groupId in (:uuids)";
            List params = DBOperationUtil.createBatchQueryParameters(Arrays.asList(dsgArray), (int)48);
            for (List param : params) {
                Query query = session.createQuery(hql);
                query.setParameterList("uuids", (Collection)param);
                List result = query.list();
                if (VerifyUtil.isEmpty((Collection)result)) continue;
                for (Object object : result) {
                    dsgList.add((VirtualDataStoreGroup)object);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("query datastoregroup error.vms is " + Arrays.toString(dsgArray) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return dsgList;
    }

    private void generatePagedList(Map<String, Object> extendCondition, List<ProtectObject> dataList) {
        if (!VerifyUtil.isEmpty(extendCondition)) {
            int i;
            Integer pageIndex = 0;
            Integer pageSize = 0;
            if (null == extendCondition.get("pageIndex")) {
                return;
            }
            try {
                pageIndex = Integer.valueOf(extendCondition.get("pageIndex").toString());
            }
            catch (NumberFormatException e) {
                logger.error((Object)"pageIndex is error", (Throwable)e, 90160758786989L);
            }
            if (null == extendCondition.get("pageSize")) {
                return;
            }
            try {
                pageSize = Integer.valueOf(extendCondition.get("pageSize").toString());
            }
            catch (NumberFormatException e) {
                logger.error((Object)"pageSize is error", (Throwable)e, 90160758786989L);
            }
            ArrayList<ProtectObject> result = new ArrayList<ProtectObject>();
            Integer startIndex = pageIndex * pageSize;
            Integer endInteger = (pageIndex + 1) * pageSize;
            if (startIndex >= dataList.size()) {
                dataList.clear();
                return;
            }
            if (endInteger > dataList.size()) {
                endInteger = dataList.size();
            }
            for (i = startIndex.intValue(); i < endInteger; ++i) {
                result.add(dataList.get(i));
            }
            dataList.clear();
            for (i = 0; i < result.size(); ++i) {
                dataList.add((ProtectObject)result.get(i));
            }
        }
    }

    private Set<String> getMouuidsInProtectGroup(String currentPgID) {
        HashSet<String> result;
        block6: {
            List pos;
            result = new HashSet<String>();
            if (VerifyUtil.isEmpty((String)currentPgID)) break block6;
            Session session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                Criteria crit = session.createCriteria(ProtectObject.class);
                crit.createAlias("protectGroup", "protectGroup").add((Criterion)Restrictions.eq((String)"protectGroup.pgId", (Object)currentPgID));
                pos = crit.list();
            }
            catch (DataAccessException e) {
                try {
                    logger.error((Object)"failed to query ProtectObject.", (Throwable)e, 90160758786896L);
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
            DBOperationUtil.closeSession((Session)session);
            if (!VerifyUtil.isEmpty((Collection)pos)) {
                for (ProtectObject po : pos) {
                    result.add(po.getMoUuid());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VsphereVirtualMachine> getVmByDataStoreGroup(Set<String> vmUuids) {
        ArrayList<VsphereVirtualMachine> vms = new ArrayList<VsphereVirtualMachine>();
        String hql = "from VsphereVirtualMachine where uuid in (:uuids)";
        Session session = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            List params = DBOperationUtil.createBatchQueryParameters(new ArrayList<String>(vmUuids), (int)48);
            for (List param : params) {
                Query query = session.createQuery(hql);
                query.setParameterList("uuids", (Collection)param);
                List result = query.list();
                if (VerifyUtil.isEmpty((Collection)result)) continue;
                for (Object object : result) {
                    vms.add((VsphereVirtualMachine)object);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Batch quering VsphereVirtualMachine by dsg'vmuuids failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return vms;
    }

    public void updateProtectObjectsProps(ProtectGroup protectGroup) {
        ProtectionToolsUtil.getInstance().checkBuildProtectObjectsParam(protectGroup);
        Object[] uuids = new String[protectGroup.getPolist().size()];
        int index = 0;
        for (ProtectObject po : protectGroup.getPolist()) {
            if (VerifyUtil.isEmpty((String)po.getMoUuid())) {
                logger.error((Object)"uuid is empty", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            uuids[index++] = po.getMoUuid();
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)uuids, 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        qcList.add(new QueryCondition("topMoUuid", (Object)protectGroup.getPoProviderSN(), 1));
        List vms = CommonDAOLocator.getMoDao().findMoBy(VsphereVirtualMachine.class, qcList);
        if (VerifyUtil.isEmpty((Collection)vms)) {
            logger.error((Object)("VsphereVirtualMachine is empty: " + StringUtil.arrayToString((Object[])uuids)), 90160758787071L);
            throw new LegoCheckedException(1073948181L);
        }
        try {
            VsVMObjectHelper.getInstance().getComputeResourceInfo(vms, protectGroup);
        }
        catch (Exception e) {
            logger.error((Object)("save pg topo info failed." + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
        }
        if (!PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType())) {
            return;
        }
        for (ProtectObject po : protectGroup.getPolist()) {
            if (VsphereCommUtil.downLoadAndParse(po, po.getProps())) continue;
            logger.error((Object)"download and parse vm file error.");
            throw new LegoCheckedException(1073948181L);
        }
    }

    public void backUpPoMetadata(ProtectObjectReplica poReplica) {
        if (null == poReplica) {
            logger.error((Object)"poReplica is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject po = poReplica.getProtectObject();
        if (null == po) {
            logger.error((Object)"po is empty");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject backupMatadata = new JSONObject();
        Set poStorageInfos = po.getUsedStorageResourceSet();
        if (null == poStorageInfos || poStorageInfos.isEmpty()) {
            return;
        }
        JSONArray poStorageInfosArr = new JSONArray();
        for (ProtectObjectStorageInfo info : poStorageInfos) {
            JSONObject infoJson = new JSONObject();
            infoJson.put((Object)"mountPoint", (Object)info.getMountPoint());
            infoJson.put((Object)"lunWWN", (Object)info.getLunWWN());
            infoJson.put((Object)"resourceProviderSN", (Object)info.getResourceProviderSN());
            infoJson.put((Object)"resourceId", (Object)info.getResourceId());
            poStorageInfosArr.add((Object)infoJson);
        }
        backupMatadata.put((Object)"poStorageInfos", (Object)poStorageInfosArr);
        poReplica.setPoMetadata(backupMatadata.toString());
    }
}

