/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.discovery.processer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.util.SiteResourceServiceProxy;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualMachineStorageInfo;
import com.huawei.ism.drm.vsphere.adapter.action.ComputeResourceAction;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.VsNetworkAction;
import com.huawei.ism.drm.vsphere.adapter.action.VsphereCenterAction;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VmDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereComputeResource;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStoreDiskInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VspherePhysicalStorageDevice;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BaseProcessor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(BaseProcessor.class);

    public void clean(AbstractContext arg0) {
        logger.debug((Object)"Clean start");
    }

    public String getName() {
        return BaseProcessor.class.getName();
    }

    public void postProcess(AbstractContext arg0) {
        logger.debug((Object)"PostProcess start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(AbstractContext context) {
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        this.checkParams(extend);
        VsphereCenter existVCenter = null;
        String action = (String)context.getAttribute("DiscoveryType");
        if (!"register".equals(action)) {
            existVCenter = (VsphereCenter)context.getAttribute("StorageDevice");
        }
        VsphereCenter vCenter = null;
        VmwareConnection conn = this.getConnection(extend);
        try {
            conn.connnect();
        }
        catch (LegoCheckedException e) {
            this.updateStatus(existVCenter);
            logger.error((Object)"connect vcenter error with LegoCheckedException.", (Throwable)e, 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            this.updateStatus(existVCenter);
            ExceptionUtil.rethrowException((Throwable)e, (String)"connect vcenter error.", (long)1073947398L, (String[])new String[]{extend.getNetworkIpAddress()}, (Log)logger);
        }
        try {
            vCenter = this.getBasicInfo(context, existVCenter, conn);
            if (null == vCenter || !VsphereCenterAction.isSupported(vCenter.getApiType()).booleanValue()) {
                logger.warn((Object)"the vcenter is not supported.", 90160758786989L);
                throw new LegoCheckedException(1073947690L);
            }
            logger.debug((Object)"begin getVSphereResourceInfo.", 90160758786989L);
            if (VerifyUtil.isEmpty((String)vCenter.getUuid())) {
                logger.error((Object)"the vcenter uuid  is empty.", 90160758786989L);
                throw new LegoCheckedException(1073947689L);
            }
            conn.setVcenterUuid(vCenter.getUuid());
            VmwareConnectionManager.getInstance().addConnection(conn);
            this.getVSphereResourceInfo(context, vCenter, conn);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"get vsphere info error.", (Throwable)e, 90160758786989L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"get vsphere info error.", (long)1073947689L, (String[])new String[0], (Log)logger);
        }
        finally {
            conn.disconnect();
        }
        context.setAttribute("cloudServerTypeObj", (Object)10);
        context.setAttribute("vCenterObj", (Object)vCenter);
        context.setAttribute("cloudServerObj", (Object)vCenter);
        context.setAttribute("PROTECTGROUP_REFRESH_TYPE", (Object)"sync");
        logger.debug((Object)"end baseProcessor.", 90160758786989L);
        return true;
    }

    private void updateStatus(VsphereCenter existVCenter) {
        if (null == existVCenter) {
            return;
        }
        try {
            existVCenter.setStatus(Integer.valueOf(-1));
            CommonDAOLocator.getMoDao().addMoAndSubMoWithoutMsg((ManagedObject)existVCenter, new HashMap());
            Istatus devStatus = GlobalDeviceStatus.getStatus((String)existVCenter.getSn(), DefaultOnlineToOfflineStatus.class);
            devStatus.doAction((ManagedObject)existVCenter, -1);
            DiscoverUtil.setMosOffline((NetworkEntity)existVCenter);
            List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVsphereCenter where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)", new Object[]{existVCenter.getSn()});
            if (!VerifyUtil.isEmpty((Collection)resources) && !resources.isEmpty()) {
                DrVsphereCenter drVcenter = (DrVsphereCenter)resources.get(0);
                drVcenter.setStatus(existVCenter.getStatus() + "");
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)drVcenter);
            }
        }
        catch (Exception e) {
            logger.error((Object)("update vsphere status error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private void getVSphereResourceInfo(AbstractContext context, VsphereCenter vCenter, VmwareConnection conn) {
        if (null != vCenter.getStatus() && 0 == vCenter.getStatus()) {
            try {
                this.getEsxHost(context, conn, vCenter);
                this.getComputeResources(conn, vCenter);
                this.getDataStore(context, vCenter);
                this.getVMs(context, conn, vCenter);
                this.getNetworks(conn, vCenter);
                this.generateVmDataStoreInfo(context);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"get vcenter resource info error.", (long)1073947689L, null, (Log)logger);
            }
        }
    }

    private void getNetworks(VmwareConnection conn, VsphereCenter vCenter) {
        logger.debug((Object)"getNetworks start");
        VsNetworkAction networkAction = new VsNetworkAction();
        List<VsNetWork> networks = networkAction.queryAllNetworks(conn);
        if (null != networks) {
            for (VsNetWork network : networks) {
                vCenter.addChildMo((ManagedObject)network);
                network.setParentMo((ManagedObject)vCenter);
            }
        }
    }

    private void getComputeResources(VmwareConnection conn, VsphereCenter vCenter) {
        logger.debug((Object)"getComputeResources start");
        ComputeResourceAction crAction = new ComputeResourceAction();
        List<VsphereComputeResource> computeResources = crAction.queryAllComputeResourceAndResourcePool(conn);
        if (null != computeResources) {
            for (VsphereComputeResource computeResource : computeResources) {
                vCenter.addChildMo((ManagedObject)computeResource);
                computeResource.setParentMo((ManagedObject)vCenter);
            }
        }
    }

    private void getDataStore(AbstractContext context, VsphereCenter vCenter) {
        logger.debug((Object)"getDataStore start");
        DataStoreAction dsAction = new DataStoreAction();
        List<VsphereDataStore> dataStores = dsAction.queryAllMountedDataStores(vCenter.getUuid());
        HashMap<String, VsphereDataStore> storageDsMap = new HashMap<String, VsphereDataStore>();
        HashMap<String, Set> dataStoreDisks = new HashMap<String, Set>();
        if (null != dataStores) {
            for (VsphereDataStore dataStore : dataStores) {
                vCenter.addChildMo((ManagedObject)dataStore);
                dataStore.setParentMo((ManagedObject)vCenter);
                dataStoreDisks.put(dataStore.getUuid(), dataStore.getChildMos());
                for (ManagedObject subMo : dataStore.getChildMos()) {
                    if (!(subMo instanceof VsphereDataStoreDiskInfo)) continue;
                    VsphereDataStoreDiskInfo storage = (VsphereDataStoreDiskInfo)subMo;
                    storageDsMap.put(storage.getStorageWwn(), dataStore);
                }
            }
        }
        context.setAttribute("storageDataStoreObj", storageDsMap);
        context.setAttribute("dataStoreDiskObj", dataStoreDisks);
    }

    private void getVMs(AbstractContext context, VmwareConnection conn, VsphereCenter vCenter) {
        logger.debug((Object)"getVMs start");
        VMAction vmAction = new VMAction();
        List<VsphereVirtualMachine> vms = vmAction.queryAllVms(conn);
        if (null != vms) {
            for (VsphereVirtualMachine vm : vms) {
                vCenter.addChildMo((ManagedObject)vm);
                vm.setParentMo((ManagedObject)vCenter);
            }
        }
        context.setAttribute("vmObj", vms);
    }

    private void generateVmDataStoreInfo(AbstractContext context) {
        logger.debug((Object)"generateVmDataStoreInfo start");
        HashSet<VmDataStore> result = new HashSet<VmDataStore>();
        List vms = (List)context.getAttribute("vmObj");
        HashMap hostDisks = (HashMap)context.getAttribute("hostDiskObj");
        HashMap dataStoreDisks = (HashMap)context.getAttribute("dataStoreDiskObj");
        for (VsphereVirtualMachine vm : vms) {
            result.addAll(this.generateVmDataStoreInfoByVM(hostDisks, dataStoreDisks, vm));
        }
        context.setAttribute("vmDataStoreObj", result);
        ArrayList<VirtualMachineStorageInfo> vmStorageList = new ArrayList<VirtualMachineStorageInfo>();
        for (VmDataStore vmDataStore : result) {
            VirtualMachineStorageInfo vmStorageInfo = new VirtualMachineStorageInfo();
            vmStorageInfo.setStorageUuid(vmDataStore.getId().getLunWwn());
            vmStorageInfo.setDataStoreUuid(vmDataStore.getDataStoreUuid());
            vmStorageInfo.setVmUuid(vmDataStore.getId().getVmUuid());
            vmStorageList.add(vmStorageInfo);
        }
        context.setAttribute("vmStorageObj", vmStorageList);
    }

    private Set<VmDataStore> generateVmDataStoreInfoByVM(Map<String, String> hostDisks, Map<String, Set<ManagedObject>> dataStoreDisks, VsphereVirtualMachine vm) {
        HashSet<VmDataStore> result = new HashSet<VmDataStore>();
        String vmUuid = vm.getUuid();
        Set disks = vm.getVirtualDisk();
        for (VmVirtualDisk disk : disks) {
            if ("VMFS".equals(disk.getStorageType())) {
                Set<ManagedObject> storages = dataStoreDisks.get(disk.getDataStoreOrLunUuid());
                if (VerifyUtil.isEmpty(storages)) continue;
                this.generateVmfsDiskInfo(result, vmUuid, storages);
                continue;
            }
            if ("physicalMode".equals(disk.getStorageType()) || "virtualMode".equals(disk.getStorageType())) {
                String wwn = hostDisks.get(disk.getDataStoreOrLunUuid());
                if (VerifyUtil.isEmpty((String)wwn)) {
                    wwn = disk.getDataStoreOrLunUuid();
                }
                VmDataStore vds = new VmDataStore(vmUuid, wwn);
                vds.setType("physicalMode".equals(disk.getStorageType()) ? DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue() : DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue());
                vds.setDataStoreUuid(disk.getContentDataStoreUuid());
                vds.setRdmDiskName(disk.getStorageFileName());
                vds.setRdmShareType(disk.getSharing());
                Set<ManagedObject> storages = dataStoreDisks.get(disk.getContentDataStoreUuid());
                if (VerifyUtil.isEmpty(storages)) continue;
                this.generateVmfsDiskInfo(result, vmUuid, storages);
                result.add(vds);
                continue;
            }
            VmDataStore vds = new VmDataStore(vmUuid, "NONE");
            vds.setType(DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.UNSUPPORTED.getValue());
            result.add(vds);
        }
        return result;
    }

    private void generateVmfsDiskInfo(Set<VmDataStore> result, String vmUuid, Set<ManagedObject> storages) {
        for (ManagedObject mo : storages) {
            if (!(mo instanceof VsphereDataStoreDiskInfo)) continue;
            VsphereDataStoreDiskInfo storage = (VsphereDataStoreDiskInfo)mo;
            VmDataStore vds = new VmDataStore(vmUuid, storage.getStorageWwn());
            vds.setType(DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VMFS.getValue());
            vds.setDataStoreUuid(mo.getParentMo().getUuid());
            result.add(vds);
        }
    }

    private void getEsxHost(AbstractContext context, VmwareConnection conn, VsphereCenter vCenter) {
        logger.debug((Object)"getEsxHost start");
        HostSystemAction hostSystemAction = new HostSystemAction();
        List<VsphereHostSystem> hosts = hostSystemAction.queryAllHosts(conn);
        HashMap<String, String> diskMap = new HashMap<String, String>();
        this.setNvme(vCenter.getUuid(), hosts);
        if (!VerifyUtil.isEmpty(hosts)) {
            for (VsphereHostSystem host : hosts) {
                vCenter.addChildMo((ManagedObject)host);
                host.setParentMo((ManagedObject)vCenter);
                for (ManagedObject mo : host.getChildMos()) {
                    if (!(mo instanceof VspherePhysicalStorageDevice)) continue;
                    VspherePhysicalStorageDevice disk = (VspherePhysicalStorageDevice)mo;
                    diskMap.put(disk.getDeviceUuid(), disk.getStorageWwn());
                }
            }
        }
        context.setAttribute("hostDiskObj", diskMap);
    }

    private void setNvme(String vCenterUuid, List<VsphereHostSystem> hosts) {
        if (VerifyUtil.isEmpty((String)vCenterUuid)) {
            return;
        }
        ManagedObject vCenter = CommonDAOLocator.getMoDao().getMoByUuid(vCenterUuid, null);
        if (VerifyUtil.isEmpty((Object)vCenter)) {
            return;
        }
        List existHosts = CommonDAOLocator.getMoDao().getAllSubMo(vCenter.getMoId().longValue(), VsphereHostSystem.class);
        block0: for (VsphereHostSystem host : hosts) {
            for (VsphereHostSystem existHost : existHosts) {
                if (!host.getUuid().equals(existHost.getUuid())) continue;
                host.setNvme(existHost.getNvme());
                continue block0;
            }
        }
    }

    private void checkParams(NeMgrProtocolExtend extend) {
        if (null == extend) {
            logger.error((Object)"extend is null.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        String ipAddress = extend.getNetworkIpAddress();
        String pwd = extend.getNetworkPassword();
        String userName = extend.getNetworkUserName();
        String port = "";
        if (null != extend.getExtendParams()) {
            port = (String)extend.getExtendParams().get("port");
        }
        if (VerifyUtil.isEmpty((String)ipAddress) || VerifyUtil.isEmpty((String)pwd) || VerifyUtil.isEmpty((String)userName) || VerifyUtil.isEmpty((String)port)) {
            logger.error((Object)"params is not validated.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private VmwareConnection getConnection(NeMgrProtocolExtend extend) {
        return new VmwareConnection(extend.getNetworkIpAddress(), Integer.valueOf((String)extend.getExtendParams().get("port")), extend.getNetworkUserName(), extend.getNetworkPassword(), "");
    }

    private VsphereCenter getBasicInfo(AbstractContext context, VsphereCenter existVCenter, VmwareConnection conn) {
        String action;
        VsphereCenterAction vsAction;
        VsphereCenter vc;
        String location = (String)context.getAttribute("Location");
        if (null != existVCenter) {
            location = existVCenter.getLocation();
        }
        if (VerifyUtil.isEmpty((Object)(vc = (vsAction = new VsphereCenterAction()).queryVsphereCenter(conn)))) {
            throw new LegoCheckedException(1073947689L);
        }
        vc.setLocation(location);
        vc.setIsTopMo(Boolean.valueOf(true));
        vc.setLinkIp(conn.getIp());
        vc.setSn(vc.getUuid());
        vc.setIpAddress(conn.getIp());
        vc.setStatus(Integer.valueOf(0));
        if (VerifyUtil.isEmpty((String)vc.getName()) && null != existVCenter) {
            vc.setName(existVCenter.getName());
        }
        if ("register".equals(action = (String)context.getAttribute("DiscoveryType"))) {
            DrResource resource = SiteResourceServiceProxy.getInstance().getSiteResourceService("ism.drm.deviceType.drvsphere.mainType").getDrResourceBySn(vc.getSn());
            if (null != resource) {
                logger.error((Object)"vcenter has bean already discovered.", 90160758786989L);
                throw new LegoCheckedException(1073947431L);
            }
        } else {
            if (null == existVCenter) {
                logger.error((Object)"vcenter is not existed.", 90160758786989L);
                throw new LegoCheckedException(1073947394L);
            }
            if (!vc.getUuid().equals(existVCenter.getUuid())) {
                logger.error((Object)"vcenter's uuid has changed.", 90160758786989L);
                this.updateStatus(existVCenter);
                throw new LegoCheckedException(1073947432L);
            }
        }
        return vc;
    }
}

