/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.protect.action;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.vsphere.protect.action.CreateVsphereVMSnapshotSubAction;
import com.huawei.ism.drm.vsphere.protect.action.ProtectVsphereVMSnapshotAction;
import com.huawei.ism.drm.vsphere.protect.action.ProtectVsphereVMSnapshotUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateVsphereVMSnapshotAction
extends ProtectVsphereVMSnapshotAction {
    private static final Log logger = LogFactory.getInstance(CreateVsphereVMSnapshotAction.class);

    public void preExcute(ActionContext context) {
        boolean flag = ProtectVsphereVMSnapshotUtils.isNeedHandleVMSnapshot(context);
        this.setEnable(flag);
        if (flag) {
            boolean ignoreFailed = ProtectVsphereVMSnapshotUtils.isContinueConsistentFail(context);
            logger.debug((Object)"Pre Execute. AppConsistent:[%s],IgnoreFailed:[%s]", new Object[]{flag, ignoreFailed});
            this.setIgnoreFailure(ignoreFailed);
        }
    }

    protected void updateSubActions(ActionContext context, List<AbstractBaseProtectAction> subActions) {
        Set<ProtectObject> pos = this.getPolist(context);
        if (VerifyUtil.isEmpty(pos)) {
            return;
        }
        Set successSet = Collections.synchronizedSet(new HashSet());
        context.getContext().put("VsphereSnapshotSuccess", successSet);
        for (ProtectObject po : pos) {
            subActions.add(new CreateVsphereVMSnapshotSubAction(po));
        }
    }

    public void postExcute(ActionContext context) {
        Set successSet = (Set)context.getContext().get("VsphereSnapshotSuccess");
        Set<String> successSetIds = successSet.stream().map(DRMObject::getUuid).collect(Collectors.toSet());
        this.handleFailedVmSnapshot(context, successSetIds);
    }

    private void handleFailedVmSnapshot(ActionContext context, Set<String> successIds) {
        ProtectGroup protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        Set allPo = protectGroup.getPolist();
        boolean ignoreFailed = ProtectVsphereVMSnapshotUtils.isContinueConsistentFail(context);
        HashSet<String> failedNames = new HashSet<String>();
        for (ProtectObject po : allPo) {
            if (VerifyUtil.isEmpty((Object)po)) {
                logger.error((Object)"pg[%s] contain null po.", new Object[]{protectGroup.getName()});
                continue;
            }
            if (successIds.contains(po.getUuid())) continue;
            failedNames.add(po.getName());
        }
        if (!VerifyUtil.isEmpty(failedNames) && ignoreFailed) {
            logger.error((Object)"contain failed vm snapshot.failed name:[%s]", new Object[]{failedNames});
            AlarmReporter.sendAlarm((long)52625507L, (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{protectGroup.getUuid(), protectGroup.getName(), ((Object)failedNames).toString()});
        } else {
            AlarmReporter.restoreAlarm((long)52625507L, (String[])new String[]{protectGroup.getUuid(), protectGroup.getName(), ((Object)failedNames).toString()});
        }
    }

    public void callBack(ActionContext context) {
        ProtectVsphereVMSnapshotUtils.callback(context);
    }
}

