/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.protect.action;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.proxy.VirtualizationApplicationOperatorProxy;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import java.util.Set;

public class CreateVsphereVMSnapshotSubAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(CreateVsphereVMSnapshotSubAction.class);
    private final ProtectObject po;

    public CreateVsphereVMSnapshotSubAction(ProtectObject po) {
        this.po = po;
    }

    public void preExcute(ActionContext context) {
        this.setNameParams(this.constructParams(new String[]{this.po.getName()}));
    }

    public boolean doExecute(ActionContext context) {
        if (ProtectObjectStatusEnum.INVALID.getValue() == this.po.getPoStatus() || ProtectObjectStatusEnum.UNSUPPORTED.getValue() == this.po.getPoStatus()) {
            logger.info((Object)("no need to create snapshot:vmName=" + this.po.getName() + " and status=" + this.po.getPoStatus()));
            this.setDetail("com.huawei.ism.drm.vsphere.protect.CreateVMSnapshotSubAction.VmNotSupport");
            return true;
        }
        VsphereVirtualMachine mo = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)this.po.getMoUuid());
        if (mo == null) {
            logger.error((Object)("find mo null,vm name :" + this.po.getName()), 90160758786989L);
            throw new LegoCheckedException(1073947394L);
        }
        try {
            return this.createSanpShot(context, mo);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create snap shot LegoCheckedException.", (Throwable)e, 90160758786989L);
            this.setDetail(e.getErrorMessageKey());
            if (e.getParameters() != null && e.getParameters().length != 0) {
                this.setDetailParams(this.constructParams(e.getParameters()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("connect vcenter error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.setDetail("lego.err.1073948096");
        }
        return false;
    }

    private boolean createSanpShot(ActionContext context, VsphereVirtualMachine mo) {
        VMAction vmAction = new VMAction();
        VirtualMachinePowerState powerState = vmAction.getVMPowerState(mo);
        if (null == powerState) {
            logger.error((Object)("vm=" + this.po.getName() + " power state is null"), 90160758786989L);
            this.setDetail("com.huawei.ism.drm.vsphere.protect.CreateVMSnapshotSubAction.VmNotSupport");
            return true;
        }
        if (VirtualMachinePowerState.POWERED_OFF == powerState) {
            logger.debug((Object)("vm(" + this.po.getName() + ") is POWERED_OFF"), 90160758786989L);
            this.setDetail("com.huawei.ism.drm.vsphere.protect.CreateVMSnapshotSubAction.VmPoweroff");
            return true;
        }
        Set successSet = (Set)context.getContext().get("VsphereSnapshotSuccess");
        if (successSet == null) {
            logger.error((Object)"VsphereSnapshotSuccess is empty.", 90160758786989L);
            throw new LegoCheckedException(1073948096L);
        }
        VirtualizationApplicationOperatorProxy.getInstance().getOperator(this.po.getPoType()).freeze(this.po);
        successSet.add(this.po);
        logger.info((Object)("Create snapshot success:vmName=" + this.po.getName()));
        return true;
    }
}

