/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.protect.action;

import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.virtualization.proxy.VirtualizationApplicationOperatorProxy;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectObjectStatusEnum;
import com.huawei.ism.drm.vsphere.protect.action.ProtectVsphereVMSnapshotUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class PrepareVsphereVMSnapshotSubAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(PrepareVsphereVMSnapshotSubAction.class);
    private final ProtectObject po;

    public PrepareVsphereVMSnapshotSubAction(ProtectObject po) {
        this.po = po;
    }

    public void preExcute(ActionContext context) {
        this.setNameParams(this.constructParams(new String[]{this.po.getName()}));
    }

    public boolean doExecute(ActionContext context) {
        if (ProtectObjectStatusEnum.INVALID.getValue() == this.po.getPoStatus() || ProtectObjectStatusEnum.UNSUPPORTED.getValue() == this.po.getPoStatus()) {
            logger.info((Object)("no need to create snapshot:vmName=" + this.po.getName() + " and status=" + this.po.getPoStatus()));
            this.setDetail("com.huawei.ism.drm.vsphere.protect.CreateVMSnapshotSubAction.VmNotSupport");
            return true;
        }
        boolean flag = ProtectVsphereVMSnapshotUtils.isNeedHandleVMSnapshot(context);
        boolean ignoreFailed = ProtectVsphereVMSnapshotUtils.isContinueConsistentFail(context);
        try {
            VirtualizationApplicationOperatorProxy.getInstance().getOperator(this.po.getPoType()).checkVmState(this.po);
            if (flag && !ignoreFailed) {
                VirtualizationApplicationOperatorProxy.getInstance().getOperator(this.po.getPoType()).checkEnvForFreeze(this.po);
            }
            logger.info((Object)"check vm state success:vmName=%s, flag=%s", new Object[]{this.po.getName(), flag});
            return true;
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            if (e.getParameters() != null && e.getParameters().length != 0) {
                this.setDetailParams(this.constructParams(e.getParameters()));
            }
            return false;
        }
    }
}

