/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.SaveChildProcessorCallback;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractVmGranularRecoveryProcessor
extends BaseRecoveryProcessor {
    protected static final String LOCAL_VM_RECOVERY_SUB_PROCESSOR_KEY = "localVmRollbackSubProcessor".toLowerCase(Locale.ROOT);
    protected static final String REMOTE_VM_RECOVERY_SUB_PROCESSOR_KEY = "remoteVmRollbackSubProcessor".toLowerCase(Locale.ROOT);
    protected static final String LOCAL_VM_RECOVERY_GRAND_CHILD_PROCESSOR_KEY = "localVmRollbackGrandChildProcessorsKey".toLowerCase(Locale.ROOT);
    protected static final String REMOTE_VM_RECOVERY_GRAND_CHILD_PROCESSOR_KEY = "remoteVmRollbackGrandChildProcessorsKey".toLowerCase(Locale.ROOT);
    protected static final String LOCAL_VM_RECOVERY_SUB_PROCESSOR_PREPARE_CLASS_KEY = "localVmRollbackSubProcessorPrepareClass".toLowerCase(Locale.ROOT);
    protected static final String REMOTE_VM_RECOVERY_SUB_PROCESSOR_PREPARE_CLASS_KEY = "remoteVmRollbackSubProcessorPrepareClass".toLowerCase(Locale.ROOT);
    private static final Log LOGGER = LogFactory.getInstance(AbstractVmGranularRecoveryProcessor.class);
    private String subProcessorClassName;
    private boolean isRemoteVmRollback;

    protected boolean execute(RecoveryProcessorContext context) {
        this.initAttribute(context);
        Set<RecoveryProcessor> subProcessors = this.createSubProcessors(context);
        if (VerifyUtil.isEmpty(subProcessors)) {
            LOGGER.error((Object)"Failed to create subProcessors.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList<RecoveryProcessor>(subProcessors));
        recoveryTemplate.process(context);
        return this.calcProcessResultBySubProc();
    }

    private void initAttribute(RecoveryProcessorContext context) {
        Map props = this.getProps();
        if (!props.containsKey(LOCAL_VM_RECOVERY_SUB_PROCESSOR_KEY) || !props.containsKey(REMOTE_VM_RECOVERY_SUB_PROCESSOR_KEY)) {
            LOGGER.error((Object)"No virtual machine recovery subProcessors configured for processor(%s).", new Object[]{((Object)((Object)this)).getClass().getName()});
            throw new LegoCheckedException(2117645L);
        }
        this.isRemoteVmRollback = (Boolean)context.getAttributeOrDefault("isRemoteVmRollback", Boolean.class, (Object)Boolean.FALSE);
        this.subProcessorClassName = this.isRemoteVmRollback ? (String)props.get(REMOTE_VM_RECOVERY_SUB_PROCESSOR_KEY) : (String)props.get(LOCAL_VM_RECOVERY_SUB_PROCESSOR_KEY);
    }

    private Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context) {
        Object processor;
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        try {
            processor = Class.forName(this.subProcessorClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.error((Object)"Failed to instantiate the subclass processor(%s). Error msg:%s", new Object[]{this.subProcessorClassName, ExceptionUtil.getErrorMessage((Throwable)e)});
            return subProcessors;
        }
        if (!(processor instanceof BaseRecoveryProcessor)) {
            LOGGER.error((Object)"Illegal sub processor Class: %s.", new Object[]{this.subProcessorClassName});
            return subProcessors;
        }
        BaseRecoveryProcessor subProcessor = (BaseRecoveryProcessor)processor;
        this.initProcessorProps((RecoveryProcessor)subProcessor);
        this.setContextRef(context);
        VerifyUtil.checkObject((Object)context.getRecoveryPlan());
        this.setPlanId(context.getRecoveryPlan().getPlanId());
        subProcessors.add((RecoveryProcessor)subProcessor);
        subProcessor.setProcType(this.getProcType());
        subProcessor.setPlanId(this.getPlanId());
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.setParentProc((RecoveryProcessor)this);
        subProcessor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        this.setChildProc(subProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return subProcessors;
    }

    private void initProcessorProps(RecoveryProcessor subProcessor) {
        String prepareClass;
        String childProcessorKey;
        Map props = this.getProps();
        Map subProcessorProps = subProcessor.getProps();
        String string = childProcessorKey = this.isRemoteVmRollback ? (String)props.get(REMOTE_VM_RECOVERY_GRAND_CHILD_PROCESSOR_KEY) : (String)props.get(LOCAL_VM_RECOVERY_GRAND_CHILD_PROCESSOR_KEY);
        if (!VerifyUtil.isEmpty((String)childProcessorKey)) {
            subProcessorProps.put(SaveChildProcessorCallback.CHILD_PROCESSOR_KEY, childProcessorKey);
        }
        String string2 = prepareClass = this.isRemoteVmRollback ? (String)props.get(REMOTE_VM_RECOVERY_SUB_PROCESSOR_PREPARE_CLASS_KEY) : (String)props.get(LOCAL_VM_RECOVERY_SUB_PROCESSOR_PREPARE_CLASS_KEY);
        if (!VerifyUtil.isEmpty((String)prepareClass)) {
            subProcessorProps.put("prepareclass", prepareClass);
        }
    }
}

