/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BeginLocalRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;

public class BeginLocalRecoveryAndCheckStatusProcessor
extends BeginLocalRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(BeginLocalRecoveryAndCheckStatusProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        int procStatus = this.getProcStatus();
        if (procStatus == DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue()) {
            return false;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (protectGroup.getTemplate().getType() == 32 && replica.getProtectLocation() == DrmEnumDefine.ProtectLocation.B_B.getValue()) {
            throw new LegoCheckedException(1073948754L);
        }
        this.checkDeviceConnectivity(context);
        return super.execute(context);
    }

    private void checkDeviceConnectivity(RecoveryProcessorContext context) {
        ProtectGroupReplica protectGroupReplica = context.getProtectGroupReplica();
        HashSet<String> deviceSnSet = new HashSet<String>();
        deviceSnSet.add(protectGroupReplica.getProductArray());
        deviceSnSet.add(protectGroupReplica.getRecoveryArray());
        for (String deviceSn : deviceSnSet) {
            RestConnection connection;
            try {
                connection = RestConnectionManager.getInstance().getConnection(deviceSn);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Connect to device(sn:%s) failed.", new Object[]{deviceSn});
                throw new LegoCheckedException(1073947649L);
            }
            if (connection != null && connection.isValid()) continue;
            LOGGER.error((Object)"Obtain connection to device(sn:%s) failed.", new Object[]{deviceSn});
            throw new LegoCheckedException(1073947649L);
        }
    }
}

