/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteReplicationProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteReplicationSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class VmRollbackDeleteReplicationProcessor
extends DeleteReplicationProcessor {
    public String getRecoveryTasksKey() {
        return "remoteRecoveryTasks";
    }

    public void resetEnableStatus(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        this.setIsEnabled(VsphereRecoveryUtils.isRemoteVmRollbackScenario(plan, execType));
    }

    public void endRecoveryProcessor() {
        RecoveryProcessorContext context = this.getContextRef();
        Object cleanModeObj = context.getAttribute("cleanModeForVm");
        if (!VerifyUtil.isEmpty((Object)cleanModeObj)) {
            this.deleteCreateReplicationSubProcessor(context);
        }
        super.endRecoveryProcessor();
    }

    private void deleteCreateReplicationSubProcessor(RecoveryProcessorContext context) {
        Set deleteReplicationIdSet = this.getChildProc().stream().filter(processor -> processor instanceof DeleteReplicationSubProcessor).map(processor -> (DeleteReplicationSubProcessor)processor).filter(processor -> processor.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()).map(processor -> processor.getSrcDevSn() + processor.getReplicationId()).collect(Collectors.toSet());
        if (VerifyUtil.isEmpty(deleteReplicationIdSet)) {
            return;
        }
        List createReplicationSubProcessorList = VmRollbackDeleteReplicationProcessor.getRecoveryPlanRecoveryProcessors((RecoveryPlan)context.getRecoveryPlan(), (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)this.getProcType()), CreateReplicationSubProcessor.class);
        Set<CreateReplicationSubProcessor> deletedSubProcessor = createReplicationSubProcessorList.stream().filter(processor -> processor instanceof CreateReplicationSubProcessor).map(processor -> (CreateReplicationSubProcessor)processor).filter(processor -> deleteReplicationIdSet.contains(processor.getSrcDevSn() + processor.getReplicationId())).collect(Collectors.toSet());
        IRecoveryProcessService processService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        deletedSubProcessor.forEach(arg_0 -> ((IRecoveryProcessService)processService).deleteRecoveryProcessor(arg_0));
    }
}

