/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.vsphere.recovery.process.VmRollbackMappingLunSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class VmRollbackMappingLunProcessor
extends BaseRecoveryProcessor {
    private static final Log LOGGER = LogFactory.getInstance(VmRollbackMappingLunProcessor.class);

    protected boolean execute(RecoveryProcessorContext context) {
        Map lunMap = (Map)context.getAttributeOrDefault("lunToBeCreated", Map.class, new HashMap());
        if (lunMap.isEmpty()) {
            LOGGER.error((Object)"No LUN needs to be mapped to the host.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        String hostOrGroupIdStr = RecoveryToolsUtil.getInstance().getDisasterHostOrHostGroupId(recoveryPlan, Integer.valueOf(this.getProcType()));
        if (VerifyUtil.isEmpty((String)hostOrGroupIdStr)) {
            LOGGER.error((Object)"HostOrGroupId is empty.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (!this.generateSubProcessor(lunMap, hostOrGroupIdStr)) {
            LOGGER.error((Object)"Create subProcessors failed.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return this.executeSubProcessor(context);
    }

    private boolean generateSubProcessor(Map<String, Lun> lunMap, String hostOrGroupIdStr) {
        HashMap<String, String> hostAndLunGroupIdMap = new HashMap<String, String>();
        String[] hostOrGroupIds = hostOrGroupIdStr.split(";");
        HashSet<VmRollbackMappingLunSubProcessor> subProcessors = new HashSet<VmRollbackMappingLunSubProcessor>();
        for (Lun lun : lunMap.values()) {
            for (String hostOrGroupId : hostOrGroupIds) {
                if (!hostAndLunGroupIdMap.containsKey(hostOrGroupId)) {
                    String lunGroupId = RecoveryToolsUtil.getInstance().getLunGroupId(hostOrGroupId, lun.getDevSn());
                    hostAndLunGroupIdMap.put(hostOrGroupId, lunGroupId);
                }
                VmRollbackMappingLunSubProcessor processor = new VmRollbackMappingLunSubProcessor();
                processor.setProcName(processor.getName());
                processor.setProcType(this.getProcType());
                processor.setPlanId(this.getPlanId());
                processor.setProcessId(this.getProcessId());
                processor.setParentProc((RecoveryProcessor)this);
                processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
                processor.setDeviceSn(lun.getDevSn());
                processor.setLunId(lun.getLunId());
                processor.setLunName(lun.getName());
                processor.setHostOrGroupId(hostOrGroupId);
                processor.setLunGroupId((String)hostAndLunGroupIdMap.get(hostOrGroupId));
                subProcessors.add(processor);
            }
        }
        this.setChildProc(subProcessors);
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }
}

