/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.replication.SplitReplicationProcessor;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VmRollbackSplitReplicationProcessor
extends SplitReplicationProcessor {
    private static final Log LOGGER = LogFactory.getInstance(VmRollbackSplitReplicationProcessor.class);

    public void resetEnableStatus(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        this.setIsEnabled(VsphereRecoveryUtils.isRemoteVmRollbackScenario(plan, execType));
    }

    public String getRecoveryTasksKey() {
        return "remoteRecoveryTasks";
    }

    protected List<ReplicationPair> queryReplicationPair(RecoveryProcessorContext context) {
        Collection recoveryTasks = context.getRecoveryTask(this.getRecoveryTasksKey());
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            LOGGER.error((Object)"No replication task was found.");
            return Collections.emptyList();
        }
        Map createdLun = (Map)context.getAttributeOrDefault("lunToBeCreated", Map.class, new HashMap());
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        ArrayList<ReplicationPair> replicationPairList = new ArrayList<ReplicationPair>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            if (!createdLun.containsKey(recoveryTask.getProtectName())) {
                LOGGER.error((Object)"The secondary LUN corresponding to the primary resource(name:%s) is not found.", new Object[]{recoveryTask.getProtectName()});
                return Collections.emptyList();
            }
            ReplicationRelation replicationRelation = recoveryService.queryReplication(recoveryTask.getSrcDeviceId(), recoveryTask.getTgtDevcieId(), recoveryTask.getProtectId(), ReplicationConstantDefine.ReplicationDescription.isConsistentGroup((int)recoveryTask.getProtectType()));
            if (!(replicationRelation instanceof ReplicationPair)) continue;
            ReplicationPair replicationPair = (ReplicationPair)replicationRelation;
            Lun standbyLun = (Lun)createdLun.get(recoveryTask.getProtectName());
            ReplicationTargetLun targetLun = new ReplicationTargetLun();
            targetLun.setTgtLunId(standbyLun.getLunId());
            targetLun.setTgtDevSN(standbyLun.getDevSn());
            replicationPair.setRepTgtLuns(Collections.singletonList(targetLun));
            replicationPairList.add(replicationPair);
        }
        return replicationPairList;
    }
}

