/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereTaskResultMonitor;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.Map;
import java.util.Set;

public class VsCfgResForVmSubProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -835944165829163563L;
    private static final Log logger = LogFactory.getInstance(VsCfgResForVmSubProcessor.class);
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmSubProcessor.";
    private static final String ALREADY_SUCC = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmSubProcessor.already.success";
    private static final String START_TIMEOUT = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgResForVmSubProcessor.starttimeout";
    private int preResult;
    private String vmxPath;
    private String vmName;
    private String vmMoId;
    private String vcenterUuid;
    private String poId;
    private boolean hasVmSnap;
    private String taskId = "";
    private long errorCode = 0L;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != this.preResult) {
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsInitVmSubProcessor.failed", new String[]{this.vmName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        if (!this.hasVmSnap || DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail(ALREADY_SUCC, new String[]{this.vmName});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        if (0L != this.errorCode) {
            this.updateProcessDetail("lego.err." + this.errorCode, null);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        VMAction action = new VMAction();
        action.answerVM(this.vcenterUuid, this.vmMoId);
        logger.info((Object)("answer vm success:vmName=" + this.vmName), 90160758786988L);
        if (!VerifyUtil.isEmpty((String)this.taskId) && !this.monitorTask()) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        boolean ret = this.rebootVm();
        if (!ret) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        }
        this.configVMNetWorks(action);
        return true;
    }

    private void configVMNetWorks(VMAction action) {
        String key = "";
        int planType = this.getProcType();
        if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() || planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()) {
            key = "testNetwork";
        } else if (planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() || planType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()) {
            key = "recoveryNetwork";
        }
        ProtectGroup protectGroup = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(this.getContextRef());
        RecoveryPlan plan = this.getContextRef().getRecoveryPlan();
        String networkSetting = (String)plan.getGlobalSettings().get(key);
        if (VerifyUtil.isEmpty((String)networkSetting)) {
            logger.info((Object)"networkSetting is empty");
            return;
        }
        Set pos = protectGroup.getPolist();
        for (ProtectObject protectObject : pos) {
            Map<String, VsNetWork> vmNetworkMap;
            boolean cfgNetRet;
            if (!this.poId.equals(protectObject.getUuid()) || (cfgNetRet = action.configVMNetWorks(this.vcenterUuid, this.vmMoId, vmNetworkMap = VsphereRecoveryUtils.getOneVMNetWork(protectObject, networkSetting), true))) continue;
            logger.error((Object)"enable net auto failed");
        }
    }

    private boolean monitorTask() {
        ManagedObjectReference task = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.taskId, "Task");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(this.vcenterUuid);
        MethodFault fault = new VsphereTaskResultMonitor(conn, task).monitorTaskResultAfterDone();
        if (!VerifyUtil.isEmpty((Object)fault)) {
            VMAction action = new VMAction();
            LegoCheckedException legoExc = action.getPowerOnLegoException(fault);
            this.updateProcessDetail(legoExc);
            logger.error((Object)("poweron vm failed:vmName=" + this.vmName), (Throwable)legoExc, 90160758786989L);
            return false;
        }
        logger.info((Object)("power on vm sucessfully:vmName=" + this.vmName), 90160758786988L);
        return true;
    }

    private boolean rebootVm() {
        boolean ret;
        try {
            VMAction action = new VMAction();
            ret = action.isVmToolInstalled(this.vcenterUuid, this.vmMoId);
            if (!ret) {
                logger.error((Object)("vmtools not installed:vmName" + this.vmName), 90160758786989L);
                this.updateProcessDetail("lego.err.1073948868", null);
                return false;
            }
            ret = this.waitForStarted();
            if (ret) {
                action.shutdownGuest(this.vcenterUuid, this.vmMoId);
                ret = this.checkVmShutdownResultAndWait(this.vmMoId);
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
            logger.error((Object)(this.vmName + " rebootVm  failed: "), (Throwable)e, 90160758786989L);
            ret = false;
        }
        catch (Exception e) {
            logger.error((Object)(this.vmName + " rebootVm  failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            ret = false;
        }
        logger.info((Object)(this.vmName + " rebootVm  result is " + ret), 90160758786988L);
        return ret;
    }

    private boolean waitForStarted() {
        boolean ret = false;
        VMAction action = new VMAction();
        try {
            for (int i = 0; i < 50; ++i) {
                VirtualMachineToolsRunningStatus state = action.getGuestVMToolState(this.vcenterUuid, this.vmMoId);
                if (VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING == state) {
                    logger.debug((Object)("start VM " + this.vmName + " sucessfully"), 90160758786988L);
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
            if (!ret) {
                this.updateProcessDetail(START_TIMEOUT, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("start vm start failed " + this.vmName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            ret = false;
        }
        catch (Exception e) {
            logger.error((Object)("start vm start failed " + this.vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return ret;
    }

    private boolean checkVmShutdownResultAndWait(String moId) {
        VMAction vmAction = new VMAction();
        boolean ret = false;
        try {
            for (int i = 0; i < 50; ++i) {
                VirtualMachinePowerState status = vmAction.getVMPowerState(this.vcenterUuid, moId);
                if (null != status && VirtualMachinePowerState.POWERED_OFF == status) {
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"shutdown  VM failed: thread interuptted", 90160758786989L);
            return false;
        }
        return ret;
    }

    public String getVmxPath() {
        return this.vmxPath;
    }

    public void setVmxPath(String vmxPath) {
        this.vmxPath = vmxPath;
    }

    public String getVmMoId() {
        return this.vmMoId;
    }

    public void setVmMoId(String vmMoId) {
        this.vmMoId = vmMoId;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public String getPoId() {
        return this.poId;
    }

    public void setPoId(String poId) {
        this.poId = poId;
    }

    public int getPreResult() {
        return this.preResult;
    }

    public void setPreResult(int preResult) {
        this.preResult = preResult;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isHasVmSnap() {
        return this.hasVmSnap;
    }

    public void setHasVmSnap(boolean hasVmSnap) {
        this.hasVmSnap = hasVmSnap;
    }
}

